include switches.inc


if pmw gt 0

.386                                    ;pmode/w
.model flat,prolog

extrn __psp:word
else

.386p
code32  segment para public use32       ;pmode/asm
                assume cs:code32, ds:code32
include pmode.inc
endif
locals


;switches
gamechannels = 4

;player
public rxmplay, rxmstop

;int control
public i8_init, i8_done
public maincount
public newhandler



b equ byte ptr
w equ word ptr

;
;struc
;
include rxmstruc.inc

tudata struc
 u_info         tdinfo ?

 u_command      dd ?

 u_reg52        dw ?

 u_mem          dd ?            ;0: 0K, 1: 256K, 2: 512K, 3: 768K, 4: 1M
 u_memblock     dd 4 dup(?)

 u_slen         dd ?
 u_extralen     dd ?
 u_memleft      dd ?
 u_fit          dd ?
 u_div          db ?

 u_volumes      db 257 dup(?)

 align 4
ends

talldata struc
 a_rxmdata      trxmdata ?
 a_udata        tudata ?
ends

;include \sprachen\c\h\debug.inc
if pmw gt 0
;
.data
;
endif

;mchan = 4
;mute db (mchan+1) dup(0), 1,32 dup(0)
;mute db 6 dup(0), 1, 32 dup(0)

rxmdata dd ?

pos   equ 0
neg   equ 1
sig   equ 2

t0    equ 4
t1_x  equ 8
tx    equ t0 + t1_x
keep  equ 16
keep2 equ 32

fxoptions label byte
db pos + t1_x                ; 0 //. Appregio
db pos + t1_x + keep         ; 1 //  Porta up
db neg + t1_x + keep         ; 2 //  Porta down
db pos + t0   + keep         ; 3 //  Fine porta up
db neg + t0   + keep         ; 4 //  Fine prota down
db pos + t0   + keep         ; 5 //  Extra fine porta up
db neg + t0   + keep         ; 6 //  Extra fine porta down
db pos + tx   + keep         ; 7 //  Tone porta
db pos                       ; 8 //   Set glissando control
db pos + tx   + keep2        ; 9 //  Vibrato
db pos        + keep         ;10 //   Set vibrato speed
db pos                       ;11 //   Set vibrato control
db pos + t0                  ;12 //. Set volume
db sig + t1_x                ;13 //  Volume slide up/down      *
db sig + t1_x + keep         ;14 //  Volume slide up/down
db sig + t0                  ;15 //  Fine volume slide up/down *
db pos + t0   + keep         ;16 //  Fine volume slide up
db neg + t0   + keep         ;17 //  Fine volume slide down
db pos + t1_x + keep2        ;18 //  Tremolo
db pos                       ;19 //   Set tremolo speed
db pos                       ;20 //   Set tremolo control
db pos + tx                  ;21 //  Note cut
db pos + t1_x + keep         ;22 //  Tremor
db pos + t0                  ;23 //  Set global volume
db sig + t1_x + keep         ;24 //  Global volume slide
db pos + t0                  ;25 //. Set panning
db sig + t1_x                ;26 //  Panning slide left/right  *
db sig + t1_x + keep         ;27 //  Panning slide left/right
db pos + t0                  ;28 //. Position jump
db pos + t0                  ;29 //  Pattern break
db pos + t0                  ;30 //  Pattern delay
db pos + t0                  ;31 //  Set loop begin/loop
db pos + t0                  ;32 //  Set tempo
db pos + t0                  ;33 //  Set bpm
db pos + t0   + keep         ;34 //. Sample offset
db pos + tx                  ;35 //  Note delay
db pos + t0                  ;36 //  Key off
db pos + t0                  ;37 //  Set envelope position
db pos + tx                  ;38 //  Retrig
db pos + tx   + keep2        ;39 //  Multi retrig

db 0                         ;40
db 0                         ;41
db 0                         ;42
db 0                         ;43
db 0                         ;44
db 0                         ;45
db 0                         ;46
db 0                         ;47
db pos + t0   + keep         ;48 //  Note & instrument

fxtab label dword
dd Appregio       - fxprocs  ; 0 //. Appregio
dd Addnote        - fxprocs  ; 1 //  Porta up
dd Addnote        - fxprocs  ; 2 //  Porta down
dd Addnote        - fxprocs  ; 3 //  Fine porta up
dd Addnote        - fxprocs  ; 4 //  Fine prota down
dd Addnotex       - fxprocs  ; 5 //  Extra fine porta up
dd Addnotex       - fxprocs  ; 6 //  Extra fine porta down
dd Toneporta      - fxprocs  ; 7 //  Tone porta
dd 0                         ; 8 //   Set glissando control (not supported)
dd Vibrato        - fxprocs  ; 9 //  Vibrato
dd 0                         ;10 //   Set vibrato speed
dd 0                         ;11 //   Set vibrato control
dd Setvol         - fxprocs  ;12 //. Set volume
dd Addvol         - fxprocs  ;13 //  Volume slide up/down
dd Addvol         - fxprocs  ;14 //  Volume slide up/down
dd Addvol         - fxprocs  ;15 //  Fine volume slide up/down
dd Addvol         - fxprocs  ;16 //  Fine volume slide up
dd Addvol         - fxprocs  ;17 //  Fine volume slide down
dd Tremolo        - fxprocs  ;18 //  Tremolo
dd 0                         ;19 //   Set tremolo speed
dd 0                         ;20 //   Set tremolo control
dd Notecut        - fxprocs  ;21 //  Note cut
dd Tremor         - fxprocs  ;22 //  Tremor
dd Setgvol        - fxprocs  ;23 //  Set global volume
dd Gvolslide      - fxprocs  ;24 //  Global volume slide
dd Setpan         - fxprocs  ;25 //. Set panning
dd Addpan         - fxprocs  ;26 //  Panning slide left/right
dd Addpan         - fxprocs  ;27 //  Panning slide left/right
dd Posjump        - fxprocs  ;28 //. Position jump
dd Patbreak       - fxprocs  ;29 //  Pattern break
dd Patdelay       - fxprocs  ;30 //  Pattern delay
dd Setloop        - fxprocs  ;31 //  Set loop begin/loop
dd Settempo       - fxprocs  ;32 //  Set tempo
dd Setbpm         - fxprocs  ;33 //  Set bpm
dd Sampleofs      - fxprocs  ;34 //. Sample offset
dd Notedelay      - fxprocs  ;35 //  Note delay
dd Keyoff         - fxprocs  ;36 //  Key off
dd Setenvpos      - fxprocs  ;37 //  Set envelope position
dd Retrig         - fxprocs  ;38 //  Retrig
dd Multiretrig    - fxprocs  ;39 //  Multi retrig
dd 0                         ;40 //   2nd param

dd 0                         ;41
dd 0                         ;42
dd 0                         ;43
dd 0                         ;44
dd 0                         ;45
dd 0                         ;46
dd 0                         ;47
dd Note_instr     - fxprocs  ;48 //  Note & instrument

;--- gus ---

if enhanced gt 0
iw_memconfig label dword
dd 00000001h ;0
dd 00000101h ;1
dd 01010101h ;2
dd 00000401h ;3
dd 04040401h ;4
dd 00040101h ;5
dd 04040101h ;6
dd 00000004h ;7
dd 00000404h ;8
dd 04040404h ;9
dd 00000010h ;A
dd 00001010h ;B
endif

;--- int ---

if pmw gt 0
public _seldata
oldint8    df 0       ;deinit nur wenn ungleich 0

else

opmirq     dd ?
ormirq     dd 0     ;deinit nur wenn ungleich 0
rmirqbuf   db 21 dup (?)
endif


c_1 = 65536

hnum = 4

handler label dword
dd hnum dup(0)
constant label dword
dd hnum dup(0)
counter label dword
dd hnum dup(0)

maincount dd 0


if pmw gt 0
.data?
alldata talldata ?

;
.code
;
_seldata dw ?

endif



rxmplay proc near
        ;-> esi -> tune

        push    esi
if pmw gt 0
        lea     edi,alldata             ;pmode/w
else
        mov     eax,size talldata       ;pmode/asm
        call    _getmem
        mov     edi,eax
endif
        mov     rxmdata,edi
        lea     esi,[edi + size trxmdata];esi -> tudata
        push    edi
        xor     eax,eax
        mov     ecx,(size talldata)/4
        rep     stosd

if pmw gt 0
        push    es
        mov     es,__psp
        mov     es,es:[2Ch]
        xor     edi,edi
else
        mov     edi,_pspa
        sub     edi,_code32a
        movzx   edi,word ptr [edi+2ch]  ;env-realmode-segment
        shl     edi,4
        sub     edi,_code32a
endif
                                        ;esi -> tudata (tdinfo)
        call    gusenv

if pmw gt 0
        pop     es
endif

        mov     edi,esi                 ;edi -> tudata (tdinfo)

        call    u_init
        or      eax,eax
        jnz     @@0
        add     esp,8
        jmp     @@weg
@@0:

        call    u_setvol

        pop     ebx                     ;ebx -> trxmdata
        mov     [ebx].s_drvmem,edi
        pop     esi                     ;esi -> tune

                ;header
        lea     edi,[ebx].head
        mov     ecx,size theader-256
        add     ecx,hdSonglen[esi]
        rep     movsb

        mov     edi,ebx                 ;edi -> trxmdata

if gamesound gt 0                       ;gamesounds
        mov     eax,[edi].head.hdChannels
        mov     [edi].pchannels,eax     ;pattern-channels
        add     eax,[edi].schannels     ;sound-channels
        mov     [edi].head.hdChannels,eax
endif
                ;pattern
        xor     ecx,ecx
@@pl:
        mov     [edi].pattern[ecx*4],esi
        add     esi,patSize[esi]
        inc     ecx
        cmp     ecx,[edi].head.hdPatterns
        jb      @@pl

                ;instruments
        xor     ecx,ecx
@@il:
        mov     al,iFollows[esi]
        movzx   edx,iSamples[esi]
        mov     ebx,esi                 ;ebx -> instrument
        add     esi,size tinstrh

        or      edx,edx                 ;0 samples?
        jz      @@next
        mov     [edi].instr[ecx*4],ebx  ;instrument speichern

        shr     al,1
        jnc     @@notesmp
        add     esi,size tnotesmp
@@notesmp:
        shr     al,1
        jnc     @@volenv
        movzx   ebx,envLastpoint[esi]
        lea     esi,[esi + (size tenvelope)+2 - 11*4 + ebx*4]
                                        ;+2 wegen fadeout
@@volenv:
        shr     al,1
        jnc     @@panenv
        movzx   ebx,envLastpoint[esi]
        lea     esi,[esi + (size tenvelope) - 11*4 + ebx*4]
@@panenv:
        shr     al,1
        jnc     @@vibrato
        add     esi,size tvibrato
@@vibrato:
                                        ;edx = number of samples
                ;samples
        mov     [edi].sample[ecx*4],esi
@@sl:
;        test    [edi].head.hdFlags,xmConverted
;        jnz     @@se

        push    ecx
        mov     ebx,sDataptr[esi]
        add     ebx,esi
        mov     sDataptr[esi],ebx

        mov     ecx,[esi].sLoope
        add     ecx,Xtra

        xor     eax,eax

ifndef no16bit
        test    sType[esi],sf16bit
        jnz     @@16l
endif
            ;8bit
@@8l:
        add     al,[ebx]
        mov     [ebx],al
        inc     ebx
        dec     ecx
        jnz     @@8l
ifndef no16bit
        jmp     @@8

@@16l:          ;16bit
        add     ax,[ebx]
        mov     [ebx],ax
        inc     ebx
        inc     ebx
        dec     ecx
        jnz     @@16l
endif
@@8:
        pop     ecx
@@se:
        add     esi,size tsampleh
        dec     edx
        jnz     @@sl
@@next:
        inc     ecx
        cmp     ecx,[edi].head.hdInstruments
        jb      @@il


                ;frequency table
        mov     ebx,2149422703          ;faktor    = 7682 * 2^31
                                        ; 12 noten, 64 finetuneschritte
        mov     eax,1096155136          ;startwert = 535232 * 2^11
                                        ; 8363*2^6, frequenz fr C-10
        xor     ecx,ecx
@@fl:
ifndef no2tabs
        test    [edi].head.hdFlags,xmLinear
        jnz     @@linear
endif
ifndef noAmiga  ;amiga
        mov     esi,eax
                                        ;period = 8363*1712/frequency
        mov     eax,0C83B0000h          ;8363*1712 * 2^(11+12) = 6D3BC83B0000h
        mov     edx,6D3Bh
        div     esi
        mov     [edi].freq[ecx*4],eax
        mov     eax,esi
endif
ifndef no2tabs
        jmp     @@fl0
@@linear:
endif
ifndef noLinear ;linear
        mov     edx,eax                 ;ergebnis mit 11 nachkommabits
        shr     edx,11
        mov     [edi].freq[ecx*4],edx
endif
@@fl0:
        mul     ebx
        shrd    eax,edx,31              ;31 nachkommabits des faktors

        inc     ecx
        cmp     ch,3                    ;bis 768
        jb      @@fl

                ;appregio-mul-tab (nur amiga)
ifndef noAmiga
        mov     ebx,69433               ;faktor    = 122 * 2^16
        mov     eax,65536               ;startwert = 1 * 2^16
        xor     ecx,ecx
@@at:
        mov     edx,eax
        shr     edx,8
        mov     [edi].apptab[ecx*4],edx
        mul     ebx
        shrd    eax,edx,16
        inc     ecx
        cmp     cl,16
        jb      @@at
endif

                ;vibrato tables
        mov     ecx,127
@@vl1:          ;sinus berechnung (f(x) = 64 - ((x-64)*2)^2 / 256
        lea     eax,[(ecx-64)*2]
        imul    eax
        sub     ah,64
        mov     [edi].vibrato[ecx+128],ah
        neg     ah
        mov     [edi].vibrato[ecx],ah
        dec     ecx
        jns     @@vl1


        mov     ecx,255
@@vl2:          ;
        mov     al,cl
        sar     al,1
        mov     [edi].vibrato[ecx+768],al ;ansteigend
        neg     al
        mov     [edi].vibrato[ecx+512],al ;abfallend
        neg     al
        and     al,80h
        add     al,40h
        mov     [edi].vibrato[ecx+256],al ;rechteck
        dec     ecx
        jns     @@vl2

        mov     [edi].globalvol,64
        mov     [edi].p_break,1
;        mov     [edi].p_pos,0           ;start-pattern
;        mov     [edi].p_rowcnt,0
;        mov     [edi].t_tick,0
        mov     eax,[edi].head.hdBPM
        call    Setbpm

if gamesound gt 0
        mov     [edi].schannels,gamechannels
;        mov     [edi].nextchan,0
endif

        push    edi
        mov     esi,edi
        mov     edi,[esi].s_drvmem
        call    u_play
        pop     edi

        mov     [edi].xmstatus,xmPlay   ;starten
@@weg:  ret
rxmplay endp

rxmstop proc near
        ;-> eax = xmFade or xmStop
        mov     edi,rxmdata

        cmp     [edi].xmstatus,xmOff
        je      @@weg

        mov     [edi].xmstatus,al;xmFade

@@0:    cmp     [edi].xmstatus,xmOff
        jne     @@0

        call    u_done
@@weg:
        ret
rxmstop endp




foreach proc near
        ;-> esi -> rxmdata
        ;-> edx -> callback

        mov     ecx,[esi].head.hdInstruments
        jmp     @@iweg

@@i_l:  mov     ebx,[esi].instr[ecx*4]
        or      ebx,ebx
        jz      @@iweg

        push    esi
        mov     esi,[esi].sample[ecx*4]

        push    ecx
        movzx   ecx,iSamples[ebx]
                ;instrument-schleife
@@s_l:  push    ecx edx esi

        call    edx                     ;esi -> tsampleh

        pop     esi edx ecx
        add     esi,size tsampleh
        dec     ecx
        jnz     @@s_l

        pop     ecx esi                 ;esi -> trxmdata

@@iweg: dec     ecx
        jns     @@i_l

        ret
foreach endp
;------ player

tick proc near
        ;-> edi -> trxmdata
;    mov eax,'tick'
;    call str_
;ifndef gusOnly
;        mov     eax,[edi].t_usec
;        call    add_time
;endif
        call    do_flags

        cmp     [edi].xmstatus,xmFade
        jb      @@s
                ;xm luft
        cmp     [edi].t_tick,0
        jne     @@0
                ;tick 0
        mov     [edi].t_extra,0
        call    do_pattern

@@0:            ;tick 0 - x
if gamesound gt 0                       ;gamesounds
        call    gamesounds
endif
        call    do_fx
        call    do_misc

        inc     [edi].t_tick            ;nchster tick
        mov     eax,[edi].head.hdSpeed
        add     eax,[edi].t_extra
        cmp     eax,[edi].t_tick
        jne     @@1
        mov     [edi].t_tick,0
@@1:

        cmp     [edi].xmstatus,xmFade
        jne     @@weg
                ;xm wird ausgefadet
        dec     [edi].globalvol
        jns     @@weg                   ;lautstrke bei 0 angekommen
        dec     [edi].xmstatus
        jmp     @@weg

@@s:            ;xm stoppen
        cmp     [edi].xmstatus,xmOff
        je      @@weg
        cmp     [edi].xmstatus,xmStop
        jne     @@d

        lea     esi,[edi].chdata        ;kanal-informationen lschen
        mov     ecx,[edi].head.hdChannels
@@l:
        test    caktiv[esi],afPlay
        jz      @@5
        xor     caktiv[esi],afPlay or afStop
@@5:
        add     esi,size tchannel
        dec     ecx
        jnz     @@l
@@d:
        dec     [edi].xmstatus


@@weg:  ret
tick endp


do_flags proc near
        lea     esi,[edi].chdata
        mov     ecx,[edi].head.hdChannels
@@ch_l:
        mov     eax,cfinalvol[esi]
        mov     cofinalvol[esi],eax
        mov     eax,crevol[esi]
        mov     corevol[esi],eax
        mov     eax,clivol[esi]
        mov     colivol[esi],eax
        test    caktiv[esi],afStart    ;start -> play
        jz      @@start
        xor     caktiv[esi],afStart or afPlay
@@start:

        and     caktiv[esi],not (afStop + afVol) ;stop -> inaktiv

        add     esi,size tchannel
        dec     ecx
        jg      @@ch_l

        ret
do_flags endp


do_pattern proc near
;     mov eax,[edi].p_pos
;     call hex_
;     mov eax,[edi].p_rowcnt
;     call hex_

        mov     ecx,[edi].p_rowcnt
        mov     ebp,[edi].p_rows
        mov     ebx,[edi].p_pos
        mov     edx,[edi].p_offs

        shr     [edi].p_break,1
        jc      @@new

        inc     ecx                     ;ecx = p_rowcnt
@@1:    cmp     ecx,ebp                 ;ebp = p_rows
        jb      @@cont
        inc     ebx                     ;ebx = p_pos
        xor     ecx,ecx                 ;ecx = p_rowcnt
@@new:          ;new pattern
        mov     [edi].p_breakrow,ecx
        mov     [edi].p_bufc,0
        cmp     ebx,[edi].head.hdSonglen
        jb      @@next
                ;restart
        mov     ebx,[edi].head.hdRestart  ;ebx = p_pos
@@next:
        movzx   edx,[edi].head.hdPtable[ebx]
                mov     edx,[edi].pattern[edx*4]
        mov     ebp,64
        or      edx,edx
        jz      @@empty

        mov     ebp,patRows[edx]
        mov     eax,patSize[edx]
        add     edx,size tpatternh
        cmp     eax,size tpatternh
        ja      @@1
@@empty:
        xor     edx,edx
@@cont:         ;continue
        mov     [edi].p_rowcnt,ecx
        mov     [edi].p_rows,ebp
        mov     [edi].p_pos,ebx
@@bseek:
        lea     esi,[edi].chdata
if gamesound gt 0                       ;gamesounds
        mov     ecx,[edi].pchannels
else
        mov     ecx,[edi].head.hdChannels
endif

@@ch_l: push    ecx

                ;read number of effects
        xor     eax,eax
        mov     cnote[esi],al
        or      edx,edx                 ;edx -> pattern-data
        jz      @@e                     ;pattern empty
        mov     al,[edx]
        inc     edx
@@e:

        mov     cnofx[esi],al
        mov     ecx,eax
        jmp     @@end
@@fxl:
        movzx   eax,word ptr [edx]
        inc     edx
        inc     edx
        test    al,80h
        jz      @@fx
                                ;note & instrument
        and     al,7Fh
        mov     cnote[esi],al
        mov     al,48
@@fx:           ;effect
        mov     cfx[esi+ecx],al
        mov     cparams[esi+ecx],ah

@@end:
        dec     ecx
        jns     @@fxl
        mov     ctick0[esi],1           ;tick 0 indicator

                ;next channel
        pop     ecx
        add     esi,size tchannel
        dec     ecx
        jnz     @@ch_l

        dec     [edi].p_breakrow
        jns     @@bseek

        mov     [edi].p_offs,edx

@@weg:  ret
do_pattern endp


do_fx proc near
        lea     esi,[edi].chdata
        mov     ecx,[edi].head.hdChannels
@@ch_l:
        push    ecx
                ;init
        mov     crelnote[esi],0

        movzx   ecx,cnofx[esi]
        jmp     @@end

@@fxl:          ;loop
        movzx   ebx,cfx[esi+ecx]
        mov     dl,fxoptions[ebx]

        cmp     ctick0[esi],0           ;tick 0 ?
        je      @@t1_x
                ;tick 0
        mov     al,cparams[esi+ecx]

        test    dl,keep or keep2        ;keep param if zero?
        jz      @@nokeep
        or      al,al                   ;is param zero?
        jz      @@keep
        test    dl,keep2                ;keep double param?
        jz      @@nokeep

        mov     ah,al
        shr     ah,4
        jz      @@keep2
        mov     coldparams[esi+ebx+1],ah;next entry for second param
@@keep2:
        and     al,0Fh
        jz      @@keep
@@nokeep:
        mov     coldparams[esi+ebx],al
@@keep:
        test    dl,t0
        jz      @@end
        jmp     @@param

@@t1_x: test    dl,t1_x
        jz      @@end

@@param:
        movzx   eax,coldparams[esi+ebx]
        test    dl,neg
        jnz     @@neg
        test    dl,sig
        jz      @@exec
                ;param is signed
        movsx   eax,al
        neg     eax                     ;jmp @@exec
@@neg:          ;negate param
        neg     eax
@@exec:
        ;call    fxtab[ebx*4]
        mov     edx,fxtab[ebx*4]
        add     edx,offset fxprocs
        call    edx                     ;eax = param, ebx = fx-no

@@end:
        dec     ecx
        jns     @@fxl
        mov     ctick0[esi],0

        pop     ecx

        add     esi,size tchannel
        dec     ecx
        jnz     @@ch_l

@@weg:  ret
do_fx endp


fxprocs:

ifdef noAppregio
Appregio:
endif
ifdef noToneporta
Toneporta:
endif
ifdef noVibrato
Vibrato:
endif
ifdef noTremolo
Tremolo:
endif
;ifdef noNotecut
;Notecut:
;endif
ifdef noTremor
Tremor:
endif
;ifdef noGvolslide
;Gvolslide:
;endif
ifdef noPosjump
Posjump:
endif
ifdef noPatbreak
Patbreak:
endif
ifdef noPatdelay
Patdelay:
endif
ifdef noSetloop
Setloop:
endif
ifdef noSettempo
Settempo:
endif
ifdef noSampleofs
Sampleofs:
endif
ifdef noNotedelay
Notedelay:
endif
ifdef noKeyoff
Keyoff:
endif
ifdef noSetenvpos
Setenvpos:
endif
ifdef noRetrig
Retrig:
endif
ifdef noMultiretrig
Multiretrig:
endif
emptyproc:
ret

ifndef noAppregio
Appregio proc near
        mov     edx,[edi].t_tick
@@d:    sub     edx,3
        ja      @@d
        jz      @@weg
        inc     edx
        jz      @@z2
                ;zyklus 1
        shr     eax,4
@@z2:           ;zyklus 2
        and     al,0Fh

ifndef noAmiga
                ;amiga
        mov     cappmul[esi],eax
endif

ifndef no2tabs
        test    [edi].head.hdFlags,xmLinear
        jz      @@weg
endif

ifndef noLinear
                ;linear
        shl     eax,6
        add     crelnote[esi],eax
endif

@@weg:  ret
Appregio endp
endif


Addnote proc near
        shl     eax,2
Addnotex:
        add     crnote[esi],eax         ;"anschlag" in final_val
        ret
Addnote endp


ifndef noToneporta
Toneporta proc near
        cmp     ctick0[esi],1           ;tick 0?
        jne     @@1_x
        movzx   eax,cnote[esi]
        dec     eax
        js      @@weg
        sal     eax,6                   ;64 finetune-schritte
        add     eax,ctune[esi]          ;tuning-anteil der alten note
ifndef noAmiga
        call    note2amiga
endif
        mov     cportad[esi],eax        ;ziel-realnote
        mov     cnote[esi],0            ;note lschen
        jmp     @@weg
@@1_x:
        shl     eax,2

        mov     ebx,cportad[esi]
        or      ebx,ebx
        jz      @@weg

        cmp     ebx,crnote[esi]
        jl      @@t
                ;ziel liegt hher (vorzeichenbehaftete zahlen)
        add     crnote[esi],eax
        cmp     ebx,crnote[esi]         ;ebx:ziel
        jg      @@weg
                ;ber ziel hinaus
        jmp     @@0
@@t:            ;ziel liegt tiefer
        sub     crnote[esi],eax
        cmp     ebx,crnote[esi]         ;ebx:ziel
        jl      @@weg
                ;unter ziel
@@0:    mov     crnote[esi],ebx

@@weg:  ret
Toneporta endp
endif


ifndef noVibrato
Vibrato proc near
        ;ebx -> effekt-nummer
        movzx   edx,cvibofs[esi]
        mov     dh,coldparams[esi+ebx+2];vibrato control
        and     dh,3
        movsx   edx,[edi].vibrato[edx]
        imul    edx
        sar     eax,3
        sub     crelnote[esi],eax

        cmp     [edi].t_tick,0
        je      @@weg
        mov     dl,coldparams[esi+ebx+1];vibrato speed
        shl     dl,2
        add     cvibofs[esi],dl
@@weg:  ret
Vibrato endp
endif


Setvol proc near

        or      caktiv[esi],afVol
        mov     cvol[esi],eax
        mov     crelvol[esi],0
        ret
Setvol endp


Addvol proc near
        add     eax,cvol[esi]
        jns     @@0
        xor     eax,eax
@@0:    cmp     eax,40h
        jbe     @@1
        mov     eax,40h
@@1:
        mov     cvol[esi],eax
        mov     crelvol[esi],0
        ret
endp


ifndef noTremolo
Tremolo proc near
        movzx   edx,ctreofs[esi]
        mov     dh,coldparams[esi+ebx+2];tremolo control
        and     dh,3
        movsx   edx,[edi].vibrato[edx]
        imul    edx
        sar     eax,4
        mov     crelvol[esi],eax

        mov     dl,coldparams[esi+ebx+1];tremolo speed
        shl     dl,2
        add     ctreofs[esi],dl
        ret
endp
endif


Notecut proc near
ifndef noNotecut
        cmp     eax,[edi].t_tick
        jne     @@weg
endif
Voloff:
        or      caktiv[esi],afVol
        mov     cvol[esi],0
        mov     crelvol[esi],0
@@weg:  ret
endp


ifndef noTremor
Tremor proc near
        mov     edx,eax
        and     eax,0Fh
        shr     edx,4
        inc     eax
        inc     edx
        add     edx,eax

        mov     ebx,[edi].t_tick
@@d:    sub     ebx,edx
        ja      @@d
        neg     ebx
        or      caktiv[esi],afVol
        mov     crelvol[esi],-64
        cmp     ebx,eax
        jb      @@weg
        mov     crelvol[esi],0
@@weg:  ret
endp
endif


Gvolslide proc near
ifndef noGvolslide
        add     eax,[edi].globalvol
        jns     @@0
        xor     eax,eax
@@0:    cmp     eax,40h
        jbe     @@1
        mov     eax,40h
@@1:
endif
Setgvol:
        cmp     [edi].xmstatus,xmPlay
        jne     @@weg
        mov     [edi].globalvol,eax
@@weg:  ret
endp


Addpan proc near
        add     eax,cpan[esi]
        or      ah,ah
        jz      @@0
        sar     eax,31
        inc     eax
        neg     al
@@0:
Setpan:
        mov     cpan[esi],eax
        ret
endp


ifndef noPosjump
Posjump proc near
        mov     [edi].p_break,1           ;1: neues pattern
        mov     [edi].p_pos,eax           ;neue song-position
        mov     [edi].p_rowcnt,0
        ret
endp
endif


ifndef noPatbreak
Patbreak proc near
        cmp     [edi].p_break,0
        jne     @@0
        inc     [edi].p_pos               ;nchstes pattern
@@0:
        mov     [edi].p_break,1           ;1: neues pattern
        mov     [edi].p_rowcnt,eax
        ret
endp
endif


ifndef noPatdelay
Patdelay proc near
        imul    eax,[edi].head.hdSpeed
        mov     [edi].t_extra,eax
        ret
endp
endif


ifndef noSetloop
Setloop proc near
        or      eax,eax
        jnz     @@0
                ;position merken
        mov     eax,[edi].p_rowcnt
        mov     [edi].p_looppos,eax
        jmp     @@weg
@@0:
        cmp     [edi].p_loopcnt,0
        jg      @@1
        inc     eax
        mov     [edi].p_loopcnt,eax
@@1:
        dec     [edi].p_loopcnt
        jz      @@weg
                ;springen
        mov     [edi].p_break,1
        mov     eax,[edi].p_looppos
        mov     [edi].p_rowcnt,eax
@@weg:  ret
endp
endif


ifndef noSettempo
Settempo proc near
        or      eax,eax
        jnz     @@0
                ;end
        mov     [edi].p_break,1
        mov     eax,[edi].head.hdRestart
        mov     [edi].p_pos,eax
        mov     [edi].p_rowcnt,0
        jmp     @@weg
@@0:            ;set speed
        mov     [edi].head.hdSpeed,eax
@@weg:  ret
endp
endif


Setbpm proc near
;        mov     ebx,eax
;        mov     eax,1000 * 5/2 * 256
;        xor     edx,edx
;        div     ebx                     ;eax = dauer eines ticks in s
;        mov     [edi].t_usec,eax

;        imul    eax,ebx,65536*2/5       ;frequenz = BPM*2/5
        imul    eax,65536*2/5       ;frequenz = BPM*2/5

        jmp     u_bpm
endp


ifndef noSampleofs
Sampleofs proc near
ifdef noResample
        shl     eax,8
else
        push    ecx
        mov     cl,8
        sub     cl,cresample[esi]
        shl     eax,cl
        pop     ecx
endif
        add     csample[esi],eax

        ;cmp     eax,cloope[esi]
        ;jae     @@weg                   ;ber ende hinaus
        ;mov     cpos[esi],eax
@@weg:  ret
endp
endif


ifndef noNotedelay
Notedelay proc near
        cmp     eax,[edi].t_tick
        jb      @@weg
        je      @@0
        xor     ecx,ecx
        jmp     @@weg
@@0:    mov     ctick0[esi],1           ;simulate tick 0

@@weg:  ret
endp
endif


ifndef noKeyoff
Keyoff proc near
        test    caktiv[esi],afAktiv     ;kanal aktiv?
        jz      @@weg

        and     caktiv[esi],not afSustain

        mov     ebx,cinstrh[esi]        ;gltig weil aktiv
        test    iFollows[ebx],2         ;ffVolenv
        jz      Voloff

@@weg:  ret
Keyoff endp
endif


ifndef noSetenvpos
Setenvpos proc near
        test    caktiv[esi],afAktiv     ;kanal aktiv?
        jz      @@weg

        mov     ebx,cinstrh[esi]        ;ebx -> instrument

        mov     dl,iFollows[ebx]
        add     ebx,size tinstrh

        shr     dl,1
        jnc     @@notesmp
        add     ebx,size tnotesmp
@@notesmp:
                ;volume envelope
        shr     dl,1
        jnc     @@weg

        xor     edx,edx
@@l:
        cmp     dl,envLastpoint[ebx]
        jae     @@end
        inc     edx
        movzx   ebp,envPoint[ebx+edx*4]
        sub     eax,ebp
        ja      @@l
@@end:
        add     eax,ebp
        mov     cvolp[esi],edx
        mov     cvolc[esi],ax

@@weg:  ret
endp
endif


ifndef noRetrig
Retrig proc near
        test    caktiv[esi],afPlay
        jz      @@weg

        mov     edx,[edi].t_tick

        or      eax,eax                 ;eax = param
        jnz     @@d
        or      edx,edx                 ;wenn param = 0: retrig bei tick 0
        jnz     @@weg
@@d:
        sub     edx,eax
        ja      @@d
        jnz     @@weg

                ;retrig
        xor     caktiv[esi],afStart or afPlay or afStop

        mov     ebx,csampleh[esi]       ;ebx -> sample header
        mov     eax,sOffset[ebx]
        mov     csample[esi],eax

@@weg:  ret
endp
endif


ifndef noMultiretrig
Multiretrig proc near
;        test    caktiv[esi],afAktiv     ;kanal aktiv?
;        je      @@weg

        inc     cmulti[esi]
        cmp     cmulti[esi],eax
        jb      @@weg
        xor     eax,eax
        mov     cmulti[esi],eax
        mov     crelvol[esi],eax

                ;volume change          ;eax = 0
        push    ecx
        mov     dl,coldparams[esi+ebx+1];dl: volume parameter
        mov     cl,dl
        and     cl,7
        jz      @@w
                cmp     cl,6
        jae     @@0
                ;-1 .. -16 , +1 .. +16
        inc     eax
        test    dl,8
        jnz     @@1
        neg     eax
@@1:
        dec     cl
        shl     eax,cl
        add     eax,cvol[esi]
        jns     @@vol
        xor     eax,eax
        jmp     @@vol

@@0:            ;*2/3, *1/2, *3/2, *2/1
        mov     eax,2
        mov     ebx,3
        test    edx,1
        jz      @@2
        dec     eax
        dec     ebx
@@2:
        test    edx,8
        jz      @@3
        xchg    eax,ebx
@@3:
        imul    cvol[esi]
        idiv    ebx

@@vol:  mov     edx,40h
        cmp     eax,edx
        ja      @@v0
        mov     edx,eax
@@v0:   mov     cvol[esi],edx
@@w:    pop     ecx

                ;retrig
        test    caktiv[esi],afPlay
        jz      @@weg

        xor     caktiv[esi],afStart or afPlay or afStop

        mov     ebx,csampleh[esi]       ;edx -> sample header
                mov     eax,sOffset[ebx]
        mov     csample[esi],eax

@@weg:  ret
endp
endif


Note_instr proc near
        ;-> eax = saved 1-based instrument number

        dec     eax
        js      @@weg                   ;no current instrument

        movzx   edx,cnote[esi]          ;edx = note
        dec     edx
        js      @@instr

                ;neue note
        test    caktiv[esi],afPlay      ;altes sample ggf. stoppen
        jz      @@stop
        xor     caktiv[esi],afPlay or afStop
@@stop:

        mov     ebx,[edi].instr[eax*4]
        mov     cinstrh[esi],ebx        ;ebx -> instrument

        or      ebx,ebx
        jz      @@weg                   ;empty instrument

                ;neues sample
        test    iFollows[ebx],1         ;dh = 0
        jz      @@0
        mov     dh,Notesmp[ebx+edx+(size tinstrh)]
@@0:
        cmp     dh,iSamples[ebx]        ;empty sample
        jae     @@weg

        mov     ebx,[edi].sample[eax*4]
        jmp     @@ss
@@sl:           ;search sample
        add     ebx,size tsampleh ;sLength[ebx]
@@ss:   dec     dh
        jns     @@sl
        inc     dh                      ;dh = 0, dl = note

        mov     csampleh[esi],ebx       ;ebx -> sample header

                ;sample-variablen
        mov     eax,sOffset[ebx]        ;offset = -1: sample nicht geladen
        cmp     eax,-1
        je      @@weg
        mov     csample[esi],eax
        mov     ebp,eax
        add     eax,sLoops[ebx]
        mov     cloops[esi],eax
        add     ebp,sLoope[ebx]
        mov     cloope[esi],ebp

        mov     al,sType[ebx]
        mov     ctype[esi],al

ifndef noResample
        mov     al,sResample[ebx]
        mov     cresample[esi],al
endif
                ;real-note berechnen
        shl     edx,6                   ;64 finetune-schritte

        movsx   ebp,sRelnote[ebx]       ;relative note (ebx -> sample-header)
        sal     ebp,6
        movsx   eax,sFinetune[ebx]      ;finetune
        add     eax,ebp
        add     eax,2*12*64
        mov     ctune[esi],eax          ;tuning-anteil

        add     eax,edx
ifndef noAmiga
        call    note2amiga
endif
        mov     crnote[esi],eax         ;real-note

                ;kanal aktivieren
        or      caktiv[esi],afStart; or afSustain
@@nweg:

@@instr:;instrument bezogene nderungen (sustain, volume, envelope ,vibrato)
        xor     edx,edx                 ;edx = 0
        cmp     cparams[esi+ecx],dl     ;instrument-nummer vorhanden?
        je      @@weg

                ;sustain
        or      caktiv[esi],afSustain

                ;volume reset
        mov     cvol[esi],edx           ;edx = 0
        mov     crelvol[esi],edx
        mov     cfadeoutvol[esi],32768

                ;envelope reset
        mov     cvolc[esi],dx
        mov     cvolp[esi],edx
        mov     cpanc[esi],dx
        mov     cpanp[esi],edx
                ;autovibrato reset
        mov     cavofs[esi],dl          ;autovibrato-tabellenoffset
        mov     cswcnt[esi],edx         ;sweep-count

                ;vibrato reset
        test    coldparams[esi+11],4
        jnz     @@vib
        mov     cvibofs[esi],dl         ;vibrato reset
@@vib:
                ;tremolo reset
        test    coldparams[esi+20],4
        jnz     @@tre
        mov     ctreofs[esi],dl
@@tre:

        test    caktiv[esi],afAktiv     ;kanal aktiv?
        jz      @@weg

        mov     ebx,csampleh[esi]       ;ebx -> sample-header (gltig weil aktiv)
                ;volume & panning
        movzx   eax,sVol[ebx]
        mov     cvol[esi],eax
        movzx   eax,sPan[ebx]
                mov     cpan[esi],eax

@@weg:  ret
Note_instr endp

ifndef noAmiga
note2amiga proc near
        ;-> eax = realnote
        ;<- eax = amiga-period *(-1)
ifndef no2tabs
        test    [edi].head.hdFlags,xmLinear
        jnz     @@weg
endif
        push    ecx
        or      eax,eax
        jns     @@0
        xor     eax,eax
@@0:
        xor     edx,edx
        mov     ecx,12*64
        div     ecx

        mov     ecx,eax

        mov     eax,[edi].freq[edx*4]
        shr     eax,cl
        neg     eax
        pop     ecx

@@weg:  ret
note2amiga endp
endif

do_misc proc near
        lea     esi,[edi].chdata
        mov     ecx,[edi].head.hdChannels
@@ch_l: push    ecx

;    mov ebx,[edi].head.hdChannels
;    sub ebx,ecx
;    cmp mute[ebx],0
;    je @@next

        test    caktiv[esi],afAktiv     ;kanal aktiv?
        jz      @@next

                ;final volume
        mov     edx,cvol[esi]
        xor     eax,eax
        add     edx,crelvol[esi]        ;0-64
        js      @@0
        mov     eax,64
        cmp     edx,eax
        ja      @@0
        mov     eax,edx
@@0:
        imul    [edi].globalvol         ;global volume
        shr     eax,6-2
        mov     cfinalvol[esi],eax      ;0-256
                ;final pan
        mov     eax,cpan[esi]
        mov     cfinalpan[esi],eax

        mov     ebx,cinstrh[esi]        ;ebx -> instrument (gltig weil aktiv)
        mov     al,iFollows[ebx]
        add     ebx,size tinstrh

        shr     al,1
        jnc     @@notesmp
        add     ebx,size tnotesmp
@@notesmp:
                ;volume envelope
        shr     al,1
        mov     [edi].tempvar,al        ;tempvar = iFollows
        jnc     @@volenv
        mov     ecx,cvolp[esi]
        mov     bp,cvolc[esi]
        call    envelope
        mov     cvolp[esi],ecx
        mov     cvolc[esi],bp
        movzx   edx,envLastpoint[ebx]
        lea     ebx,[ebx + (size tenvelope)+2 - 11*4 + edx*4]
                ;fade-out
        mov     edx,cfadeoutvol[esi]
        test    caktiv[esi],afSustain   ;sustain?
        jnz     @@v1
        movzx   ebp,word ptr [ebx-2]
                sub     edx,ebp
        jns     @@v0
        xor     edx,edx
@@v0:   mov     cfadeoutvol[esi],edx

@@v1:   imul    edx

        imul    cfinalvol[esi]
        shrd    eax,edx,8+15            ;8 for finalvol, 15 for fadeout
        mov     cfinalvol[esi],eax
@@volenv:

                ;panning envelope
        shr     [edi].tempvar,1
        jnc     @@panenv
        mov     ecx,cpanp[esi]
        mov     bp,cpanc[esi]
        call    envelope
        mov     cpanp[esi],ecx
        mov     cpanc[esi],bp
        movzx   edx,envLastpoint[ebx]
        lea     ebx,[ebx + (size tenvelope) - 11*4 + edx*4]
                ;FinalPan=Pan+(EnvelopePan-128)*(128-Abs(Pan-128))/128;
        mov     edx,cfinalpan[esi]
        mov     ebp,edx
        sub     edx,128
        js      @@p0
        neg     edx
@@p0:   add     edx,128                 ;edx = 128-Abs(Pan-128)

        sub     eax,128
        imul    edx
        sar     eax,7
        add     eax,ebp
        mov     cfinalpan[esi],eax
@@panenv:

        shr     [edi].tempvar,1
        jnc     @@avib
                ;auto vibrato
                movzx   edx,cavofs[esi]
        mov     al,vibRate[ebx]
        add     cavofs[esi],al

        mov     dh,vibType[ebx]
        movsx   eax,[edi].vibrato[edx]    ;wert aus tabelle
        movzx   edx,vibDepth[ebx]
        imul    edx                     ;vibrato-wert * depth

        movzx   ebp,vibSweep[ebx]
        or      ebp,ebp
        jz      @@a0                    ;vibrato-sweep = 0
        mov     edx,cswcnt[esi]
        cmp     edx,ebp
        ja      @@a0
                ;sweep-count noch nicht zu ende
        test    caktiv[esi],afSustain   ;bei "vorzeitigem" release:
        jz      @@avib                  ;kein vibrato mehr
        inc     cswcnt[esi]
        imul    edx                     ;vibrato-wert * sweep-count
        idiv    ebp                     ;/vibrato-sweep
@@a0:           ;sweep-count zu ende
        sar     eax,6                   ;/64
        add     crelnote[esi],eax
@@avib:
                ;inc-val
ifndef no2tabs
        test    [edi].head.hdFlags,xmLinear
        jnz     @@linear
endif
ifndef noAmiga  ;amiga
        mov     ebx,crnote[esi]
        add     ebx,crelnote[esi]
        neg     ebx
                                        ;8363*1712/max-frequenz = min-period
        mov     eax,1070464             ;max-frequenz (C-11) = 8363*2^7
        cmp     ebx,14                  ;min-period = 14
        jl      @@f0
        mov     eax,8363*1712           ;frequenz = 8363*1712/period
        xor     edx,edx
        div     ebx
        cmp     eax,131                 ;8363*2^(-6) (C-(-2)) = min-frequenz
        ja      @@f0
        mov     eax,131
@@f0:                                   ;eax = frequenz
        mov     ebx,cappmul[esi]
        mul     [edi].apptab[ebx*4]
        mov     cappmul[esi],0
ifndef noResample
        mov     cl,cresample[esi]
        shr     eax,cl
endif
endif
ifndef no2tabs
        jmp     @@f3
@@linear:
endif
ifndef noLinear ;linear
        mov     eax,crnote[esi]
        add     eax,crelnote[esi]
        jns     @@f1
        xor     eax,eax
@@f1:

        xor     edx,edx
        mov     ecx,12*64
        div     ecx

        mov     ecx,12
        sub     ecx,eax
        jns     @@f2
        mov     edx,12*64-1
        xor     ecx,ecx
@@f2:
        mov     eax,[edi].freq[edx*4]
        shl     eax,8
ifndef noResample
        add     cl,cresample[esi]
endif
        shr     eax,cl
endif
@@f3:
        mul     [edi].s_freqmul
        mov     cincval[esi],edx

              ;reverse stereo
;      mov     ebx,[edi].s_drvmem
;      test    [ebx].d_flags,dfReverse
;      jz      @@next
;      not     byte ptr cfinalpan[esi]
@@next:         ;nchster kanal
        pop     ecx
        add     esi,size tchannel
        dec     ecx
        jnz     @@ch_l

@@weg:  ret
do_misc endp


envelope proc near
        ;-> ebx -> tenvelope
        ;-> ecx = envelope segment (=1 fr 1. intervall)
        ;-> bp  = segment count
        ;<- eax = envelope value
        ;<- ecx = new nevelope segment
        ;<- bp  = new segment count
        movzx   eax,envPoint[ebx+ecx*4+2]

        cmp     bp,envPoint[ebx+ecx*4]
        jae     @@point
                ;between 2 points       ;iy = ay + ix * (by-ay)
                                        ;          --
                                        ;          bx
        sub     ax,envPoint[ebx+ecx*4-2];ax = (by-ay)
        imul    bp                      ;     *ix
        idiv    envPoint[ebx+ecx*4]     ;     /bx
        add     ax,envPoint[ebx+ecx*4-2];     +ay
        jmp     @@inc

@@point:        ;on a point

                ;S
        test    caktiv[esi],afSustain   ;Sustain?
        setnz   dl

                ;LP
        cmp     cl,envLoope[ebx]        ;on loop-end-point?
        jne     @@0
        or      dl,2
@@0:
                ;SP
        cmp     cl,envSustain[ebx]      ;on sustain-point?
        jne     @@1
        or      dl,4
@@1:
                                        ;     SP  LP   S
                                        ;  ---------------------
                                        ;  0:  0   0   0 : x
                                        ;  1:  0   0   1 : x
                                        ;  2:  0   1   0 : loop
                                        ;  3:  0   1   1 : loop
                                        ;  4:  1   0   0 : x
                                        ;  5:  1   0   1 : sustain
                                        ;  6:  1   1   0 : x
                                        ;  7:  1   1   1 : loop
        cmp     dl,5
        je      @@weg
        xor     ebp,ebp
        dec     ebp                     ;segment count = -1
        cmp     dl,6
        je      @@x
        test    dl,2
        jz      @@x
                ;loop
        mov     cl,envLoops[ebx]
        movzx   eax,envPoint[ebx+ecx*4+2]

@@x:            ;no event
        cmp     cl,envLastpoint[ebx]    ;last point?
        jae     @@weg                   ;last point : segment count = -1

        inc     ecx                     ;next point
        inc     ebp
@@inc:  inc     ebp

@@weg:  ret
envelope endp





;--- gus ---
gusenv proc
        ;esi -> tdinfo
        ;es:edi -> environment

        mov     ecx,size tdinfo/4 -1
@@l:
        mov     dword ptr ds:[esi+ecx*4],0
        dec     ecx
        jns     @@l
                                        ;ecx = 0xFFFFFFFF
;        xor     ecx,ecx
;        dec     ecx
        jmp     @@scanentry
@@envscan:
        xor     eax,eax
        repne   scasb
@@scanentry:
        cmp     byte ptr es:[edi],0
        je      @@weg
if enhanced gt 0                                ;INTERWAVE=
        cmp     dword ptr es:[edi],45544E49h    ;INTE
        jne     @@u
        cmp     dword ptr es:[edi+4],56415752h  ;RWAV
        jne     @@u
        cmp     word ptr es:[edi+8],3D45h       ;E=
        jne     @@u
        or      [esi].d_flags,gus_iw
@@u:
endif
                                                ;ULTRASND=
        cmp     dword ptr es:[edi],52544C55h    ;ULTR
        jne     @@envscan
        cmp     dword ptr es:[edi+4],444E5341h  ;ASND
        jne     @@envscan
        cmp     byte ptr es:[edi+8],'='
        jne     @@envscan

        cmp     byte ptr es:[edi+9],' '
        mov     al,es:[edi+10]
        jne     @@0
        mov     al,es:[edi+11]
@@0:
        sub     al,'0'
        shl     al,4
        mov     ah,2
        mov     [esi].d_base,eax
if enhanced gt 0
        jmp     @@envscan
endif

@@weg:
        ret
gusenv endp


u_init proc near
        ;-> edi -> tdinfo
        ;<- eax = 0: gus nicht vorhanden, 1: gus vorhanden

                ;GUS-reset
        mov     edx,[edi].d_base

        xor     eax,eax
        cmp     edx,200h
        jb      @@weg
        cmp     edx,290h
        ja      @@weg

        mov     al,2                    ;Line out aus(!)
        out     dx,al

        lea     ebp,[edx + 103h]
        mov     [edi].u_command,ebp

        mov     edx,ebp;command
        mov     al,4ch                  ;Init-Register
        out     dx,al
        inc     edx
        inc     edx;datahi
        xor     al,al
        out     dx,al
        call    u_delay

        mov     edx,ebp;command
        mov     al,4ch
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,1
        out     dx,al
        call    u_delay

        call    u_memsize               ;mem size
        xor     eax,eax
        or      ecx,ecx
        jz      @@weg
        mov     [edi].u_mem,ecx

comment #
        mov     edx,ebp;command         ;DMA Control Register resetten
        mov     al,41h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,0
        out     dx,al

        mov     edx,ebp;command         ;Timer Control Register resetten
        mov     al,45h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,0
        out     dx,al

        mov     edx,ebp;command         ;Sampling Control Register resetten
        mov     al,49h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,0
        out     dx,al

        mov     edx,[edi].d_base        ;Evtl. DMA Interrupts leeren
        add     dl,6;status
        in      al,dx

        mov     edx,ebp;command
        mov     al,41h
        out     dx,al
        inc     edx
        inc     edx;datahi
        in      al,dx

        mov     edx,ebp;command         ;Evtl. Sampling Interrupts leeren
        mov     al,49h
        out     dx,al
        inc     edx
        inc     edx;datahi
        in      al,dx

        mov     edx,ebp;command         ;IRQ Status Register lesen
        mov     al,8Fh                  ;==> Es liegen jetzt keine unbearbeiteten
        out     dx,al                   ;    Interrupts an
        inc     edx
        inc     edx;datahi
        in      al,dx
#

if enhanced gt 0
        test    [edi].d_flags,gus_iw
        setnz   [edi].d_ver
        jnz     @@enh
endif
                ;old GUS

        mov     edx,ebp;command         ;Anzahl Stimmen zunchst auf 32
        mov     al,0Eh
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,0C0h or 31
        out     dx,al

if enhanced gt 0
        jmp     @@old0

@@enh:          ;IW

        mov     edx,ebp;command         ;enhanced mode
        mov     al,19h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,1
        out     dx,al

        mov     edx,ebp;command         ;memory config = 0Ch
        mov     al,52h
        out     dx,al
        inc     edx
        in      ax,dx

        and     ax,0FFF0h
        mov     [edi].u_reg52,ax
        or      al,0Ch
        mov     bx,ax

        mov     edx,ebp;command
        mov     al,52h
        out     dx,al
        inc     edx
        mov     ax,bx
        out     dx,ax

        mov     edx,ebp;command         ;enable ram access, auto inc
        mov     al,53h
        out     dx,al
        inc     edx
        inc     edx
        in      al,dx

        and     al,0FCh
        inc     al
        mov     bl,al

        mov     edx,ebp;command
        mov     al,53h
        out     dx,al
        inc     edx
        inc     edx
        mov     al,bl
        out     dx,al

        call    iw_findmem              ;ch = memory config

        mov     edx,ebp;command         ;write memory config
        mov     al,52h
        out     dx,al
        inc     edx
        mov     ax,[edi].u_reg52
        or      al,ch
        out     dx,ax

@@old0:
endif

                ;GUS-init
        mov     cl,31                   ;In Schleife die Stimmen ausschalten
@@vc_l:

        mov     edx,ebp                 ;Stimme whlen
        dec     edx;voice
        mov     al,cl
        out     dx,al

        mov     edx,ebp;command         ;Stimme stoppen
        xor     al,al
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,3
        out     dx,al

        mov     edx,ebp;command         ;volume-ramping stoppen
        mov     al,0dh
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,3
        out     dx,al

        mov     edx,ebp;command         ;Ramping-Faktor setzen
        mov     al,6
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,31                   ;schnellst mglich = 63
        out     dx,al

        mov     edx,ebp;command         ;Lautstrke auf 0 setzen
        mov     al,9
        out     dx,al
        inc     edx;datalo
        ;xor     eax,eax
        mov     ax,4000h
        out     dx,ax

if enhanced gt 0
        cmp     [edi].d_ver,0
        je      @@old1

        mov     edx,ebp;command         ;stimme aktiv & altes panning
        mov     al,15h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,0
        out     dx,al

        mov     edx,ebp;command         ;Effekte Resetten
        mov     al,14h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,0
        out     dx,al

        mov     edx,ebp;command         ;Effekt Lautstrke
        mov     al,16h
        out     dx,al
        inc     edx
        inc     edx;datahi
        xor     eax,eax
        out     dx,ax

        mov     edx,ebp;command         ;Effekt Lautstrke Fein
        mov     al,1Dh
        out     dx,al
        inc     edx
        inc     edx;datahi
        xor     eax,eax
        out     dx,ax
@@old1:
endif
        dec     cl
        jns     @@vc_l                  ;fr alle Stimmen wiederholen

        mov     edx,ebp;command         ;Reset durchfhren
        mov     al,4ch
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,7                    ;GF1 Master IRQ einschalten
        out     dx,al

        mov     edx,[edi].d_base         ;Line out & dma an
        mov     al,0;8
        out     dx,al

        xor     eax,eax
        inc     eax
@@weg:  ret
u_init endp

u_done proc near
        ;edi -> tudata

        mov     edx,[edi].d_base           ;Line out aus(!)
        mov     al,2
        out     dx,al
        ret
u_done endp

u_setvol proc near
        ;-> eax = vol (0..32*8), ideal = 12*8
        ;-> edi = tudata

                ;gus volumes
        ;imul    eax,2200/(12*8)         ;gus max vol = 4096, standard = 2200
        mov     ecx,256                 ;257 volumes (0-256)
@@l:
        mov     ebx,ecx
        imul    ebx,2200
        shr     ebx,8
;        mov     edx,ecx
;        imul    edx,eax
;        shr     edx,8
;      mov ebx,3500                      ;vol should be less than 3500
;      cmp edx,ebx
;      ja @@0
;      mov ebx,edx
@@0:
        inc     ebx
        mov     edx,10000h
@@s:
        sub     edx,1000h
        shl     ebx,1
        btr     ebx,12
        jnc     @@s

        or      ebx,edx
        mov     [edi].u_volumes[ecx],bh

        dec     ecx
        jns     @@l
        ret
u_setvol endp

u_play proc near
        ;edi -> tudata
        ;esi -> rxmdata

        call    u_freq

ifndef noResample
if enhanced gt 0
        cmp     [edi].d_ver,0
        je      @@old
        call    iw_xm2mem
        jmp     @@0
@@old:
endif
endif
        call    u_xm2mem

@@0:
        ret
u_play endp

u_bpm proc near
        ;edi -> rxmdata
        ;eax = frequenz*65536
        mov     edx,offset u_int
        call    newhandler
        ret
u_bpm endp


u_delay proc near
        ;<- al = dram

        push    ecx
        push    edx
        mov     ecx,16

@@l:    mov     edx,[edi].d_base
        add     edx,107h;dramio
        in      al,dx
        loop    @@l

        pop     edx
        pop     ecx
        ret
u_delay endp

u_setadr proc near
        ;eax = adresse

        push    eax

        mov     edx,[edi].d_base
        add     edx,103h;command        ;Lo-Word
        mov     al,43h
        out     dx,al
        inc     edx;datalo
        pop     eax                     ;eax = adresse
        out     dx,ax

        dec     edx;command             ;Hi-Byte
        mov     al,44h
        out     dx,al
        inc     edx
        inc     edx;datahi
        shr     eax,16
        out     dx,al

        inc     edx
        inc     edx;dramio

@@weg:  ret
u_setadr endp



u_memsize proc near
        ;-> edi -> rxmdata
        ;-> ebp = u_command
        ;<- ecx = anzahl 256K-mem-blcke

        xor     ecx,ecx
@@mem:
        mov     ebx,ecx
        shl     ebx,18

        mov     eax,ebx
        call    u_setadr
        mov     al,0AAh
        out     dx,al

        lea     eax,[ebx+1]
        call    u_setadr
        mov     al,055h
        out     dx,al

        mov     eax,ebx
        call    u_setadr

        call    u_delay
        cmp     al,0AAh
        jne     @@weg

        inc     ecx
        cmp     ecx,4
        jb      @@mem
@@weg:
        ;mov     [edi].u_mem,ecx
        ret
u_memsize endp


if enhanced gt 0

iw_findmem proc near
        ;-> edi = tudata
        ;-> ebp = u_command
        ;<- ch = lmcfi

                ;detect memory configuration
        xor     ebx,ebx
@@m_l0:
        xor     ecx,ecx
@@m_l1:
        mov     eax,ebx                ;ebx*4M + ecx*256k markieren
        shl     eax,4
        add     eax,ecx
        shl     eax,18
        call    u_setadr
        mov     al,0AAh
        add     al,cl
        out     dx,al
        not     al
        out     dx,al

        mov     eax,ebx                ;anfang auf berschreibung berprfen
        shl     eax,22
        call    u_setadr
        in      al,dx
        cmp     al,0AAh
        jne     @@next
        in      al,dx
        cmp     al,055h
        jne     @@next

        mov     eax,ebx                ;ebx*4M + ecx*256k prfen
        shl     eax,4
        add     eax,ecx
        shl     eax,18
        call    u_setadr
        mov     ah,0AAh
        add     ah,cl
        in      al,dx
        cmp     al,ah
        jne     @@next
        not     ah
        in      al,dx
        cmp     al,ah
        jne     @@next

        inc     ecx
        cmp     ecx,16
        jb      @@m_l1
@@next:
        shrd    esi,ecx,8               ;esi = mem-config
        inc     ebx
        cmp     ebx,4
        jb      @@m_l0

                ;find a suitable memory config number
        xor     ecx,ecx                 ;cl : config counter (0 - 0Bh)
        xor     edx,edx                 ;dl : mem size with actual config
@@rep:                                  ;ch : max-mem config
        mov     eax,esi                 ;dh : max-mem
        movzx   ebx,cl
        mov     ebx,iw_memconfig[ebx*4] ;get config
        xor     dl,dl
@@l:
        cmp     al,bl
        jb      @@last
        add     dl,bl
        shr     ebx,8
        shr     eax,8
        jnz     @@l

@@last: add     dl,al
        cmp     dh,dl
        jae     @@10
        mov     dh,dl
        mov     ch,cl
@@10:
        inc     cl
        cmp     cl,0Bh
        jbe     @@rep

        movzx   edx,dh
        mov     [edi].u_mem,edx         ;edx = mem in 256K blocks
@@weg:  ret
iw_findmem endp

endif

u_freq proc near
        ;esi -> trxmdata
        ;edi -> tudata


if enhanced gt 0
        mov     ebx,14

        cmp     [edi].d_ver,0
        jne     @@enh
endif
        mov     ebx,[esi].head.hdChannels

        mov     edx,[edi].u_command      ;aktive kanle
        mov     al,0Eh
        out     dx,al
        inc     edx
        inc     edx
        cmp     bl,14
        jae     @@chan
        mov     bl,14
@@chan:
        mov     al,bl
        dec     al
        or      al,0C0h
        out     dx,al
@@enh:

        ;incval = f * (1024 * 1.619695497 * channels)/1000000

        imul    eax,ebx,7123496 /256    ;*(1024 * 1.619695497)/1000000 * 2^24
        mov     [esi].s_freqmul,eax


        ret
u_freq endp

ifdef noResample
;sample data < 256k
u_xm2mem proc near
        mov     ebp,10h                 ;ram-offset (=10h wegen pingpong-bug)

        mov     edx,offset u_upload
        call    foreach

        ret
u_xm2mem endp

;called by foreach
u_upload proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        mov     ebx,esi

        mov     esi,[ebx].sDataptr      ;esi -> sampledaten

        mov     ecx,sLoope[ebx]
        inc     ecx

ifdef no16bit
        mov     sOffset[ebx],ebp
else
        mov     eax,ebp
        test    sType[ebx],sf16bit
        jz      @@8
                ;16 bit
        shl     ecx,1
        shr     eax,1
@@8:
        mov     sOffset[ebx],eax
endif

                ;kopieren
@@hi:   mov     edx,[edi].u_command     ;Hi-Byte der GUS-DRAM Adresse setzen
        mov     al,44h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     eax,ebp
        shr     eax,16
        out     dx,al
@@lo:   mov     edx,[edi].u_command     ;Lo-Word der GUS-DRAM Adresse setzen
        mov     al,43h
        out     dx,al
        inc     edx;datalo
        mov     eax,ebp
        out     dx,ax

        add     edx,3;dramio          ;Byte laden und ausgeben
        lodsb
        out     dx,al

        inc     ebp
        dec     ecx
        jz      @@weg
        or      bp,bp
        jnz     @@lo
        jz      @@hi                    ;berlauf wenn bp = 0

@@weg:  ret
u_upload endp

else
;sample data > 256k
u_len proc near
        ;-> esi -> tsampleh
        ;<- eax = sample-lnge
        ;<- ebx = extra-lnge

        mov     eax,sLoope[esi]         ;eax = sample-lnge ohne extra-bytes
        mov     ebx,1                   ;ebx = extra-bytes

        cmp     eax,256
        ja      @@weg
        add     ebx,eax                 ;sample krzer als 256
        xor     eax,eax
@@weg:  ret
u_len endp


u_xm2mem proc near

        mov     [edi].u_slen,0
        mov     [edi].u_extralen,10h
        mov     [edi].u_fit,1           ;passt-flag

        mov     ecx,3
@@0:    xor     eax,eax
        cmp     ecx,[edi].u_mem
        jb      @@1
        mov     eax,40000h              ;u_memblock = 0 : leer
@@1:    mov     [edi].u_memblock[ecx*4],eax
        dec     ecx
        jnz     @@0
        mov     [edi].u_memblock[0],10h ;wegen pingpong-bug

        mov     edx,offset u_sizecount
        call    foreach

        cmp     [edi].u_fit,0
        je      @@res
                ;passt

        mov     edx,offset u_upload
        call    foreach
        jmp     @@weg

@@res:          ;resample
        mov     eax,[edi].u_mem
        shl     eax,18
        mov     [edi].u_memleft,eax

        sub     eax,[edi].u_extralen
        mov     edx,[edi].u_slen

        mov     [edi].u_div,-1           ;faktor bestimmen
@@div_l:
        inc     [edi].u_div
        shr     edx,1
        cmp     edx,eax
        jl      @@2
        cmp     [edi].u_div,4
        jb      @@div_l
@@2:

        mov     ebp,10h                 ;ram-offset (=10h wegen pingpong-bug)

        mov     edx,offset u_resample
        call    foreach

@@weg:  ret
u_xm2mem endp

;called by foreach
u_sizecount proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        call    u_len
        add     u_slen[edi],eax         ;eax = sample-lnge
        add     u_extralen[edi],ebx     ;ebx = extra-lnge

        mov     ecx,sLoope[esi]
        inc     ecx


        test    sType[esi],sf16bit
        jnz     @@16bit
                ;8 bit                  ;verteilung des samples auf 4 blcke
        xor     ebx,ebx                 ;ebx = startblock
@@a0:
        xor     edx,edx                 ;edx = begrenzung
        mov     eax,ebx

@@a1:   inc     eax                     ;fr jeden folgenden freien block
        add     edx,40000h              ; wird begrenzung um 256k erhht
        cmp     eax,4
        jae     @@a2
        cmp     [edi].u_memblock[eax*4],0
        je      @@a1
@@a2:
        mov     ebp,[edi].u_memblock[ebx*4];ebp = offset im 256k block
        mov     eax,ebp
        add     eax,ecx                 ;eax = belegte byte ab aktuellem block
        cmp     eax,edx
        jbe     @@a3                    ;passt?

        inc     ebx                     ;nchster block als startblock
        cmp     ebx,4
        jb      @@a0
        mov     [edi].u_fit,0           ;speicher reicht nicht
        jmp     @@weg

@@a3:
        mov     edx,ebx                 ;blocknummer = obere 2 bit der adresse
        shl     edx,18
        or      ebp,edx                 ;ebp = adresse im gus-ram

                                        ;zahl in eax auf aktuellen und
        mov     edx,40000h              ; folgende blcke verteilen (max. 256k)
@@a4:
        cmp     eax,edx;40000h          ;pat rest in den block?
        jbe     @@a5
        mov     [edi].u_memblock[ebx*4],edx;block voll
        inc     ebx                     ;nchster block
        sub     eax,edx;40000h
        jmp     @@a4
@@a5:
        mov     [edi].u_memblock[ebx*4],eax;rest

        mov     sOffset[esi],ebp        ;Offset im gus-ram speichern

        jmp     @@weg

@@16bit:        ;16 bit
        shl     ecx,1
        xor     ebx,ebx                 ;verteilung des samples auf 4 blcke
@@s0:
        mov     ebp,[edi].u_memblock[ebx*4];ebp = offset im 256k block
        inc     ebp
        and     ebp,not 1               ;align 2

        mov     eax,ebp
        add     eax,ecx
        cmp     eax,40000h              ;sample mu in einen block passen
        jbe     @@s1

        inc     ebx                     ;nchster block (0-3)
        cmp     ebx,4
        jb      @@s0
        mov     [edi].u_fit,0           ;speicher reicht nicht
        jmp     @@weg
@@s1:
        mov     [edi].u_memblock[ebx*4],eax


        shl     ebx,18
        or      ebp,ebx
        mov     sOffset[esi],ebp

@@weg:  ret
u_sizecount endp

;called by foreach
u_upload proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        mov     ebx,esi

        mov     esi,[ebx].sDataptr      ;esi -> sampledaten

        mov     ecx,sLoope[ebx]
        inc     ecx
        mov     ebp,sOffset[ebx]

        test    sType[ebx],sf16bit
        jz      @@8
                ;16 bit
        shl     ecx,1

        mov     eax,ebp
        and     eax,3FFFFh              ;16 bit adresse berechnen
        shr     eax,1
        mov     edx,ebp
        and     edx,0C0000h
        or      eax,edx
        mov     sOffset[ebx],eax
@@8:

                ;kopieren
@@hi:   mov     edx,[edi].u_command     ;Hi-Byte der GUS-DRAM Adresse setzen
        mov     al,44h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     eax,ebp
        shr     eax,16
        out     dx,al
@@lo:   mov     edx,[edi].u_command     ;Lo-Word der GUS-DRAM Adresse setzen
        mov     al,43h
        out     dx,al
        inc     edx;datalo
        mov     eax,ebp
        out     dx,ax

        add     edx,3;dramio          ;Byte laden und ausgeben
        lodsb
        out     dx,al

        inc     ebp
        dec     ecx
        jz      @@weg
        or      bp,bp
        jnz     @@lo
        jz      @@hi                    ;berlauf wenn bp = 0

@@weg:  ret
u_upload endp

;called by foreach
u_resample proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        mov     cl,u_div[edi]
        mov     eax,u_slen[edi]
        shr     eax,cl
        add     eax,u_extralen[edi]     ;eax = aktueller platzbedarf
        cmp     eax,u_memleft[edi]
        jle     @@0
        inc     cl                      ;platzbedarf zu gro
@@0:
        call    u_len                   ;eax = sample-lnge
                                        ;ebx = extra-lnge
        sub     u_slen[edi],eax
        sub     u_extralen[edi],ebx

        shr     eax,cl                  ;sample-lnge = 0: nicht komprimierbar
        jnz     @@1
        xor     cl,cl
@@1:
        add     eax,ebx                 ;eax = gesamter platzbedarf
        sub     u_memleft[edi],eax
        mov     sOffset[esi],-1
;   jns @@t0
;   mov eax,'voll'
;   call str_
;   jmp @@weg
        js      @@weg                   ;mem voll
;@@t0:
        mov     sOffset[esi],ebp
        mov     sResample[esi],cl

        shr     sLoops[esi],cl
        shr     sLoope[esi],cl

        mov     eax,sLoope[esi]         ;eax = samples to copy
        mov     ebx,1
        shl     ebx,cl                  ;ebx = step
        xor     edx,edx                 ;edx = offset

        call    u_move                  ;samples bertragen

        mov     eax,1
        xor     ebx,ebx
        mov     edx,sLoops[esi]

        test    sType[esi],sfLoop
        jz      @@5
        test    sType[esi],sfPingpong
        jz      @@6
@@5:    mov     edx,sLoope[esi]
@@6:
        shl     edx,cl
        call    u_move

        and     sType[esi],not sf16bit

@@weg:  ret
u_resample endp

u_move proc near
        ;-> eax = samples to copy
        ;-> ebx = step
        ;-> edx = offset
        push    ecx esi
        mov     ecx,eax

        test    sType[esi],sf16bit
        jz      @@8
        shl     edx,1
        inc     edx
        shl     ebx,1

@@8:
        ;lea     esi,[esi + size tsampleh + edx]
        mov     esi,[esi].sDataptr
        add     esi,edx

                ;kopieren
@@hi:   mov     edx,[edi].u_command     ;Hi-Byte der GUS-DRAM Adresse setzen
        mov     al,44h
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     eax,ebp
        shr     eax,16
        out     dx,al
@@lo:   mov     edx,[edi].u_command     ;Lo-Word der GUS-DRAM Adresse setzen
        mov     al,43h
        out     dx,al
        inc     edx;datalo
        mov     eax,ebp
        out     dx,ax

        add     edx,3;dramio          ;Byte laden und ausgeben
        mov     al,[esi]
        add     esi,ebx
        out     dx,al

        inc     ebp
        dec     ecx
        jz      @@weg
        or      bp,bp
        jnz     @@lo
        jz      @@hi                    ;berlauf wenn bp = 0

@@weg:  pop     esi ecx
        ret
u_move endp


if enhanced gt 0
iw_xm2mem proc near
        ;-> edi -> tudata
        ;-> esi -> trxmdata

        xor     ebp,ebp                 ;ram-offset (bei iw geht 0)

        mov     eax,ebp
        call    u_setadr

        mov     u_slen[edi],0
        mov     u_extralen[edi],ebp
        mov     u_fit[edi],ebp

        mov     edx,offset iw_sizecount
        call    foreach

        mov     eax,u_mem[edi]
        shl     eax,18                  ;eax = mem size
        cmp     eax,u_fit[edi]
        jb      @@res
                ;passt

        mov     edx,offset iw_upload
        call    foreach
        jmp     @@weg

@@res:          ;resample
        mov     u_memleft[edi],eax

        sub     eax,u_extralen[edi]
        mov     edx,u_slen[edi]

        mov     u_div[edi],-1           ;faktor bestimmen
@@div_l:
        inc     u_div[edi]
        shr     edx,1
        cmp     edx,eax
        jl      @@0
        cmp     u_div[edi],4
        jb      @@div_l
@@0:


        mov     edx,offset iw_resample
        call    foreach


@@weg:  ret
iw_xm2mem endp


;called by foreach
iw_sizecount proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        call    u_len                   ;lngen bezogen auf 8 bit

        add     u_slen[edi],eax         ;eax = sample-lnge
        add     u_extralen[edi],ebx     ;ebx = extra-lnge


        add     eax,ebx
        test    sType[esi],sf16bit
        jz      @@8
                ;16 bit
        shl     eax,1
@@8:
        inc     eax
        and     eax,not 1               ;aufrunden

        add     u_fit[edi],eax
        ret
iw_sizecount endp

;called by foreach
iw_upload proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        mov     ebx,esi

;        add     esi,size tsampleh
        mov     esi,[ebx].sDataptr

        mov     ecx,sLoope[ebx]
        inc     ecx
        mov     eax,ebp

        test    sType[ebx],sf16bit
        jz      @@8bit
        shl     ecx,1
        shr     eax,1
@@8bit:
        mov     sOffset[ebx],eax        ;Offset im gus-ram speichern

        inc     ecx
        shr     ecx,1                   ;/2 (aufrunden)
        add     ebp,ecx
        add     ebp,ecx

        mov     edx,[edi].u_command
        mov     al,51h
        out     dx,al
        inc     edx
        rep     outsw

        ret
iw_upload endp

;called by foreach
iw_resample proc near
        ;-> edi -> tudata
        ;-> esi -> tsampleh

        mov     cl,u_div[edi]
        mov     eax,u_slen[edi]
        shr     eax,cl
        add     eax,u_extralen[edi]     ;eax = aktueller platzbedarf
        cmp     eax,u_memleft[edi]
        jle     @@0
        inc     cl                      ;platzbedarf zu gro
@@0:
        call    u_len                   ;eax = sample-lnge
                                        ;ebx = extra-lnge
        sub     u_slen[edi],eax
        sub     u_extralen[edi],ebx

        shr     eax,cl                  ;sample-lnge = 0: nicht komprimierbar
        jnz     @@1
        xor     cl,cl
@@1:
        add     eax,ebx                 ;eax = gesamter platzbedarf
        sub     u_memleft[edi],eax
        mov     sOffset[esi],-1
;   jns @@t0
;   mov eax,'voll'
;   call str_
;   jmp @@weg
        js      @@weg                   ;mem voll
;@@t0:
        mov     sOffset[esi],ebp
        mov     sResample[esi],cl
;        or      sType[esi],sfResampled


        shr     sLoops[esi],cl
        shr     sLoope[esi],cl

        mov     eax,sLoope[esi]         ;eax = samples to copy
        mov     ebx,1
        shl     ebx,cl                  ;ebx = step
        xor     edx,edx                 ;edx = offset

        call    iw_move                  ;samples bertragen

        mov     eax,1
        xor     ebx,ebx
        mov     edx,sLoops[esi]

        test    sType[esi],sfLoop
        jz      @@5
        test    sType[esi],sfPingpong
        jz      @@6
@@5:    mov     edx,sLoope[esi]
@@6:
        shl     edx,cl
        call    iw_move

        and     sType[esi],not sf16bit

@@weg:  ret
iw_resample endp


iw_move proc near
        ;-> eax = samples to copy
        ;-> ebx = step
        ;-> edx = offset
        push    ecx esi
        mov     ecx,eax

        test    sType[esi],sf16bit
        jz      @@8
        shl     edx,1
        inc     edx
        shl     ebx,1

@@8:
;        lea     esi,[esi + size tsampleh + edx]
        mov     esi,[esi].sDataptr
        add     esi,edx


                ;kopieren
        mov     edx,[edi].d_base        ;Byte laden und ausgeben
        add     edx,107h;dramio
@@l:
        mov     al,[esi]
        add     esi,ebx
        out     dx,al

        inc     ebp
        dec     ecx
        jnz     @@l

        pop     esi ecx
        ret
iw_move endp
endif
endif

u_int proc near
        mov     edi,rxmdata

        mov     eax,4
        mov     edx,offset u_change
        call    newhandler              ;3 ms one-shot

        call    tick

;---
                                        ;fr regulre nderung und stop
                                        ; nicht fr start
        lea     esi,[edi].chdata
        mov     ecx,[edi].head.hdChannels
        mov     edi,[edi].s_drvmem
        mov     ebp,[edi].u_command
        dec     ecx
@@ch_l:
        ;lautstrke-ramping
        test    caktiv[esi],afPlay or afStop
        jz      @@l_weg                 ;kein ramping ntig

        mov     edx,ebp                 ;Stimme whlen
        dec     edx;voice
        mov     al,cl
        out     dx,al

                ;start-lautstrke
        mov     edx,cofinalvol[esi]     ;lautstrke im vorigen tick
        mov     bl,[edi].u_volumes[edx] ;bl = start-lautstrke

                ;end-lautstrke
        mov     bh,40h;18
        test    caktiv[esi],afStop      ;wird stimme gleich gestoppt?
        jnz     @@ramp

                ;stimme luft weiter
        mov     edx,cfinalvol[esi]      ;0-256
        mov     bh,[edi].u_volumes[edx]

@@ramp: call    u_ramp                  ;bl = start, bh = ende

@@l_weg:

        add     esi,size tchannel
        dec     ecx                     ;alle kanle...
        jns     @@ch_l

        ret
u_int endp


u_ramp proc near
        ;bl = start, bh = ende

        mov     al,8                    ;al : ramping obere lautstrke
        xor     ah,ah                   ;ah = modus-byte

        cmp     bh,bl
        jz      @@weg
        ja      @@0
                ;abwrts
        dec     al                      ;ramping untere lautstrke
        mov     ah,40h                  ;modus byte: abwrts rampen
@@0:
        mov     edx,ebp;command         ;ziel-lautstrke setzen
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,bh
        out     dx,al

        mov     edx,ebp;command         ;ramping richtung im volume control
        mov     al,0dh                  ; register setzen
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,ah
        out     dx,al

@@weg:  ret
u_ramp endp


u_change proc near
        mov     edi,rxmdata

        lea     esi,[edi].chdata
        mov     cl,b [edi].head.hdChannels
        mov     edi,[edi].s_drvmem
        mov     ebp,[edi].u_command
        dec     cl
@@ch_l:
        test    caktiv[esi],afStart or afPlay or afStop
        jz      @@l_weg                 ;keine aktion erforderlich

        mov     edx,ebp                 ;Stimme whlen
        dec     edx;voice
        mov     al,cl
        out     dx,al

        ;stimme stoppen
        test    caktiv[esi],afStop
        jz      @@aktiv

        mov     edx,ebp;command         ;Stimme anhalten
        xor     al,al
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,3
        out     dx,al

comment #
        mov     edx,ebp;command          ;Lautstrke auf 0
        mov     al,9
        out     dx,al
        inc     edx;datalo
        mov     ax,4000h
        out     dx,ax
#
        test    caktiv[esi],afStart     ;gleich wieder starten?
        jz      @@l_weg

@@aktiv:;nderung der stimme (kanal aktiv)

                ;frequenz
        mov     edx,ebp;command         ;Befehl Voicefreqenz schreiben
        mov     al,1
        out     dx,al
        mov     eax,cincval[esi]        ;bei GUS: cincval = gus-frequenz
        inc     edx;datalo
        out     dx,ax

                ;panning
        mov     edx,ebp;command         ;Set Pan-Position
        mov     al,0Ch
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,b cfinalpan[esi]
        shr     al,4
        out     dx,al

        ;stimme starten
        test    caktiv[esi],afStart
        jz      @@l_weg

                ;Ramping anhalten
        mov     edx,ebp;command
        mov     al,0dh
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,3
        out     dx,al

                ;Loop-Start setzen
        mov     ebx,cloops[esi]
        mov     ch,02h
        call    pos_out

                ;Loop-Ende setzen
        mov     ebx,cloope[esi]
        mov     ch,04h
        call    pos_out

                ;lautstrke initialisieren
        mov     edx,ebp;command
        mov     al,9
        out     dx,al
        inc     edx;datalo
        mov     ax,4000h
        out     dx,ax

                ;Stimmenanfang setzen
        mov     ebx,csample[esi]
        mov     ch,0Ah
        call    pos_out

                ;volume ramping
        mov     edx,cfinalvol[esi]
        mov     bl,40h
        mov     bh,[edi].u_volumes[edx]
        call    u_ramp

        mov     edx,ebp;command         ;Voice Mode (loop, 8/16 bit)
        xor     al,al
        out     dx,al
        inc     edx
        inc     edx;datahi
        mov     al,ctype[esi]
        out     dx,al                   ;stimme startet jetzt...
@@l_weg:

        add     esi,size tchannel
        dec     cl                      ;alle kanle...
        jns     @@ch_l
@@weg:  ret
u_change endp


pos_out proc near
        mov     edx,ebp;command         ;HI-anteil
        mov     al,ch
        out     dx,al
        inc     edx
        mov     eax,ebx
        shr     eax,7
        out     dx,ax
        dec     edx                     ;LO-anteil
        mov     al,ch
        inc     al
        out     dx,al
        inc     edx
        mov     eax,ebx
        shl     eax,9
        out     dx,ax

        ret
pos_out endp


;--- int ---

int_8 proc
        pushad
        push    ds es
        mov     ds,cs:_seldata
        push    ds
        pop     es
        cld

;        mov     eax,timestep
;        add     maintime,eax
;        adc     byte ptr maintime[4],0

        inc     maincount

        mov     ebx,hnum-1
@@l:
        mov     eax,constant[ebx*4]
        cmp     eax,c_1                 ;constant < 65536 : one-shot
        jae     @@1
        dec     eax
        js      @@w
        mov     constant[ebx*4],eax
        jnz     @@w
        jmp     @@2
@@1:
        add     counter[ebx*4],eax      ;periodischer aufruf
        cmp     counter[ebx*4],1000*c_1
        jb      @@w
        sub     counter[ebx*4],1000*c_1
@@2:
        push    ebx                     ;handler aufrufen
        call    handler[ebx*4]
        pop     ebx
@@w:
        dec     ebx
        jns     @@l

@@weg:  pop     es ds
        mov     al,20h
        out     20h,al
        popad
        sti
        iretd
int_8 endp

newhandler proc near
        ;eax = frequenz
        ;edx = handler
        mov     ebx,hnum-1              ;alten handler suchen
@@l0:   cmp     handler[ebx*4],edx
        jne     @@0
        mov     constant[ebx*4],eax     ;neue frequenz
        jmp     @@weg
@@0:    dec     ebx
        jns     @@l0

        xor     ebx,ebx                 ;neuen handler einrichten
@@l1:   cmp     constant[ebx*4],0
        jne     @@1
        mov     handler[ebx*4],edx
        mov     constant[ebx*4],eax
        jmp     @@weg
@@1:    inc     ebx
        cmp     ebx,hnum
        jb      @@l1

@@weg:  ret
newhandler endp

i8_init proc near

if pmw gt 0
        mov     _seldata,ds

        push    es
        mov     ax,3508h
        int     21h
        mov     dword ptr oldint8 +0,ebx
        mov     word ptr oldint8  +4,es
        pop     es

        push    ds
        mov     ax,2508h
        push    cs
        pop     ds
        mov     edx,offset int_8
        int     21h
        pop     ds
else
        mov     bl,0                    ;irq0 = int8
        call    _getirqvect
        mov     opmirq,edx

        mov     edx,offset int_8
        call    _setirqvect
        mov     edi,offset rmirqbuf
        call    _rmpmirqset
        mov     ormirq,eax
endif
        cli
        mov     al,34h
        out     43h,al                  ;zhler setzen
        mov     ax,1193                 ;1193180 div 1000
        out     40h,al                  ;1000 mal pro sekunde
        mov     al,ah
        out     40h,al
        sti

        ret
i8_init endp

i8_done proc near
if pmw gt 0
        cmp     word ptr oldint8 +4,0
else
        cmp     ormirq,0
endif
        je      @@weg

        cli
        mov     al,34h
        out     43h,al
        xor     al,al                   ;zhler wieder auf 18.2 mal/s
        out     40h,al
        out     40h,al
        sti

if pmw gt 0
        push    ds
        mov     ax,2508h
        lds     edx,oldint8
        int     21h
        pop     ds

        mov     word ptr oldint8 +4,0
else
        mov     bl,0                    ;irq0 = int8
        mov     eax,ormirq
        call    _rmpmirqfree
        mov     edx,opmirq
        call    _setirqvect

        mov     ormirq,0
endif

@@weg:  ret
i8_done endp

;--- gamesound ---
if gamesound gt 0
playsound proc near
        ;-> al = note, ah = instrument, dl = volume
        mov     edi,rxmdata

        mov     ebx,[edi].soundhead
        mov     [edi].sounds[ebx].sinstrnote,ax
        mov     [edi].sounds[ebx].svol,dl

        add     ebx,size tsound
        cmp     ebx,sbuflen*(size tsound)
        jb      @@1
        xor     ebx,ebx
@@1:    mov     [edi].soundhead,ebx

@@weg:  ret
playsound endp

gamesounds proc near

@@l:
        mov     ebx,[edi].soundtail
        cmp     ebx,[edi].soundhead
        je      @@weg

        mov     eax,[edi].pchannels
        add     eax,[edi].nextchan
        imul    eax,size tchannel
        lea     esi,[edi].chdata[eax]

                ;note + instr
        movzx   eax,[edi].sounds[ebx].sinstrnote
        mov     cnote[esi],al
        xor     ecx,ecx
        mov     cparams[esi+0],ah
        shr     eax,8
        push    ebx
        call    Note_instr
        pop     ebx

                ;vol
        movzx   eax,[edi].sounds[ebx].svol
        or      eax,eax
        jz      @@0
        mov     cvol[esi],eax
@@0:

        add     ebx,size tsound
        cmp     ebx,sbuflen*(size tsound)
        jb      @@1
        xor     ebx,ebx
@@1:    mov     [edi].soundtail,ebx

        mov     eax,[edi].nextchan
        inc     eax
        cmp     eax,[edi].schannels
        jb      @@2
        xor     eax,eax
@@2:    mov     [edi].nextchan,eax

        jmp     @@l

@@weg:  ret
gamesounds endp
endif


if pmw eq 0
code32  ends
endif

end
