; 12-30-96 05:46pm [NP] mathematische Funktionen fr 3d-Grafik
; 12-30-96 05:46pm [NP] 1. Version

.486
.487
ideal
model flat, prolog

CODESEG

public veclength
public getnormvector
public normvector
public dotproduct
public crossproduct
public transform

proc veclength
     ; pointer to vector in esi
     ; return value in st(0)
     fld   [dword ptr esi+0]
     fmul  st(0), st(0)
     fld   [dword ptr esi+4]
     fmul  st(0), st(0)
     fld   [dword ptr esi+8]
     fmul  st(0), st(0)
     faddp st(2), st(0)
     faddp st(1), st(0)
     fsqrt
     ret
endp veclength

proc getnormvector
     ; pointer to vector in esi
     ; pointer to return vector in edi
     fld   [dword ptr esi+0]
     fld   st(0)
     fmul  st(0), st(0)
     fld   [dword ptr esi+4]
     fld   st(0)
     fmul  st(0), st(0)
     fld   [dword ptr esi+8]
     fld   st(0)
     fmul  st(0), st(0)
     faddp  st(2), st(0)
     fxch   st(1)
     faddp  st(3), st(0)
     fxch   st(2)
     fsqrt
     fdiv st(1), st(0)
     fdiv st(2), st(0)
     fdiv st(3), st(0)
     fstp st(0)
     fstp [dword ptr edi+4]
     fstp [dword ptr edi+8]
     fstp [dword ptr edi+0]
     ret
endp getnormvector

proc normvector
     ; pointer to vector in esi
     fld   [dword ptr esi+0]
     fld   st(0)
     fmul  st(0), st(0)
     fld   [dword ptr esi+4]
     fld   st(0)
     fmul  st(0), st(0)
     fld   [dword ptr esi+8]
     fld   st(0)
     fmul  st(0), st(0)
     faddp  st(2), st(0)
     fxch   st(1)
     faddp  st(3), st(0)
     fxch   st(2)
     fsqrt
     fdiv st(1), st(0)
     fdiv st(2), st(0)
     fdiv st(3), st(0)
     fstp st(0)
     fstp [dword ptr esi+4]
     fstp [dword ptr esi+8]
     fstp [dword ptr esi+0]
     ret
endp normvector

proc dotproduct
     ; pointer to first vector in ESI
     ; pointer to second vector in EDI
     fld   [dword ptr esi+0]
     fmul  [dword ptr edi+0]
     fld   [dword ptr esi+4]
     fmul  [dword ptr edi+4]
     fld   [dword ptr esi+8]
     fmul  [dword ptr edi+8]
     fxch  st(1)
     faddp st(2), st(0)
     faddp st(1), st(0)
     ; returns dot-production in st(0)
     ret
endp dotproduct

proc crossproduct
     ; pointer to first vector in ESI
     ; pointer to second vector in EDI
     ; pointer to result vector in EBX
     fld    [dword ptr esi+4]
     fmul   [dword ptr edi+8]
     fld    [dword ptr esi+8]
     fmul   [dword ptr edi+0]
     fld    [dword ptr esi+0]
     fmul   [dword ptr edi+4]
     fld    [dword ptr esi+8]
     fmul   [dword ptr edi+4]
     fld    [dword ptr esi+0]
     fmul   [dword ptr edi+8]
     fld    [dword ptr esi+4]
     fmul   [dword ptr edi+0]

     fxch   st(2)
     fsubrp st(5), st(0)
     fsubrp st(3), st(0)
     fsubrp st(1), st(0)
     fxch   st(2)
     fstp   [dword ptr ebx+0]
     fstp   [dword ptr ebx+4]
     fstp   [dword ptr ebx+8]
     ret
endp crossproduct

proc transform
     ; pointer to vector in ESI
     ; pointer to matrix in EDI
     ; pointer to result-vector in EBX
     fld    [dword ptr esi+0]
     fmul   [dword ptr edi+0]
     fld    [dword ptr esi+0]
     fmul   [dword ptr edi+16]
     fld    [dword ptr esi+0]
     fmul   [dword ptr edi+32]

     fld    [dword ptr esi+4]
     fmul   [dword ptr edi+4]
     fld    [dword ptr esi+4]
     fmul   [dword ptr edi+20]
     fld    [dword ptr esi+4]
     fmul   [dword ptr edi+36]

     fxch   st(2)
     faddp  st(5), st(0)
     faddp  st(3), st(0)
     faddp  st(1), st(0)

     fld    [dword ptr esi+8]
     fmul   [dword ptr edi+8]
     fld    [dword ptr esi+8]
     fmul   [dword ptr edi+24]
     fld    [dword ptr esi+8]
     fmul   [dword ptr edi+40]

     fxch   st(2)
     faddp  st(5), st(0)
     faddp  st(3), st(0)
     faddp  st(1), st(0)
     fxch   st(2)

     fadd  [dword ptr edi+12]
     fxch  st(1)
     fadd  [dword ptr edi+28]
     fxch  st(2)
     fadd  [dword ptr edi+44]
     fxch  st(1)
     fstp  [dword ptr ebx+0]
     fstp  [dword ptr ebx+8]
     fstp  [dword ptr ebx+4]
     ret
endp transform

end    
