/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRIMPORT_Q3BSP_HPP
#define PRIMPORT_Q3BSP_HPP



namespace primport
{

	///////////////////////////////////////////////////
	/// 	structs                                ///
	/////////////////////////////////////////////////
		
	struct EntitiesQ3
	{
		char*	entitydescriptions;
		int		descriptionlength;
	};
		
	struct TextureQ3
	{
		prcore::String	name;
		int				flags;
		int				contents;
	};
		
	struct NodeQ3
	{
		int		planeindex;
		int		children[2];
		box3f	boundingbox;
	};
		
	struct LeafQ3
	{
		int		cluster;
		int		area;
		box3f	boundingbox;
		int		leaffaceindex;
		int		numleaffaces;
		int		leafbrushindex;
		int		numleafbrushes;
	};
		
	struct LeafFaceQ3
	{
		int		faceindex;
	};
		
	struct LeafBrushQ3
	{
		int		brushindex;
	};
		
	struct ModelQ3
	{
		box3f	boundingbox;
		int		faceindex;
		int		numfaces;
		int		brushindex;
		int		numbrushes;
	};
		
	struct BrushQ3
	{
		int		brushsideindex;
		int		numbrushsides;
		int		textureindex;
	};
		
	struct BrushSideQ3
	{
		int		planeindex;
		int		textureindex;
	};
		
	struct VertexQ3
	{
		point3f			position;
		point2f			texcoords;
		point2f			lightmapcoords;
		vec3f			normal;
		prcore::Color32	color;
	};
		
	struct MeshVertexQ3
	{
		int		offset;
	};
		
	struct EffectQ3
	{
		prcore::String	name;
		int				brushindex;
		int				unknown;
	};
		
	struct FaceQ3
	{
		#define	Q3BSP_FACE_TYPE_POLYGON		(1)
		#define	Q3BSP_FACE_TYPE_PATCH		(2)
		#define	Q3BSP_FACE_TYPE_MESH		(3)
		#define	Q3BSP_FACE_TYPE_BILLBOARD	(4)
		
		int			textureindex;
		int			effectindex;
		int			type;
		int			vertexindex;
		int			numvertices;
		int			meshvertexindex;
		int			nummeshvertices;
		int			lightmapindex;
		int			lightmapcorner[2];
		int			lightmapsize[2];
		point3f		lightmapworldspaceorigin;
		vec3f		lightmapworldspaces;
		vec3f		lightmapworldspacet;
		vec3f		normal;
		int			patchsize[2];
	};
		
	struct LightmapQ3
	{
		unsigned char	map[128*128*3];
	};
		
	struct LightVolumeQ3
	{
		prcore::Color32	ambientcolor;
		prcore::Color32	directionalcolor;
		unsigned char	phi;
		unsigned char	theta;
	};
		
	struct VisDataQ3
	{
		int				numvectors;
		int				vectorsize;
		unsigned char*	data;
	};


	///////////////////////////////////////////////////
	/// 	importer                               ///
	/////////////////////////////////////////////////

	class ImportQ3BSP : public prcore::Interface
	{
		public:
		
		EntitiesQ3						entities;
		prcore::Array<TextureQ3>		textures;
		prcore::Array<plane3f>			planes;
		prcore::Array<NodeQ3>			nodes;
		prcore::Array<LeafQ3>			leafs;
		prcore::Array<LeafFaceQ3>		leaffaces;
		prcore::Array<LeafBrushQ3>		leafbrushes;
		prcore::Array<ModelQ3>			models;
		prcore::Array<BrushQ3>			brushes;
		prcore::Array<BrushSideQ3>		brushsides;
		prcore::Array<VertexQ3>			vertices;
		prcore::Array<MeshVertexQ3>		meshvertices;
		prcore::Array<EffectQ3>			effects;
		prcore::Array<FaceQ3>			faces;
		prcore::Array<LightmapQ3>		lightmaps;
		prcore::Array<LightVolumeQ3>	lightvolumes;
		VisDataQ3						visdata;

		ImportQ3BSP();
		ImportQ3BSP(prcore::Stream& stream);
		ImportQ3BSP(const char* filename);
		~ImportQ3BSP();
	};

} // namespace primport



#endif