/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRIMPORT_Q1MDL_HPP
#define PRIMPORT_Q1MDL_HPP



namespace primport
{

	///////////////////////////////////////////////////
	/// 	structs                                ///
	/////////////////////////////////////////////////

	typedef prcore::String StringMDL;
	typedef prcore::Array<struct VertexMDL> VertexArrayMDL;


	struct VertexMDL
	{
		point3f			point;
		vec3f			normal;
	};


	struct FaceMDL
	{
		uint32			index[3];
		vec2f			texcoord[3];
	};


	struct FrameMDL
	{
		StringMDL		name;
		VertexArrayMDL	vertexarray;
	};

	
	///////////////////////////////////////////////////
	/// 	importer                               ///
	/////////////////////////////////////////////////

	class ImportQ1MDL : public prcore::Interface
	{
		public:

		prcore::Bitmap				skin;
		prcore::Array<FaceMDL>		faces;
		prcore::Array<FrameMDL>		frames;

		ImportQ1MDL();
		ImportQ1MDL(prcore::Stream& stream);
		ImportQ1MDL(const char* filename);
		~ImportQ1MDL();
	};

} // namespace primport



#endif