/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRIMPORT_LWO2_HPP
#define PRIMPORT_LWO2_HPP



namespace primport
{

	///////////////////////////////////////////////////
	/// 	structs                                ///
	/////////////////////////////////////////////////

	typedef prcore::String StringLWO2;
	typedef prcore::Color32 ColorLWO2;
	typedef prcore::Array<struct VertexLWO2> VertexBufferLWO2;
	typedef prcore::Array<struct IndexBufferLWO2> IndexBufferArrayLWO2;


	struct TextureLWO2
	{
		StringLWO2		filename;
		bool			enable;
	};


	enum
	{
		LWO2_TEXTURE_COLOR,
		LWO2_TEXTURE_DIFFUSE,
		LWO2_TEXTURE_LUMINOSITY,
		LWO2_TEXTURE_SPECULAR,
		LWO2_TEXTURE_REFLECTION,
		LWO2_TEXTURE_TRANSPARENCY,
		LWO2_TEXTURE_TRANSLUCENCY,
		LWO2_TEXTURE_GLOSSINESS,
		LWO2_TEXTURE_SHARPNESS,
		LWO2_TEXTURE_BUMP,
		LWO2_TEXTURE_COUNT // not a texture channel
	};


	struct SurfaceLWO2
	{
		StringLWO2		name;

		ColorLWO2		color;
		float			diffuse;
		float			luminosity;
		float			specular;
		float			reflection;
		float			transparency;
		float			translucency;
		float			glossiness;
		float			sharpness;
		float			bump;

		TextureLWO2		texture[ LWO2_TEXTURE_COUNT ];

		bool			twosided;
	};

	
	struct VertexLWO2
	{
		point3f		point;
		vec3f		normal;
		vec2f		texture;
	};


	struct IndexBufferLWO2
	{
		uint32					surface;
		prcore::Array<uint32>	indexbuffer;
	};


	struct MeshLWO2
	{
		VertexBufferLWO2		vertexbuffer;
		IndexBufferArrayLWO2	indexbuffers;
	};


	///////////////////////////////////////////////////
	/// 	importer                               ///
	/////////////////////////////////////////////////

	class ImportLWO2 : public prcore::Interface
	{
		public:

		prcore::Array<SurfaceLWO2>	surfaces;
		prcore::Array<MeshLWO2>		meshes;

		ImportLWO2();
		ImportLWO2(prcore::Stream& stream);
		ImportLWO2(const char* filename);
		~ImportLWO2();
	};

} // namespace primport



#endif