// Edmond Cote

#include <prcore/prcore.hpp>
using namespace prcore;


static char ExFilename[] = "UnknownFile";
static char ExMethod[] = "UnknownClass";
static char ExMessage[] = "Reason not specified.";

extern void MessageBox(const char* name, const char* text, ...);

Exception::Exception()
{
  mFilename = ExFilename;
  mMethod = ExMethod;
  mMessage = ExMessage;

}

Exception::Exception(const char* method, const char* message, const char* file)
{
  mFilename = file ? file : ExFilename;
  mMethod = method ? method : ExMethod;
  mMessage = message ? message : ExMessage;
}

Exception::Exception(const Exception& e)
{
  *this = e;
}

void Exception::operator = (const Exception& e)
{
  mFilename = e.mFilename;
  mMethod = e.mMethod;
  mMessage = e.mMessage;
}


const String& Exception::GetFilename() const
{
  return mFilename;
}


const String& Exception::GetMethod() const
{
  return mMethod;
}


const String& Exception::GetMessage() const
{
  return mMessage;
}


Exception::~Exception()
{
}

bool Exception::SetLogo(const Bitmap& logo)
{
  // I'm not supporting this quite yet
  return true;
}

void Exception::DrawDialog()
{
  // right now this passes to stderr
  MessageBox( *mMethod, *mMessage );
}
