/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		filename implementation

	revision history:
		Jan/24/2001 - Jukka Liimatta - initial revision/renaissance build
*/
#include <prcore/prcore.hpp>
using namespace prcore;



const char* prcore::GetFilenameEXT(const char* filename)
{
	int len = strlen( filename );
	while ( len-- )
	{
		if ( *(filename+len) == '.' )
		{
			return filename + len + 1;
		}
	}
	return "";
}


const char* prcore::GetFilenameNoEXT(const char* filename)
{
	static char file[256];

	strcpy(file,filename);
	char* ptr = file + strlen(file) - 1;

	while ( ptr-- >= file )
	{
		if ( *ptr=='.' )
		{
			*ptr = '\0';
			return file;
		}
	}
	return "";
}


const char* prcore::GetFilenamePath(const char* filename)
{
	static char path[256];

	strcpy(path,filename);
	char* ptr = path + strlen(path) - 1;

	while ( ptr-- >= path )
	{
		if ( *ptr=='\\' || *ptr=='/' || *ptr==':' )
		{
			ptr[1] = 0;
			return path;
		}
	}
	return "";
}


const char* prcore::GetFilenameNoPath(const char* filename)
{
	int len = strlen( filename );
	while ( len-- )
	{
		const char* ptr = filename + len;
		char c = *ptr;
		if ( c=='\\' || c=='/' || c==':' )
		{
			return ptr + 1;
		}
	}
	return filename;
}
