/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_SURFACE_HPP
#define PRCORE_SURFACE_HPP



namespace prcore
{

	typedef const prcore::PixelFormat cpxf;


	class Surface : public Interface
	{
		public:
		
		enum ClearMode
		{
			CLEAR_COLOR			= 1,
			CLEAR_ALPHA			= 2,
			CLEAR_COLOR_ALPHA	= CLEAR_COLOR | CLEAR_ALPHA
		};

		enum BlitMode
		{
			BLIT_COPY,
			BLIT_SCALE,
			BLIT_BILINEAR_SCALE
		};
	
		Surface();
		Surface(int width, int height, int pitch, const PixelFormat& format, void* image);
		~Surface();
		
		int				GetWidth() const;
		int				GetHeight() const;
		int				GetPitch() const;
		cpxf&			GetFormat() const;
		uint8*			GetImage() const;
		Rect			GetRect() const;
		Surface			GetSurface(const Rect& rect) const;

		void			Clear(const Color32& color, ClearMode mode=CLEAR_COLOR_ALPHA);
		void			Blit(const Surface& source, BlitMode mode=BLIT_COPY);
		void			Blit(int x, int y, const Surface& source);

		protected:
		
		int				width;			// width in pixels
		int				height;			// height in pixels
		int				pitch;			// width in bytes
		PixelFormat		format;			// pixelformat
		uint8*			image;			// image pointer
	};

} // namespace prcore



#endif