/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_OPENGL_HPP
#define PRCORE_OPENGL_HPP



namespace prcore
{

	typedef void ContextGL;


	struct ModeGL
	{
		uint32		width;
		uint32		height;
		uint32		bits;
		uint32		frequency;
	};


	struct InitGL
	{
		uint32		color;			// color buffer bits
		uint32		depth;			// depth buffer bits
		uint32		stencil;		// stencil buffer bits
		uint32		accum;			// accumulation buffer bits
	};


	class WindowGL : public WindowBase
	{
		public:

		WindowGL();
		~WindowGL();

		// mode
		int				GetModeCount() const;
		ModeGL			GetMode(int index) const;
		bool			SetMode(const ModeGL& mode);
		bool			RestoreMode();

		// context
		ContextGL*		CreateContext(InitGL* init);
		void			DeleteContext(ContextGL* context);
		void			SetContext(ContextGL* context);

		void			PageFlip(bool retrace=true);

		private:

		ContextGL*		mCurrentContext;
	};

} // namespace prcore



#endif