/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_MOUSE_HPP
#define PRCORE_MOUSE_HPP



namespace prcore
{

	enum MouseAxis
	{
		MOUSE_X,
		MOUSE_Y
	};

	enum MouseButton
	{
		MOUSE_LEFT		= 0x1,
		MOUSE_RIGHT		= 0x2,
		MOUSE_MIDDLE	= 0x4
	};


	class Mouse : public InputBase
	{
		public:

		Mouse();
		~Mouse();

		int			GetAxisCount() const;
		int			GetButtonCount() const;
		float		GetAxis(int axis);
		bool		GetButton(int button);

		void		SetArea(const Rect& rect);
		void		SetXY(int x, int y);
		int			GetX();
		int			GetY();
	};

} // namespace prcore



#endif