/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_MEMORYSTREAM_HPP
#define PRCORE_MEMORYSTREAM_HPP



namespace prcore
{

	class MemoryStream : public Stream
	{
		public:
		
		MemoryStream();
		MemoryStream(int size);
		MemoryStream(uint8* data, int size);
		MemoryStream(const char* filename);
		~MemoryStream();

		int			Seek(int delta, SeekMode mode);
		int			Read(void* target, int bytes);
		int			Write(const void* source, int bytes);
		int			GetOffset() const;
		int			GetSize() const;
		bool		IsOpen() const;
		bool		IsEOS() const;

		uint8*		GetData() const;

		private:

		int			mOffset;
		int			mSize;
		int			mMaxSize;
		uint8*		mData;
	};

} // namespace prcore



#endif