/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_FRAMEBUFFER_HPP
#define PRCORE_FRAMEBUFFER_HPP



namespace prcore
{

	struct VideoMode
	{
		int		width;
		int		height;
		int		bits;

		VideoMode() {}
		VideoMode(int w, int h, int b) : width(w),height(h),bits(b) {}
		~VideoMode() {}
	};


	class FrameBuffer : public Interface
	{
		public:

		FrameBuffer();
		~FrameBuffer();

		int				GetVideoModeCount() const;
		VideoMode		GetVideoMode(int index) const;

		bool			Open(WinHandle handle, const VideoMode& mode);
		bool			Open(WinHandle handle);
		bool			Close();

		void			Clear(uint32 color);
		void			BlitWrite(int x, int y, const Surface& source);
		Surface*		Lock();
		void			Unlock();
		void			SetPalette(const Color32 palette[]);
		void			PageFlip(bool retrace=true);

		private:

		void*			mContext;
	};

} // namespace prcore



#endif