/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_FILESTREAM_HPP
#define PRCORE_FILESTREAM_HPP



namespace prcore
{

	class FileStream : public Stream
	{
		public:
		
		FileStream(const char* filename, AccessMode mode=READ);
		~FileStream();
		
		int			Seek(int delta, SeekMode mode);
		int			Read(void* target, int bytes);
		int			Write(const void* source, int bytes);
		int			GetOffset() const;
		int			GetSize() const;
		bool		IsOpen() const;
		bool		IsEOS() const;

static	void		SetBasePath(const char* path);
static	void		SetPassword(const char* password);

		private:
		
		enum { CACHE_BITS = 12, CACHE_SIZE = (1<<CACHE_BITS) };
		
		Stream*		stream;
		char		cache[CACHE_SIZE];
		int			offset;
		int			page;
	};


	struct FileFactory
	{
		int			(*NumEXT)();
		const char*	(*GetEXT)(int index);
		bool		(*IsReader)();
		bool		(*IsWriter)();
		Stream*		(*CreateFile)(const char* path, const char* filename, Stream::AccessMode mode,void* password);
	};

} // namespace prcore



#endif