/********************************************************************

"THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
PURSUANT TO THE 3DFX FXT1 GENERAL PUBLIC LICENSE. A COPY OF THIS
LICENSE MAY BE OBTAINED FROM THE DISTRIBUTOR OR BY CONTACTING 3DFX
INTERACTIVE INC.  

TO THE EXTENT PERMITTED BY APPLICABLE LAW, THERE IS NO WARRANTY FOR
THIS PROGRAM. THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THIS
PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR
IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK
AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD
THIS PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
SERVICING, REPAIR OR CORRECTION.

IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, WILL 3DFX INTERACTIVE,
INC., OR ANY OTHER COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
AND/OR REDISTRIBUTE THIS PROGRAM OR DERIVATIVE WORKS AS PERMITTED
ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THIS PROGRAM OR DERIVATIVE WORKS (INCLUDING BUT NOT
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES
SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THIS PROGRAM OR
DERIVATIVE WORKS TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH
HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
THE UNITED STATES.  COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS
RESERVED"

********************************************************************/

/*
** COMPPB.H
** 
** 9/02/99 rufus@3dfx.com
** Original release cleanup.
*/

#ifndef _COMPPB_
#define _COMPPB_

#ifdef __cplusplus
extern "C" {
#endif 

#define COMP_MAGIC 'TEXC'

typedef struct {
  FxU32 magic;
  FxU32 pad;
  FxU32 width;
  FxU32 height;
} CompHeader;

#define CCCLEAR(cc) (cc).w[0] = (cc).w[1] = (cc).w[2] = (cc).w[3] = 0

#define SETBIT(var, which, val) { (var) &= ~(1 << (which));  (var) |= (val) << (which);  }

#define GETBIT(var, which) (((var) >> (which)) & 1)

#define CC_SETBIT(cc, which, val) SETBIT((cc).w[(which) >> 5], (which) & 31, val)

#define CC_GETBIT(cc, which) GETBIT((cc).w[(which) >> 5], (which) & 31)

#define CC_MIXED_MODE           127
#define CC_MIXED_GLSB_1     126
#define CC_MIXED_GLSB_0     125
#define CC_MIXED_ALPHA          124
#define CC_MIXED_COLOR_2    94
#define CC_MIXED_COLOR_0    64
#define CC_MIXED_TEXELS_HI  32
#define CC_MIXED_TEXELS_LO  0

#define CC_HI_MODE_1            127
#define CC_HI_MODE_0            126
#define CC_HI_COLOR_1           111
#define CC_HI_COLOR_0           96
#define CC_HI_TEXELS            0

#define CC_CHROMA_MODE_2        127
#define CC_CHROMA_MODE_1        126
#define CC_CHROMA_MODE_0        125
#define CC_CHROMA_COLOR_3       109
#define CC_CHROMA_COLOR_2       94
#define CC_CHROMA_COLOR_1       79
#define CC_CHROMA_COLOR_0       64
#define CC_CHROMA_TEXELS        0

#define CC_ALPHA_MODE_2         127
#define CC_ALPHA_MODE_1         126
#define CC_ALPHA_MODE_0         125
#define CC_ALPHA_LERP           124
#define CC_ALPHA_ALPHA_2        119
#define CC_ALPHA_ALPHA_1        114
#define CC_ALPHA_ALPHA_0        109
#define CC_ALPHA_COLOR_2        94
#define CC_ALPHA_COLOR_1        79
#define CC_ALPHA_COLOR_0        64
#define CC_ALPHA_TEXELS         0
#define CC_ALPHA_TEXELS_HI  32
#define CC_ALPHA_TEXELS_LO  0

typedef struct {
  FxU32 w[4];
} CCBlock;


#ifndef ABS
#define ABS(x) ( (x) < 0 ? -(x) : (x) )
#endif

#ifndef MAX
#define MAX(a, b) (((a) < (b)) ? (b) : (a))
#endif

#ifndef MIN
#define MIN(a, b) (((a) > (b)) ? (b) : (a))
#endif

void FillPallette4(int alpha, FxI32 colors[4][4], FxI32 lo[3], FxI32 hi[3]);
void FillPallette8(FxI32 colors[8][4], FxI32 lo[3], FxI32 hi[3]);

extern int colorBitsMIXED[2];
extern int texelBitsMIXED[2];
extern int texelBitsALPHA[2];
extern int channelShift[4];


extern char *CFnames[];

extern int CFhistogram[];             /* histogram of each mode selected */

extern int numBlocks;
extern double totalRMS;

extern int ForceMethod;
extern int DisallowMethod;


extern int debug;
//extern FILE *fdebug;

void DecodeCCBlock(FxU32 width, int x, int y,
                   FxI32 *pixelsOut,
                   CCBlock blockIn);

typedef void (*FXT1CallbackFunc)(CCBlock *ccblock, int size );

void decode4x8(ImgInfo *info, CCBlock* blocks, int verbose);
int encode4x8(ImgInfo *info, FXT1CallbackFunc , int verbose);


#ifdef __cplusplus
}
#endif 

#endif
