/***********************************************
 *        message printing                     *
 * Skal 96                                     *
 ***********************************************/

#include "main.h"
#include <errno.h>

EXTERN FILE *_Std_Out_ = stdout;
EXTERN FILE *_Std_Err_ = stderr;

/*******************************************************************/

EXTERN void Exit_Upon_Mem_Error( char *Str, INT Size )
{
   if ( Str == NULL ) fprintf( _Std_Err_, "Malloc Failure !\n" );
   else if ( Size ) fprintf( _Std_Err_, "Can't malloc %d bytes for '%s'.\n",
      Size, Str );
   else fprintf( _Std_Err_, "No more mem for '%s'.\n", Str );
   exit( 1 );
}

/***********************************************************************/

EXTERN void *Out_Error( char *Format, ... )
{
   va_list Arg_List;

   if ( Format==NULL ) return( NULL );
   if ( _Std_Err_ == NULL ) _Std_Err_ = stderr;

   fprintf( _Std_Err_, "Error:" );
   va_start( Arg_List, Format );
   vfprintf( _Std_Err_, Format, Arg_List );
   va_end( Arg_List );

   fprintf( _Std_Err_, "\n" );
   return( NULL );
}

EXTERN void *P_Error( char *s )
{
   if ( s==NULL ) return( NULL );
   if ( _Std_Err_ == NULL ) return( NULL );
   fprintf( _Std_Err_, "Error in %s(): %s\n", s, strerror( errno ) );
   fflush( _Std_Err_ );
   return( NULL );
}

EXTERN void Exit_Upon_Error( char *Format, ... )
{
   va_list Arg_List;

   if ( Format==NULL ) return;
   if ( _Std_Err_ == NULL ) _Std_Err_ = stderr;

   fprintf( _Std_Err_, "Error:" );
   va_start( Arg_List, Format );
   vfprintf( _Std_Err_, Format, Arg_List );
   va_end( Arg_List );

   fprintf( _Std_Err_, "\n" );
#if defined( LNX ) || defined( UNIX )
   fprintf( _Std_Err_, "\n" );
#endif

   exit( 1 );
}

EXTERN void *Out_Message( char *Format, ... )
{
   va_list Arg_List;

   if ( Format==NULL ) return( NULL );
   if ( _Std_Out_ == NULL ) return( NULL );

   va_start( Arg_List, Format );
   vfprintf( _Std_Out_, Format, Arg_List );
   va_end( Arg_List );

   fprintf( _Std_Out_, "\n" ); 
   fflush( _Std_Out_ );

   return( NULL );
}

EXTERN void *Out_String( char *Format, ... )
{
   va_list Arg_List;

   if ( Format==NULL ) return( NULL );
   if ( _Std_Out_ == NULL ) return( NULL );

   va_start( Arg_List, Format );
   vfprintf( _Std_Out_, Format, Arg_List );
   va_end( Arg_List );

   fflush( _Std_Out_ );

   return( NULL );
}

/***********************************************************************/


