/***********************************************
 *              Mem transfert                  *
 * Skal 96                                     *
 ***********************************************/

#ifndef _MASKS_H_
#define _MASKS_H_

/********************************************************/

typedef enum {
   RGB_MASK_TYPE,
   INDEXER_TYPE,
   DITHERER_TYPE,
   COLOR_CMAP_TYPE
} CMAPPER_TYPE;

typedef struct RGB_MASK RGB_MASK;
typedef struct COLOR_INDEXER COLOR_INDEXER;
typedef struct COLOR_DITHERER COLOR_DITHERER;
typedef struct COLOR_CMAP COLOR_CMAP;
typedef struct _DUMMY_ _DUMMY_;

typedef union {
  RGB_MASK *Mask;
  COLOR_INDEXER *Indexer;
  COLOR_DITHERER *Ditherer;
  COLOR_CMAP *Matcher;
  _DUMMY_ *Dummy;
} CMAPPER;

struct _DUMMY_ {     /* Common fields... Beware of casts and union access...*/
   CMAPPER_TYPE Type;
   void (*Col_Convert)( CMAPPER *, PIXEL *, PIXEL *, INT );
   UINT Stamp;
};

struct RGB_MASK {
   CMAPPER_TYPE Type;
   void (*Col_Convert)( CMAPPER *, PIXEL *, PIXEL *, INT );
   UINT Masks[ 256*4 ];
   FORMAT In, Out;
   UINT Users;
};

struct COLOR_INDEXER {
   CMAPPER_TYPE Type;
   void (*Col_Convert)( CMAPPER *, PIXEL *, PIXEL *, INT );
   UINT Stamp;
   COLOR_ENTRY Orig_Cols[ 256 ];
   COLOR_ENTRY Fmt_Cols[ 256 ];
   FORMAT Out;
};

struct COLOR_DITHERER {
   CMAPPER_TYPE Type;
   void (*Col_Convert)( CMAPPER *, PIXEL *, PIXEL *, INT );
   UINT Stamp;
   COLOR_ENTRY Match[ 256 ];  /* <= must be same offset than Cols in COLOR_CMAP */
   COLOR_ENTRY Cols[ 256 ];
   UINT *Dst_Stamp;
};

struct COLOR_CMAP {
   CMAPPER_TYPE Type;
   void (*Col_Convert)( CMAPPER *, PIXEL *, PIXEL *, INT );
   UINT Stamp;
   COLOR_ENTRY Cols[ 256 ];
   UINT *Dst_Stamp;
};

/********************************************************/

extern UINT Bit_Masks[];

extern FORMAT Compute_Format_Depth( FORMAT Format );

extern UINT Packed_Field_Pos( FORMAT Format );
extern void Format_Mask_And_Shift( FORMAT Format, UINT Mask[], UINT Shift[] );
extern void Build_RGB_Convertion_Mask( FORMAT In, FORMAT Out, UINT *Tab );
extern RGB_MASK *New_Masks( FORMAT In, FORMAT Out );
extern void Destroy_Mask( RGB_MASK *);
extern void Clean_Up_Masks( );
extern void Dispose_Mask( RGB_MASK *Mask );

extern COLOR_CMAP *New_Color_Matcher( );
extern COLOR_DITHERER *New_Color_Ditherer( MEM_ZONE *Src );
extern COLOR_INDEXER *New_Color_Indexer( FORMAT Out );

extern void Drv_Store_Formatted_CMap( UINT *Dst, COLOR_ENTRY *CMap, INT Nb, FORMAT Format );
extern void Drv_Store_CMap( COLOR_ENTRY *Dst, COLOR_ENTRY *Src, INT Nb );

extern MEM_ZONE *Drv_Install_Converter( MEM_ZONE *M );


extern MEM_ZONE *Install_Index_To_Any( MEM_ZONE *M, FORMAT Dst, UINT * );
extern MEM_ZONE *Install_RGB_To_Any( MEM_ZONE *M, FORMAT Fmt_Dst, UINT * );
extern void Clear_CMapper( MEM_ZONE *M );

/********************************************************/

#endif /* _MASKS_H_ */


