/*****************************************************
 *          Colors
 *****************************************************/

#include "main.h"

/********************************************************************/

EXTERN void Drv_RGB_To_CMap_Entry( COLOR_ENTRY *CMap, PIXEL *Ptr, INT Nb )
{
   INT i;
   for( i=0; i<Nb; ++i )
   {
      CMap[i][RED_F] = *Ptr++;  
      CMap[i][GREEN_F] = *Ptr++;
      CMap[i][BLUE_F] = *Ptr++;
      CMap[i][INDEX_F] = i;
   }
}

EXTERN void Drv_Fill_Pal( COLOR_ENTRY *Pal, INT I, PIXEL r, PIXEL g, PIXEL b )
{
   while( I-- ) 
   {
      Pal[0][RED_F] = r; Pal[0][GREEN_F] = g;  Pal[0][BLUE_F] = g; 
      Pal++;
   }
}

EXTERN INLINE void Drv_Black_Pal( COLOR_ENTRY *Pal, INT I )
{
   INT i;

   if ( Pal == NULL ) return;
   if ( I<=0 ) I=256;
   for( i=0; i<I; ++i )
   {
      Pal[0][RED_F] = Pal[0][GREEN_F] = Pal[0][BLUE_F] = 0; 
      Pal[0][INDEX_F] = i;
      Pal++;
   }
}

EXTERN INLINE void Drv_Copy_Pal( COLOR_ENTRY *Src, COLOR_ENTRY *Dst, INT Nb )
{
   if ( Nb ) memcpy( Dst, Src, Nb*sizeof( COLOR_ENTRY ) );
}
 
EXTERN COLOR_ENTRY *Drv_New_Colormap( INT Size )
{
   COLOR_ENTRY *Pal;

   if ( !Size ) return( NULL );
   Pal = New_Object( Size, COLOR_ENTRY );
   if ( Pal == NULL ) Exit_Upon_Mem_Error( "col. palette", Size*sizeof(COLOR_ENTRY) );

   return( Pal );
}


/********************************************************************/
/********************************************************************/

EXTERN COLOR_FADER *Drv_Setup_Fader(
   COLOR_FADER *CF, MEM_ZONE *Drv, INT Start, INT Size, INT Speed )
{
   if ( CF==NULL )
   {
      CF = New_Object( 1, COLOR_FADER );
      if ( CF == NULL ) Exit_Upon_Mem_Error( "Color fader", sizeof( COLOR_FADER ) );
   }
   CF->Drv = Drv;
   CF->Start = Start;
   CF->Size = Size;
   CF->Speed = Speed;
   if ( Speed<=0 ) Speed = 1;
   CF->Timer = Speed;
}

EXTERN SHORT Drv_Prepare_Fade_To_Color( COLOR_FADER *CF, PIXEL R, PIXEL G, PIXEL B )
{
   INT i;

   for( i=0; i<CF->Size; ++i )
   {
      CF->Dst_Pal[CF->Start+i][RED_F] = R;
      CF->Dst_Pal[CF->Start+i][GREEN_F] = G;
      CF->Dst_Pal[CF->Start+i][BLUE_F] = B;
      CF->Dst_Pal[CF->Start+i][INDEX_F] = CF->Pal[CF->Start+i][INDEX_F];
   }
}

EXTERN INLINE SHORT Drv_Do_Fade_To( COLOR_FADER *CF )
{
   INT i;

   if ( CF->Timer==0 ) return( 0 );
   else if ( CF->Timer==CF->Speed )
      for( i=0; i<CF->Size; ++i )
      {
         INT j;
         SHORT Tmp;

         j = i*6;

         Tmp = CF->Pal[CF->Start+i][RED_F]<<7;
         CF->Col_Fix8[ j ] = Tmp;        /* Cur col */
         Tmp = ( CF->Dst_Pal[CF->Start+i][RED_F]<<7 ) - Tmp;
         CF->Col_Fix8[ j+1 ] = Tmp/CF->Speed; /* Increment */
         j += 2;
         Tmp = CF->Pal[CF->Start+i][GREEN_F]<<7;
         CF->Col_Fix8[ j ] = Tmp;
         Tmp = ( CF->Dst_Pal[CF->Start+i][GREEN_F]<<7 ) - Tmp;
         CF->Col_Fix8[ j+1 ] = Tmp/CF->Speed;
         j += 2;
         Tmp = CF->Pal[CF->Start+i][BLUE_F]<<7;
         CF->Col_Fix8[ j ] = Tmp;
         Tmp = ( CF->Dst_Pal[CF->Start+i][BLUE_F]<<7 ) - Tmp;
         CF->Col_Fix8[ j+1 ] = Tmp/CF->Speed;
      }

   if ( CF->Timer>1 )
   {
      COLOR_ENTRY Final[256];
      for( i=0; i<CF->Size; i++ )
      {
         INT j;
         j = i*6;
         CF->Col_Fix8[ j ] += CF->Col_Fix8[ j+1 ];
         Final[i][RED_F] = (PIXEL)( CF->Col_Fix8[ j ]>>7 );
         j += 2;
         CF->Col_Fix8[ j ] += CF->Col_Fix8[ j+1 ];
         Final[i][GREEN_F] = (PIXEL)( CF->Col_Fix8[ j ]>>7 );
         j += 2;
         CF->Col_Fix8[ j ] += CF->Col_Fix8[ j+1 ];
         Final[i][BLUE_F] = (PIXEL)( CF->Col_Fix8[ j ]>>7 );

         Final[i][INDEX_F] = CF->Pal[ CF->Start+i ][INDEX_F];
      }
      Driver_Change_CMap( (MEM_ZONE *)CF->Drv, CF->Size, Final );
   }
   else
   {
      Driver_Change_CMap( (MEM_ZONE *)CF->Drv, CF->Size, CF->Dst_Pal+CF->Start );
      memcpy( CF->Pal + CF->Start, CF->Dst_Pal + CF->Start,
         CF->Size*sizeof( COLOR_ENTRY ) );
   }

   CF->Timer--;
   return( CF->Timer );
}

/********************************************************************/

EXTERN void Drv_Build_Ramp( COLOR_ENTRY *Pal, 
   INT Start, INT n,
	PIXEL r1, PIXEL g1, PIXEL b1, PIXEL r2, PIXEL g2, PIXEL b2 )
{
   INT i;
   static INT Next_Start = 0;

   if ( Pal == NULL ) return;
   if ( Start < 0 ) Start = Next_Start;
   if ( Start+n>256 ) n = 256-Start;
   Next_Start = Start + n;

   Pal += Start;
   for( i=0; i<n; ++i )
   {
      Pal[i][RED_F] = r1 + (r2-r1)*i/(n-1);
      Pal[i][GREEN_F] = g1 + (g2-g1)*i/(n-1);
      Pal[i][BLUE_F] = b1 + (b2-b1)*i/(n-1);
      Pal[i][INDEX_F] = Start+i;
   }
}

/********************************************************************/

EXTERN void Drv_Build_RGB_Cube( COLOR_ENTRY *Pal, FORMAT Format )
{
   int i, r, g, b, r_max, g_max, b_max;

   if ( Pal == NULL ) return;

   i = Format_Red_Bits(Format); r_max = (1<<i)-1;
   i = Format_Green_Bits(Format); g_max = (1<<i)-1;
   i = Format_Blue_Bits(Format); b_max = (1<<i)-1;

   i = 0;
   for( r=0; r<=r_max; ++r )
      for( g=0; g<=g_max; ++g )
         for( b=0; b<=b_max; ++b )
         {
            Pal[i][RED_F]   = r*255/r_max;
            Pal[i][GREEN_F] = g*255/g_max;
            Pal[i][BLUE_F]  = b*255/b_max;
            Pal[i][INDEX_F] = i;
            i++;
         }
}

/********************************************************************/
/********************************************************************/

EXTERN INT Drv_Best_Match_RGB( PIXEL R, PIXEL G, PIXEL B, COLOR_ENTRY *C, INT n )
{
   INT Dist, D, Best;

   Dist = 0x7FFFFFFF;
   Best = 0;
   for( n--; n>0; n-- )
   {
      INT x;
      x = (INT)R - C[n][RED_F]; D = x*x;
      x = (INT)G - C[n][GREEN_F]; D += x*x;
      x = (INT)B - C[n][BLUE_F]; D += x*x;
      if ( D<Dist ) { Dist = D; Best = n; }
   }
   return( Best );
}

/********************************************************************/

