/***********************************************
 *          Some DOS thingies                  *
 * Skal 96                                     *
 ***********************************************/

#include "main.h"

#if defined(DOS)

EXTERN int _The_DS_ = -1;
EXTERN unsigned _The_Segment_ = 0;
EXTERN USHORT Dos_Segment = 0;
EXTERN UINT Enabled = FALSE;

static _go32_dpmi_seginfo Dos_Info = { 0 };
static __dpmi_meminfo Mem_Info = { 0 };

/************************************************************/
/************************************************************/

EXTERN void Free_Dos_Buffer( )
{
   _go32_dpmi_free_dos_memory( &Dos_Info );
   Dos_Segment = 0; Dos_Info.size = 0;
}

EXTERN USHORT Allocate_Dos_Buffer( UINT Size )
{
   if ( Dos_Info.size != Size )
   {
      if ( Dos_Info.size != 0 )
      {
         _go32_dpmi_free_dos_memory( &Dos_Info );
         Dos_Segment = 0;
      }
      Dos_Info.size = Size;
      if ( _go32_dpmi_allocate_dos_memory( &Dos_Info ) )
      {
         SET_DRV_ERR( "Could not allocate DOS buffer" );
         Dos_Segment = 0; Dos_Info.size = 0;
         return( 0 );
      }
      Dos_Segment = Dos_Info.rm_segment;
   }
   return( Dos_Segment );
}

/************************************************************/

/* We only need these 2 funcs for mapping linear frame buffer.
 * So infos will stay in Mem_Info between the calls...
 * No safe, but that's it. :)
 */

EXTERN PIXEL *Map_Physical_Address( UINT Size, PIXEL *Address )
{
   Mem_Info.size = Size;
   Mem_Info.address = ( UINT )Address;

#if (DEBUG_VIDEO<2)
   Out_Message( "physical address: 0x%x Size: %d  __djgpp:0x%.8x",
      Mem_Info.address, Mem_Info.size, __djgpp_conventional_base );
#endif

   if ( __dpmi_physical_address_mapping( &Mem_Info ) == -1 ) 
   {
      SET_DRV_ERR2( "physical mapping of address 0x%x failed !\n", Address );
      return( NULL );
   }
   Address = ( PIXEL *)( Mem_Info.address );

#if (DEBUG_VIDEO<2)
   Out_Message( "Virtual address: 0x%x Size: %d  Returned:0x%.8x",
      Mem_Info.address, Mem_Info.size, Address );
#endif

   return( Address );
}

EXTERN void Unmap_Physical_Address( PIXEL *Address )
{
/* func 0x801 not found in CWSDPMI.EXE !!! 
   For PMODE/DJ, since physical and linear address are the same,
   it's ok.  so, let's skip that... */
/*
   Mem_Info.size = 0;
   Mem_Info.address = ( UINT )Address;
   if ( __dpmi_free_physical_address_mapping( &Mem_Info ) == -1 )
      Exit_Upon_Error( "__dpmi_free_physical_address_mapping() failed! Why?" );
*/
}

/************************************************************/

EXTERN STRING _Retreive_String( PIXEL *Ptr, INT n, STRING S )
{
   UINT Seg, Off;

   Seg = ( UINT )( *( USHORT *)( Ptr+2 ) );
   Off = ( UINT )( *( USHORT *)( Ptr ) );
   return( _Retreive_String2( Seg, Off, n, S ) );
}

EXTERN STRING _Retreive_String2( UINT Seg, UINT Off, INT n, STRING S )
{
   STRING Src;
   INT i;

   Src = (STRING)SEG_OFF_FP( Seg, Off );
   for( i=0; i<n-1; ++i )
   {
      char c;
      c = _farpeekb( _dos_ds, (unsigned)Src+i );
      if ( c=='\0' ) break;
      S[i] = c;
   }
   S[i] = '\0';
   return( S );
}

/************************************************************/

EXTERN void _Enable( PIXEL *Ptr, INT Size )
{
   unsigned Limit;

   if ( Enabled ) _Disable( );

   if ( !__djgpp_nearptr_enable( ) ) 
         goto Dos_Emu_Workaround;
   Enabled = 1;
   return;

Dos_Emu_Workaround:
      /*
       * Hopefully, linux's kernel won't resent setting _my_ds()
       * limit's to the desired Ptr+Size. At least, we can try :)
       */

   Limit = (unsigned)Ptr + Size + __djgpp_conventional_base;
   Limit |= 0xFFF;

   if ( __dpmi_set_segment_limit( _my_ds(), Limit ) )
      goto Really_Failed;
   if ( __dpmi_get_segment_limit( _my_ds() ) != Limit )
      goto Really_Failed;   /* We set it but DPMI ignored/truncated it */
   __dpmi_set_segment_limit( __djgpp_ds_alias, Limit );
   __dpmi_set_segment_limit( _my_cs(), Limit );
   Enabled = 2;
   return;

Really_Failed:
      /*
       * All right, all right... it all failed, so we're back
       * to this @#!&%*(#! selectors...:(
       */

   _The_Segment_ = (unsigned)Ptr & ~0xF;
   if ( _The_DS_==-1 )
   {
      _The_DS_ = __dpmi_segment_to_descriptor( _The_Segment_>>4 );
      if ( !_The_DS_ ) goto Get_The_Funk_Out;
   }
   Limit = ((unsigned)Ptr + Size ) | 0x1FFFF;
   if ( __dpmi_set_segment_base_address( _The_DS_, _The_Segment_ ) )
      goto Get_The_Funk_Out;
   if ( __dpmi_set_segment_limit( _The_DS_, Limit ) )
      goto Get_The_Funk_Out;

   Enabled = 3;
   return;

Get_The_Funk_Out:
   Exit_Upon_Error( " Fatal: Couldn't unprotect memory" );
}

EXTERN void _Disable( )
{
   if ( Enabled==1 )
      __djgpp_nearptr_disable( );
   /* else: don't touch _The_DS_... it's useless... */

   Enabled = 0;
   _The_Segment_ = 0;
}

EXTERN void Safe_Bzero( PIXEL *Ptr, INT Size )
{
   if ( Enabled != 3 )
   {
      bzero( Ptr+__djgpp_conventional_base, Size );
      return;
   }
   for( --Size; Size>=0; --Size )
      _farpokeb( _The_DS_, (unsigned)Ptr + Size, 0 );
}

EXTERN void DOSemu_MEM_Copy_Rect( MEM_ZONE *M,
   PIXEL *Dst, PIXEL *Src, INT Width, INT Height, INT Pad_Dst )
{
   INT Pad_Src;

   Pad_Src = MEM_BpS( M );

   if ( M->CMapper.Dummy==NULL || M->CMapper.Dummy->Col_Convert == NULL )
   {
      Width *= MEM_Quantum( M );
      while( Height-->0 )
      {
         movedata(
            _my_ds(), (unsigned)Src,
            _The_DS_, (unsigned)Dst,
            Width );
         Dst += Pad_Dst;
         Src += Pad_Src;
      }
   }
   else
   {
      if ( M->CMapper.Dummy->Type == DITHERER_TYPE )
      {
         if ( M->CMapper.Ditherer->Dst_Stamp != NULL &&
            ( *M->CMapper.Ditherer->Dst_Stamp > M->CMapper.Ditherer->Stamp ) )
         {
               /* Dst_Stamp != NULL means that M->Dst != NULL. We can match colors */
            Drv_Match_CMaps( M->CMapper.Ditherer->Match, M->Dst->CMapper.Matcher->Cols, 256 );
            M->CMapper.Ditherer->Stamp = *M->CMapper.Ditherer->Dst_Stamp;
         }
      }
      while( Height-->0 )
      {
         PIXEL Tmp[ 4*8192 ]; /* <= should be enough...*/
            /* !!! Beware of alignment */
         (*M->CMapper.Dummy->Col_Convert)( &M->CMapper, Tmp, Src, Width );
         movedata(
            _my_ds(), (unsigned)Tmp,
            _The_DS_, (unsigned)Dst,
            Pad_Dst );     /* <= !!!! */
         Dst += Pad_Dst;
         Src += Pad_Src;
      }
   }
}

/************************************************************/

#endif

