/*
 * test
 *
 **************************/

#include "sl.h"

#include <math.h>
int Count = 0;

#define RAD_SCALE   (2.0*M_PI/256.0)
PIXEL Timer1=0, Timer2=0;

INT The_W;
INT The_H;
MEM_IMAGE The_Screen;

/*********************************************************************/

void Clean( int dummy )
{
   Driver_Close( The_Screen );
   exit( 0 );
}

/*********************************************************************/

void main( int argc, char **argv )
{
   int i, j, n;
   STRING Mode_String;

   Mode_String = "320:200:0x000";

   if ( argc>1 ) Mode_String = argv[1];

   Register_Video_Support( 4, _G_DGA_DRIVER_,
      _G_X11_DRIVER_, _G_SVGL_DRIVER_, _G_VBE_DRIVER_ );

   The_Screen = Driver_Call( NULL,
      /* DRV_DISPLAY, ":0", */
      DRV_NAME, "simple test",
      DRV_DETECT,
      DRV_DONT_USE, _SHM_,
      DRV_PRINT_INFO,
      DRV_CONVERT,
      DRV_MODE, Mode_String,      
      DRV_END_ARG );
   if ( The_Screen == NULL ) 
   {
      Driver_Print_Error();
      exit( 1 );
   }

   for( n=1; n<Driver_Nb_Req_Modes( The_Screen ); ++n )
   {
      PIXEL *Ptr;
      int i;

      The_Screen = Driver_Open_Mode( The_Screen, n );
      if ( The_Screen == NULL ) 
      {
         Driver_Print_Error( );
         Clean( 0 );
      }

      The_W = Zone_Width( The_Screen );
      The_H = Zone_Height( The_Screen );

      Count = 0;

      for( i=0; i<Zone_Height( The_Screen ); ++i )
      {
         Ptr = Zone_Scanline( The_Screen, i );
         memset( Ptr, i^0xFF, (i+60)*Zone_Quantum( The_Screen ) );
      }
      Zone_Flush( The_Screen );
      while ( !( Driver_Get_Event(The_Screen) & DRV_KEY_PRESS ) );
   }

   Clean( 0 );
}

/*********************************************************************/

