/*
 * test
 *
 * Changing the colormap too often under X11
 * (as in vid.c) jams the XEvent queue.
 * this version don't change CMap...
 *
 **********************************************/

#include "sl.h"

#include <math.h>
int Count = 0;

#define RAD_SCALE   (2.0*M_PI/256.0)
PIXEL Timer1=0, Timer2=0;

PIXEL *Radial;

INT The_W;
INT The_H;
MEM_IMAGE The_Screen;

/*********************************************************************/

#define COL_AMP   64
static COLOR_ENTRY Col_Tab[ 256 ];

void Set_Col( MEM_IMAGE The_Screen )
{
   PIXEL Dst_Col[3], Src_Col[3];
   int i, j, k;

   Dst_Col[0] = Dst_Col[1] = Dst_Col[2] = 0;
   for( j=0; j<256; j+=COL_AMP )
   {
      for( i=0; i<3; ++i )
      {
         Src_Col[i] = Dst_Col[i];
         Dst_Col[i] = random()&0xFF;
      }
      for( k=0; k<COL_AMP;++k )
      {
         float x;
         x = (float)k/COL_AMP;
         for( i=0; i<3; ++i )
            Col_Tab[j+k][i] = (PIXEL)( (1.0-x)*Src_Col[i] + x*Dst_Col[i] );
         Col_Tab[j+k][INDEX_F] = j+k;
      }
   }
   Driver_Change_CMap( The_Screen, 256, Col_Tab );         
}

/*********************************************************************/

void Clean( int dummy )
{
   Driver_Close( The_Screen );
   exit( 0 );
}

/*********************************************************************/

void Do_Plasma1( MEM_IMAGE M )
{
   double x;
   UINT Src1, Src2;
   INT j;
   PIXEL *Radial1, *Radial2;
      
   Timer1 += 1; Timer2 -= 3;
   x = ( .5 + .3*cos( Timer1*RAD_SCALE ) );
   Src1 = (UINT)( x*The_W );
   x = ( .9 + .6*sin( Timer2*RAD_SCALE ) )*The_H;
   Src1 += (UINT)( x/2 )*The_W*2;

   x = .6 + .2*sin( .4125 + Timer1*RAD_SCALE );
   Src2 = (UINT)( x*The_W );
   x = ( .9 + .65*cos( .123 + Timer1*RAD_SCALE ) )*The_H;
   Src2 += (UINT)( x/2 )*The_W*2;

   Radial1 = Radial + Src1;
   Radial2 = Radial + Src2;

   for( j=Zone_Height(M)-1; j>=0; --j )
   {
      int i;
      PIXEL *Dst;
      Dst = Zone_Scanline( M, j );
      if ( Dst != NULL ) 
         for( i=Zone_Width(M)-1; i>=0; --i )
            Dst[i] = Radial1[ i ] + Radial2[ i ];
      Radial1 += The_W*2;
      Radial2 += The_W*2;
   }
}

/*********************************************************************/

void Main_Loop( MEM_IMAGE The_Screen )
{
   do {
/*
      Zone_Set_Position( The_Screen,
         (INT)( 30.0*cos( Count*M_PI/32.0 ) ),
         (INT)( 20.0*sin( 2.245 + Count*M_PI/35.0 ) ),
         FALSE );
*/
      Do_Plasma1( The_Screen );
      Zone_Flush( The_Screen );
      if ( Driver_Get_Event( The_Screen ) & DRV_KEY_PRESS ) break;
      Count++;
   }
   while( Count != 700 );
}

/*********************************************************************/

void main( int argc, char **argv )
{
   int i, j;
   PIXEL *Ptr;
   STRING Mode_String;

   Mode_String = "320:200:0x000";

   if ( argc>1 ) Mode_String = argv[1];

   Register_Video_Support( 4, _G_DGA_DRIVER_,
      _G_X11_DRIVER_, _G_SVGL_DRIVER_, _G_VBE_DRIVER_ );

   The_Screen = Driver_Call( NULL,
      /* DRV_DISPLAY, ":0", */
      DRV_NAME, "CMap test",
      /* DRV_DONT_USE, _SHM_, */
      /* DRV_DETECT, */
      DRV_PRINT_INFO,
      DRV_CONVERT,
      DRV_MODE, Mode_String,      
      DRV_END_ARG );
   if ( The_Screen == NULL ) 
   {
      Driver_Print_Error( );
      exit( 1 );
   }

   srandom( time(NULL) );
   Set_Col( The_Screen );

   The_W = Zone_Width( The_Screen );
   The_H = Zone_Height( The_Screen );

   Radial = New_Object( The_W*2 * The_H*2, PIXEL );

   Ptr = ( PIXEL *)Radial;
   for( j=0; j<The_H*2; ++j )
      for( i=0; i<The_W*2; ++i )
      {
         double Norm;

         Norm = 64.0+64.0*( 
            sin(i/30.0) + cos(j/16.0) + cos(i/27.0) + sin(j/23.0)
            + sin((i+j)/31.0 ) 
            /* + cos( sqrt( (256.0-i)*(256.0-i)+(150.0-j)*(150.0-j) )/16.0 ) */
         );
         *Ptr++ = ( PIXEL )floor( Norm );
      }

   Count = 0;

   Main_Loop( The_Screen );
   M_Free( Radial );

   Clean( 0 );
}

/*********************************************************************/
/*********************************************************************/
