/*
 * test video
 *
 * dumb 8bits plasma in several modes...
 * for instance, run:
 *  vid "320:200:0x0; 600:600:0x0"
 *
 **************************/

#include "sl.h"

#include <math.h>
int Count = 0;

#define RAD_SCALE   (2.0*M_PI/256.0)
PIXEL Timer1=0, Timer2=0;

UINT *Radial;

INT The_W;
INT The_H;
MEM_IMAGE The_Screen;

/*********************************************************************/

void Advance_Col( INT k );
static PIXEL Dst_Col[4], Src_Col[4];
#define COL_AMP   64
static COLOR_ENTRY Col_Tab[ 256 ];

/*********************************************************************/

void Clean( int dummy )
{
   Driver_Close( The_Screen );
   exit( 0 );
}

/*********************************************************************/

void Do_Plasma1( MEM_IMAGE M )
{
   double x;
   UINT Src1, Src2;
   INT j;
   UINT *Radial1, *Radial2;
      
   Timer1 += 1; Timer2 -= 3;
   x = .4 + .3*cos( Timer1*RAD_SCALE );
   Src1 = (UINT)( x*The_W ) / 2;
   x = ( .3 + .2*sin( Timer2*RAD_SCALE ) )*The_H;
   Src1 += ((UINT)x)*The_W;

   x = .3 + .2*sin( .4125 + Timer1*RAD_SCALE );
   Src2 = (UINT)( x*The_W ) / 2;
   x = ( .43 + .35*cos( .123 + Timer1*RAD_SCALE ) )*The_H;
   Src2 += ((UINT)x)*The_W;

   Radial1 = Radial + Src1;
   Radial2 = Radial + Src2;

   for( j=Zone_Height(M)-1; j>=0; --j )
   {
      UINT *Dst;
      int i;
      Dst = (UINT *)Zone_Scanline(M,j);
      if ( Dst != NULL )
         for( i=Zone_Width(M)/4-1; i>=0; --i )
            *Dst++ = Radial1[ i ] + Radial2[ i ];
      Radial1 += The_W;
      Radial2 += The_W;
   }
}

/*********************************************************************/

void Main_Loop( MEM_IMAGE The_Screen )
{
   do {
/*
      Zone_Set_Position( The_Screen,
         (INT)( 30.0*cos( Count*M_PI/32.0 ) ),
         (INT)( 20.0*sin( 2.245 + Count*M_PI/35.0 ) ),
         FALSE );
*/
      Do_Plasma1( The_Screen );
      Zone_Flush( The_Screen );
      Count++;
      Advance_Col( Count & (COL_AMP-1) );
      if ( Driver_Get_Event(The_Screen) & DRV_KEY_PRESS ) break;
   }
   while( Count != 700 );
}


/*********************************************************************/
#define  _f_(i,j)       \
Sin[ (i*23/30)&0xFF ] + Cos[ (i*55/27)&0xFF ] + Sin[ ((i+j)*37/31)&0xFF]

UINT *Build_Tab( MEM_IMAGE The_Screen )
{
   INT i, j;
   INT *Ptr;
   INT Cos[256], Sin[256];

   The_W = Zone_Width( The_Screen );
   The_H = Zone_Height( The_Screen );

   Radial = (UINT *)New_Object( The_W * The_H*2, INT );

   Ptr = ( INT *)Radial;
   if ( Ptr == NULL ) Clean( 0 );

   for(i=0; i<256; ++i ) { 
      Sin[i] = (INT)( 127.9*sin(2.0*M_PI*i/256.0) );
      Cos[i] = (INT)( 127.9*cos(2.0*M_PI*i/256.0) );
   }

   for( j=0; j<The_H*2; ++j )
   {
      INT xj;
      xj = Cos[ (j*34/16)&0xFF ] + Sin[ (j*80/23)&0xFF ];
      for( i=0; i<The_W*4; )
      {
         INT x; INT C;
         x = _f_(i,j); x += xj;
         C = (PIXEL)( x/4+64 )<<24;
         ++i;

         x = _f_(i,j); x += xj;
         C |= (PIXEL)( x/4+64 ) << 16;
         ++i;

         x = _f_(i,j); x += xj;
         C |= (PIXEL)( x/4+64 ) << 8;
         ++i;

         x = _f_(i,j); x += xj;
         C |= (PIXEL)( x/4+64 );
         ++i;

         *Ptr++ = C;
      }
   }
   return( Radial );
}

/*********************************************************************/

void main( int argc, char **argv )
{
   int i, j, n;
   STRING Mode_String;

   Mode_String = "320:200:0x000";

   if ( argc>1 ) Mode_String = argv[1];

   Register_Video_Support( 4, _G_DGA_DRIVER_,
      _G_X11_DRIVER_, _G_SVGL_DRIVER_, _G_VBE_DRIVER_ );

   The_Screen = Driver_Call( NULL,
      /* DRV_DISPLAY, ":0", */
      DRV_NAME, "CMap test",
      DRV_DETECT,
      DRV_PRINT_INFO,
      DRV_CONVERT,
      DRV_MODE, Mode_String,      
      DRV_END_ARG );
   if ( The_Screen == NULL ) 
   {
      Driver_Print_Error();
      exit( 1 );
   }

   srandom( 229 ); 
   for( i=0; i<3; ++i ) {
      Src_Col[i] = random( )&0xFF;
      Dst_Col[i] = random( )&0xFF;
   }
   srandom( time(NULL) );
   for( i=0; i<256; ++i ) Col_Tab[i][INDEX_F] = i;

   for( n=1; n<Driver_Nb_Req_Modes( The_Screen ); ++n )
   {
      PIXEL *Ptr;
      The_Screen = Driver_Open_Mode( The_Screen, n );
      if ( The_Screen == NULL ) 
      {
         Driver_Print_Error( );
         Clean( 0 );
      }

      The_W = Zone_Width( The_Screen );
      The_H = Zone_Height( The_Screen );

      Radial = Build_Tab( The_Screen );

      Count = 0;

      Main_Loop( The_Screen );

      M_Free( Radial );

   }
   Clean( 0 );
}

/*********************************************************************/

void Advance_Col( INT k )
{
   float x;
   PIXEL Col[3];
   int i;

   x = (float)k/COL_AMP;

   for( i=1; i<255; ++i )
   {
      Col_Tab[i][0] = Col_Tab[i+1][0];
      Col_Tab[i][1] = Col_Tab[i+1][1];
      Col_Tab[i][2] = Col_Tab[i+1][2];
      Col_Tab[i][INDEX_F] = i;
   }
   for( i=0; i<3; ++i )
      Col_Tab[255][i] = (PIXEL)( (1.0-x)*Src_Col[i] + x*Dst_Col[i] );

   Driver_Change_CMap( The_Screen, 256, Col_Tab );

   if (k==COL_AMP-1)
   {
      for(i=0; i<3; ++i )
      {
         Src_Col[i] = Dst_Col[i];
         Dst_Col[i] = random()&0xFF;
      }
   }
}

/*********************************************************************/

