/*
 * test video mode
 *
 * run with a string in argv[1] to test if
 * the video-mode(s) is(are) available
 *
 ********************************************/

#include "sl.h"

/*********************************************************************/

void main( int argc, char **argv )
{
   MEM_IMAGE The_Screen;
   STRING Mode_String;
   INT i;

   Mode_String = "320:200:0x000";   /* Default */

   if ( argc>1 ) Mode_String = argv[1];

   Register_Video_Support( 4, _G_DGA_DRIVER_,
      _G_X11_DRIVER_, _G_SVGL_DRIVER_, _G_VBE_DRIVER_ );

   The_Screen = Driver_Call( NULL,
      DRV_PRINT_INFO,
      DRV_NAME, "CMap test",
      DRV_DETECT,
      DRV_CONVERT,
      DRV_MODE, Mode_String,      
      DRV_END_ARG );
   if ( The_Screen == NULL )
   {
      Out_Message( "Driver_Call() failed for '%s'.", Mode_String );
      Driver_Print_Error( );
      exit( 1 );
   }

/*
   for( i=0; i<Drv_Nb_Req_Modes( The_Screen ); ++i )
   {
      Driver_Open_Mode( The_Screen, i+1 );
      while ( !(Driver_Get_Event(The_Screen) & DRV_KEY_PRESS ) );
   }
*/
   if ( Zone_Dst( The_Screen ) != NULL )
      Out_Message( "Convertion needed to format 0x%.4x", 
         Zone_Format( Zone_Dst( The_Screen ) ) );

   Driver_Close( The_Screen );
   exit( 0 );
}

/*********************************************************************/
