REM PROGRAMA DE DEMOSTRACION 3
REM SIMULACION DE UN ENTORNO VIRTUAL

REM CONTROLES:
REM Q: AVANZAR
REM A: RETROCEDER
REM P: GIRAR A LA DERECHA
REM O: GIRAR A LA IZQUIERDA
REM ESPACIO: AGACHARSE/LEVANTARSE
REM U: MEDIA VUELTA
REM S: TERMINAR

REM ESPECIFICA EL NIVEL DE DETALLE (0 A 3)
REM EN FUNCION DE LA VELOCIDAD DE TU ORDENADOR.

NIVEL = 0

REM INDICA CUAL ES LA TARJETA GRAFICA QUE PREFIERES EN LA VARIABLE TARJETA:
REM 1=CGA 4 COLORES (320 x 200 puntos)
REM 2=CGA 2 COLORES (640 x 200 puntos)
REM 3=EGA 16 COLORES (640 x 350 puntos)
REM 4=MCGA 2 COLORES (640 x 480 puntos)
REM 5=MCGA 256 COLORES (320 x 200 puntos)
REM 6=VGA/SVGA 16 COLORES (640 x 480 puntos)
REM 7=AT&T 2 COLORES (640 x 400 puntos)
REM 8=HERCULES 2 COLORES (720 x 348 puntos)
REM Para usar la tarjeta HERCULES, ejecutar antes desde DOS
REM la controladora de dispositivos MSHERC.COM

TARJETA = 1
GOSUB PREPARAR

REM LA VARIABLE ALTURA INDICA EL VALOR A SUMAR A LOS VERTICES AL AGACHARSE
ALTURA = -30

REM LA VARIABLE RELAS INDICA LA RELACION DE ASPECTO DEL DISPOSITIVO DE SALIDA

RELAS = 3 / 4
IF RELAS <= 1 THEN
     REX = 480 / RELAS
     REY = 480
ELSE
     REX = 480
     REY = 480 * RELAS
END IF

RELX = (XMAX + 1) / REX
RELY = (YMAX + 1) / REY

REM INCR ES EL FACTOR DE INCREMENTO PARA LA ROTACION
REM E INCREM PARA EL DESPLAZAMIENTO
REM SI EL PROGRAMA VA MUY RAPIDO, REDUCE SU VALOR

INCR = 3.141592 / 15
INCREM = 40

REM D ES LA DISTANCIA DESDE EL OBSERVADOR A LA PANTALLA EN PIXELS

D = 600

REM INICIO

REM LEEMOS LA TABLA DE DATOS

IF NIVEL = 0 THEN
	TOTV = 16
	TOTL = 21
END IF
IF NIVEL = 1 THEN
	TOTV = 28
	TOTL = 35
END IF
IF NIVEL = 2 THEN
	TOTV = 46
	TOTL = 56
END IF
IF NIVEL = 3 THEN
	TOTV = 74
	TOTL = 96
END IF

REM LEEMOS LOS VERTICES

RESTORE VERTICES
DIM V(TOTV - 1, 2)
FOR N = 0 TO TOTV - 1
     FOR F = 0 TO 2
	  READ V(N, F)
     NEXT F
NEXT N

REM LEEMOS LOS SEGMENTOS

RESTORE SEGMENTOS
DIM L(TOTL - 1, 3)
FOR N = 0 TO TOTL - 1
     FOR F = 0 TO 2
	  READ L(N, F)
     NEXT F
NEXT N

REM AJUSTAMOS LOS COLORES

FOR N = 0 TO TOTL - 1
     COLORES = L(N, 2)
     IF NUMCOLOR = 2 THEN COLORES = 1
     IF NUMCOLOR = 4 THEN COLORES = COLORES * 3 / 16 + 1
     L(N, 2) = COLORES
NEXT N

REM BUCLE PRINCIPAL

A$ = INKEY$
WHILE A$ <> "S" AND A$ <> "s"
     CLS
     PRINT "(C) 1994 RASTER SOFT."
    
     REM IMPRIMIMOS LOS SEGMENTOS
    
     FOR N = 0 TO TOTL - 1
	       XI = V(L(N, 0), 0)
	       YI = V(L(N, 0), 1)
	       ZI = V(L(N, 0), 2)
	       XF = V(L(N, 1), 0)
	       YF = V(L(N, 1), 1)
	       ZF = V(L(N, 1), 2)
	       COLORES = L(N, 2)
	       GOSUB PINTAR
     NEXT N
     A$ = INKEY$
     WHILE A$ = ""
	 A$ = INKEY$
     WEND
     IF A$ = "U" OR A$ = "u" THEN
	  AY = 3.141591
	  GOSUB ROTA
     END IF
     IF A$ = "P" OR A$ = "p" THEN
	  AY = INCR
	  GOSUB ROTA
     END IF
     IF A$ = "O" OR A$ = "o" THEN
	  AY = -INCR
	  GOSUB ROTA
     END IF
     IF A$ = "Q" OR A$ = "q" THEN
	  SUMA = -INCREM
	  GOSUB INCREM
     END IF
     IF A$ = "A" OR A$ = "a" THEN
	  SUMA = INCREM
	  GOSUB INCREM
     END IF
     IF A$ = " " THEN
	  ALTURA = -ALTURA
	  GOSUB SUBIR
     END IF
WEND
END
   
REM CALCULAMOS LAS ROTACIONES PARA CADA UNO DE LOS VERTICES
  
ROTA:
     A$ = ""
     SA = SIN(AY)
     CA = COS(AY)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 0)
	  C2 = (V(N, 2))
	  GOSUB ROTAR
	  V(N, 0) = C1
	  V(N, 2) = C2
     NEXT N
     RETURN

INCREM:
    
     REM CALCULAMOS EL DESPLAZAMIENTO PARA CADA VERTICE
    
     A$ = ""
     FOR N = 0 TO TOTV - 1
	  V(N, 2) = V(N, 2) + SUMA
     NEXT N
     RETURN

SUBIR:
    
     REM SUMAMOS O RESTAMOS LA CANTIDAD A LA COORDENADA Y
     REM (VERTICAL) DE CADA VERTICE
    
     A$ = ""
     FOR N = 0 TO TOTV - 1
	  V(N, 1) = V(N, 1) + ALTURA
     NEXT N
     RETURN

REM SUBRUTINA DE ROTACION

ROTAR:
     ALFA = C1 * CA - C2 * SA
     C2 = C1 * SA + C2 * CA
     C1 = ALFA
     RETURN

PINTAR:

REM SI LA LINEA TIENE LOS DOS PUNTOS POR DETRAS DEL OBSERVADOR (ZI y ZF < 0)
REM NO LA PINTAMOS

IF ZI > 0 OR ZF > 0 THEN
	PENDI = ZF - ZI
       
	REM SI LA DIFERENCIA ES CERO, LAS DOS Z SON IGUALES, LUEGO LA RECTA
	REM NO CORTARA AL PLANO XY
       
	IF PENDI <> 0 THEN
		M1 = (XF - XI) / PENDI
		M2 = (YF - YI) / PENDI
	       
		REM CALCULAMOS EL PUNTO DE CORTE CON EL PLANO XY
		REM SI EXISTE.
	       
		IF ZI <= 0 THEN
			ZI = 1
			XI = XF + (M1 * (ZI - ZF))
			YI = YF + (M2 * (ZI - ZF))
		END IF
		IF ZF <= 0 THEN
			ZF = 1
			XF = XI + (M1 * (ZF - ZI))
			YF = YI + (M2 * (ZF - ZI))
		END IF
	END IF
       
	REM PROYECTAMOS LOS PUNTOS Y LOS AJUSTAMOS A LA PANTALLA
       
	XI = RELX * ((XI * D) / ZI + REX / 2)
	YI = RELY * ((YI * D) / ZI + REY / 2)
	XF = RELX * ((XF * D) / ZF + REX / 2)
	YF = RELY * ((YF * D) / ZF + REY / 2)
	GOSUB LINEA
END IF
RETURN

LINEA:

REM SI LA RECTA ESTA FUERA DE LA PANTALLA, NO LA PINTAMOS

IF (XI >= 0 OR XF >= 0) AND (XI <= XMAX OR XF <= XMAX) AND (YI >= 0 OR YF >= 0) AND (YI <= YMAX OR YF <= YMAX) THEN
       
	DIF1 = XF - XI
	DIF2 = YF - YI
	SI = 1
       
				   
	REM SI LA RECTA NO ES NI HORIZONTAL NI VERTICAL
	REM CALCULAMOS SU INTERSECCION CON LOS BORDES DE LA
	REM PANTALLA
	       
	IF DIF1 <> 0 AND DIF2 <> 0 THEN
			MX = DIF2 / DIF1
			MY = DIF1 / DIF2
			X = XI
			Y = YI
			IF XI < 0 THEN
				XI = 0
				YI = Y - MX * X
			END IF
			IF YI < 0 THEN
				YI = 0
				XI = X - MY * Y
			END IF
			IF XF < 0 THEN
				XF = 0
				YF = Y - MX * X
			END IF
			IF YF < 0 THEN
				YF = 0
				XF = X - MY * Y
			END IF
			IF XI > XMAX THEN
				XI = XMAX
				YI = Y + MX * (XI - X)
			END IF
			IF YI > YMAX THEN
				YI = YMAX
				XI = X + MY * (YI - Y)
			END IF
			IF XF > XMAX THEN
				XF = XMAX
				YF = Y + MX * (XF - X)
			END IF
			IF YF > YMAX THEN
				YF = YMAX
				XF = X + MY * (YF - Y)
			END IF
		       
			REM SI DESPUES DE ESTO, ALGUNA COORDENADA X NOS
			REM SIGUE QUEDANDO FUERA, SIGNIFICA QUE ESA
			REM LINEA NO ESTA CONTENIDA EN LA PANTALLA
		       
			IF XI < 0 OR XF < 0 OR XI > XMAX OR XF > XMAX THEN SI = 0
			     
	  ELSE
		       
			REM SI ES VERTICAL, CALCULAMOS SU INTERSECCION AQUI

			IF DIF1 = 0 THEN
				IF YI < 0 THEN YI = 0
				IF YI > YMAX THEN YI = YMAX
				IF YF < 0 THEN YF = 0
				IF YF > YMAX THEN YF = YMAX
				
			ELSE

				REM Y SI ES HORIZONTAL, AQUI

				IF XI < 0 THEN XI = 0
				IF XI > XMAX THEN XI = XMAX
				IF XF < 0 THEN XF = 0
				IF XF > XMAX THEN XF = XMAX
				
			END IF
	       
	  END IF
	       
	  REM SI LA LINEA NO ESTA COMPLETAMENTE FUERA DE LA PANTALLA
	  REM LA PINTAMOS (VARIABLE SI=1)
	       
	  IF SI = 1 THEN
			LINE (XI, YI)-(XF, YF), COLORES
	  END IF
END IF
RETURN

PREPARAR:
  
     ON TARJETA GOSUB CGA1, CGA2, EGA, MCGA1, MCGA2, VGA, ATT, HERCULES
     CLS
     RETURN

CGA1:
     XMAX = 319
     YMAX = 199
     SCREEN 1
     NUMCOLOR = 4
     RETURN

CGA2:
     XMAX = 639
     YMAX = 199
     SCREEN 2
     NUMCOLOR = 2
     RETURN

EGA:
     XMAX = 639
     YMAX = 349
     SCREEN 9
     NUMCOLOR = 16
     RETURN

MCGA1:
     XMAX = 639
     YMAX = 479
     SCREEN 11
     NUMCOLOR = 2
     RETURN

MCGA2:
     XMAX = 319
     YMAX = 199
     SCREEN 13
     NUMCOLOR = 256
     RETURN

VGA:
     XMAX = 639
     YMAX = 479
     SCREEN 12
     NUMCOLOR = 16
     RETURN

ATT:
     XMAX = 639
     YMAX = 399
     SCREEN 4
     NUMCOLOR = 2
     RETURN

HERCULES:
     XMAX = 719
     YMAX = 347
     SCREEN 3
     NUMCOLOR = 2
     RETURN

DATOS:
     REM ESTA ES LA BASE DE DATOS DE LA ESTANCIA.
     REM ESTA REFERIDA A UNA PANTALLA DE 640 x 480
    
VERTICES:
    
     REM AQUI VIENE LA DEFINICION DE LOS VERTICES.
     REM EL PRIMER VALOR ES EL NUMERO DE VERTICES.
     REM CADA VERTICE VIENE DEFINIDO POR SUS TRES COORDENADAS.
   
REM PUNTOS DE LAS PAREDES

     DATA -350,-100,-300
     DATA 350,-100,-300
     DATA 350,100,-300
     DATA -350,100,-300
     DATA -350,-100,300
     DATA 350,-100,300
     DATA 350,100,300
     DATA -350,100,300
    
REM PUNTOS DE LA PUERTA
    
     DATA -50,100,300
     DATA -50,-50,300
     DATA 50,-50,300
     DATA 50,100,300
    
REM PUNTOS DE LA MESA
    
     DATA 50,100,120
     DATA 90,25,120
     DATA 26,25,96
     DATA 26,25,144
    
REM PUNTOS DEL CUADRO

     DATA 100,10,-300
     DATA -20,10,-300
     DATA -20,-70,-300
     DATA 100,-70,-300
    
REM PUNTOS DE LA ESTANTERIA

     DATA -350,-60,30
     DATA -300,-60,30
     DATA -300,-60,120
     DATA -350,-60,120
     DATA -350,-20,30
     DATA -300,-20,30
     DATA -300,-20,120
     DATA -350,-20,120

REM PUNTOS DE LA PIRAMIDE
    
     DATA -325,-35,60
     DATA -325,-20,40
     DATA -320,-20,63
     DATA -330,-20,47

REM PUNTOS DEL TABURETE
    
     DATA 60,50,80
     DATA 60,100,60
     DATA 73,100,87
     DATA 47,100,87
     DATA 60,50,95
     DATA 47,50,87
     DATA 47,50,73
     DATA 60,50,65
     DATA 73,50,73
     DATA 73,50,87

REM PUNTOS DEL POMO
    
     DATA 30,25,300
     DATA 30,20,297
     DATA 26,27,297
     DATA 34,27,297

REM PUNTOS DEL LIBRO

     DATA -350,-20,90
     DATA -350,-20,100
     DATA -310,-20,100
     DATA -310,-20,90
     DATA -350,-55,90
     DATA -350,-55,100
     DATA -310,-55,100
     DATA -310,-55,90

REM PUNTOS DEL SOFA

     DATA 350,100,100
     DATA 280,100,100
     DATA 280,50,100
     DATA 330,50,100
     DATA 330,20,100
     DATA 350,20,100
     DATA 350,100,300
     DATA 280,100,300
     DATA 280,50,300
     DATA 330,50,300
     DATA 330,20,300
     DATA 350,20,300
     DATA 280,65,115
     DATA 280,65,285
     DATA 335,65,285
     DATA 335,65,115
     DATA 280,50,115
     DATA 280,50,285
     DATA 335,50,285
     DATA 335,50,115


SEGMENTOS:
    
     REM AQUI VIENE LA DEFINICION DE LOS SEGMENTOS
     REM EL PRIMER NUMERO ES EL NUMERO DE LINEAS EN TOTAL
     REM DESPUES VIENE LA DEFINICION DE ESTAS:
     REM EL PRIMER NUMERO ES LA COORDENADA INICIAL
     REM (REFERIDA A LA BASE DE DATOS DE LOS VERTICES)
     REM EL SEGUNDO NUMERO ES LA COORDENADA FINAL
     REM EL TERCER NUMERO ES EL COLOR

REM LINEAS DE LAS PAREDES
    
     DATA 0,1,15
     DATA 1,2,15
     DATA 2,3,15
     DATA 3,0,15
     DATA 4,5,15
     DATA 5,6,15
     DATA 6,7,15
     DATA 7,4,15
     DATA 4,0,15
     DATA 1,5,15
     DATA 6,2,15
     DATA 3,7,15
    
REM LINEAS DE LA PUERTA
    
     DATA 8,9,9
     DATA 9,10,9
     DATA 10,11,9
    
REM LINEAS DE LA MESA
    
     DATA 12,13,14
     DATA 12,14,14
     DATA 12,15,14
     DATA 13,14,8
     DATA 13,15,8
     DATA 14,15,8
    
REM LINEAS DEL CUADRO
    
     DATA 16,17,3
     DATA 17,18,3
     DATA 18,19,3
     DATA 19,16,3
    
REM LINEAS DE LA ESTANTERIA
    
     DATA 20,21,7
     DATA 21,22,7
     DATA 22,23,7
     DATA 24,25,7
     DATA 25,26,7
     DATA 26,27,7
     DATA 24,27,7
     DATA 20,23,7
     DATA 27,23,7
     DATA 20,24,7

REM LINEAS DE LA PIRAMIDE

     DATA 28,29,4
     DATA 29,30,4
     DATA 30,28,4
     DATA 31,28,4
     DATA 31,29,4
     DATA 31,30,4

REM LINEAS DEL TABURETE

     DATA 32,33,11
     DATA 32,34,11
     DATA 32,35,11
     DATA 36,37,10
     DATA 37,38,10
     DATA 38,39,10
     DATA 39,40,10
     DATA 40,41,10
     DATA 41,36,10

REM LINEAS DEL POMO

     DATA 42,43,6
     DATA 43,44,6
     DATA 44,42,6
     DATA 45,42,6
     DATA 45,43,6
     DATA 45,44,6

REM LINEAS DEL LIBRO

     DATA 46,47,5
     DATA 47,48,5
     DATA 48,49,5
     DATA 49,46,5
     DATA 50,51,5
     DATA 51,52,5
     DATA 52,53,5
     DATA 53,50,5
     DATA 46,50,5
     DATA 47,51,5
     DATA 48,52,5
     DATA 49,53,5

REM LINEAS DEL SOFA

     DATA 54,55,13
     DATA 55,56,13
     DATA 56,57,13
     DATA 57,58,13
     DATA 58,59,13
     DATA 59,54,13
     DATA 60,61,13
     DATA 61,62,13
     DATA 62,63,13
     DATA 63,64,13
     DATA 64,65,13
     DATA 65,60,13
     DATA 55,61,13
     DATA 58,64,13
     DATA 59,65,13
     DATA 66,67,13
     DATA 67,68,13
     DATA 68,69,13
     DATA 69,66,13
     DATA 71,72,13
     DATA 57,63,13
     DATA 73,70,13
     DATA 70,66,13
     DATA 71,67,13
     DATA 72,68,13
     DATA 73,69,13
     DATA 71,62,13
     DATA 70,56,13

