Unit sbpmixer;

Interface


var
	base_port: Word; {*Puerto de la tarjeta*}

{----------------------------------------------------------------------------}

Procedure Reset_Mixer;
{*Resetea la mezcladora*}

{----------------------------------------------------------------------------}

Procedure set_adc(channel:Byte);
{*Selecciona la entrada del ADC;
0- Micrfono 1
1- CD
2- Micrfono 2
3- Entrada de lnea
*}

{----------------------------------------------------------------------------}

Procedure set_in_filter(filter:Byte);
{*Selecciona el filtro de entrada
0- filtro paso-bajo
1- filtro paso-alto
2- sin filtro
*}

{----------------------------------------------------------------------------}

Procedure set_stereo;
{*Pone la tarjeta en modo stereo*}

{----------------------------------------------------------------------------}

Procedure set_mono;
{*Pone la tarjeta en mono*}

{----------------------------------------------------------------------------}

Procedure set_out_filter(on:Byte);
{*Selecciona el filtro de salida
0- activado
1- desactivado
*}

{----------------------------------------------------------------------------}

Procedure set_volume(left,right:Byte;campo:Byte);
{*Selecciona el volumen:

0- Master
1- Voice
2- FM
3- CD
4- Lnea
5- Micrfono (toma el valor del canal izquierdo entre 0 y 7)

Los valores deben estar entre 0 y 15*}

{----------------------------------------------------------------------------}

Procedure get_adc(VAR channel:Byte);
{*Mira la entrada del ADC;
0- Micrfono 1
1- CD
2- Micrfono 2
3- Entrada de lnea
*}

{----------------------------------------------------------------------------}

Procedure get_in_filter(VAR filter:Byte);
{*Mira el filtro de entrada
0- filtro paso-bajo
1- filtro paso-alto
2- sin filtro
*}

{----------------------------------------------------------------------------}

Procedure get_out_filter(VAR on:Byte);
{*Mira el filtro de salida
0- activado
1- desactivado
*}

{----------------------------------------------------------------------------}

Procedure get_volume(VAR left,right:Byte;campo:Byte);
{*Mira el volumen:

0- Master
1- Voice
2- FM
3- CD
4- Lnea
5- Micrfono (toma el valor del canal izquierdo entre 0 y 7)

Los valores deben estar entre 0 y 15*}

{----------------------------------------------------------------------------}

Function get_stereo:Boolean;
{*Mira si la tarjeta est en modo stereo*}

{----------------------------------------------------------------------------}

Function get_mono:Boolean;
{*Mira si la tarjeta esta en mono*}

{----------------------------------------------------------------------------}
{----------------------------------------------------------------------------}
{----------------------------------------------------------------------------}
{----------------------------------------------------------------------------}
{----------------------------------------------------------------------------}

Implementation

Uses crt;

{----------------------------------------------------------------------------}

Procedure Reset_Mixer;

BEGIN
	port[base_port+4]:=0;
	port[base_port+5]:=0;
END;

{----------------------------------------------------------------------------}

Procedure set_adc(channel:Byte);
{*Selecciona la entrada del ADC;
0- Micrfono 1
1- CD
2- Micrfono 2
3- Entrada de lnea
*}

Var filter_status:Byte;

BEGIN
	port[base_port+4]:=$0C;
	filter_status:=port[base_port+5];         {*veo como est el filtro de entrada*}
	filter_status:=filter_status and 56;

	if channel in [0..3] then
		port[base_port+5]:=(channel shl 1) + filter_status;

END;

{----------------------------------------------------------------------------}

Procedure set_in_filter(filter:Byte);
{*Selecciona el filtro de entrada
0- filtro paso-bajo
1- filtro paso-alto
2- sin filtro
*}

VAR
	adc:Byte;

BEGIN
	port[base_port+4]:=$0C;        {*Veo el estado del ADC*}
	adc:=port[base_port+5];
	adc:=adc and 6;
	if filter in [0..2] then
		port[base_port+5]:=(filter shl 3) + adc;

END;

{----------------------------------------------------------------------------}

Procedure set_stereo;
{*Pone la tarjeta en modo stereo*}

Var
	dnfi:Byte;

BEGIN
	port[base_port+4]:=$0E;  {*Veo el estado del filtro de salida*}
	dnfi:=port[base_port+5];
	dnfi:=dnfi and 32;
	port[base_port+5]:=2 + dnfi;
END;

{----------------------------------------------------------------------------}

Procedure set_mono;
{*Pone la tarjeta en mono*}

Var
	dnfi:Byte;

BEGIN
	port[base_port+4]:=$0E;  {*Veo el estado del filtro de salida*}
	dnfi:=port[base_port+5];
	dnfi:=dnfi and 32;
	port[base_port+5]:=dnfi;
END;

{----------------------------------------------------------------------------}

Procedure set_out_filter(on:Byte);
{*Selecciona el filtro de salida
0- activado
1- desactivado
*}

Var
	dnfi:Byte;

BEGIN
	port[base_port+4]:=$0E;  {*Veo el estado de Stereo/Mono*}
	dnfi:=port[base_port+5];
	dnfi:=dnfi and 2;
	if on in [0..1] then
		port[base_port+5]:=(on shl 5) + dnfi;
END;

{----------------------------------------------------------------------------}

Procedure set_volume(left,right:Byte;campo:Byte);
{*Selecciona el volumen:

0- Master
1- Voice
2- FM
3- CD
4- Lnea
5- Micrfono (toma el valor del canal izquierdo entre 0 y 7)

Los valores deben estar entre 0 y 15*}

Var
	auxl,aux:Byte;
	indice:Word;

BEGIN
	if campo in [0..5] then
		case campo of
			0:indice:=$22;
			1:indice:=$04;
			2:indice:=$26;
			3:indice:=$28;
			4:indice:=$2E;
			5:begin
				indice:=$0A;
				if right>7 then right:=7;
			  end;
		end;

	if (left in [0..15]) and (right in [0..15]) then
		begin
			auxl:=left shl 4;
			aux:=auxl + right;
			port[base_port+4]:=indice;
			port[base_port+5]:=aux;
		end;
END;

{----------------------------------------------------------------------------}

Procedure get_adc(VAR channel:Byte);
{*Mira la entrada del ADC;
0- Micrfono 1
1- CD
2- Micrfono 2
3- Entrada de lnea
*}


BEGIN
	port[base_port+4]:=$0C;
	channel:=(port[base_port+5] shr 1) and 3;

END;

{----------------------------------------------------------------------------}

Procedure get_in_filter(VAR filter:Byte);
{*Mira el filtro de entrada
0- filtro paso-bajo
1- filtro paso-alto
2- sin filtro
*}

BEGIN

	port[base_port+4]:=$0C;
	filter:=(port[base_port+5] shr 3) and 3;

END;

{----------------------------------------------------------------------------}

Procedure get_out_filter(VAR on:Byte);
{*Mira el filtro de salida
0- activado
1- desactivado
*}

BEGIN
	port[base_port+4]:=$0E;
	on:=(port[base_port+5] shr 5) and 1;
END;

{----------------------------------------------------------------------------}

Procedure get_volume(VAR left,right:Byte;campo:Byte);
{*Selecciona el volumen:

0- Master
1- Voice
2- FM
3- CD
4- Lnea
5- Micrfono (toma el valor del canal izquierdo entre 0 y 7)

Los valores deben estar entre 0 y 15*}

Var
	auxl,aux:Byte;
	indice:Word;

BEGIN
	if campo in [0..5] then
		case campo of
			0:indice:=$22;
			1:indice:=$04;
			2:indice:=$26;
			3:indice:=$28;
			4:indice:=$2E;
			5:indice:=$0A;
		end;

	if (left in [0..15]) and (right in [0..15]) then
		begin
			port[base_port+4]:=indice;
			aux:=port[base_port+5];
		end;
	right:=(aux and 240) shr 4;
	left:=(aux shr 4) and 15;
END;

{----------------------------------------------------------------------------}

Function get_stereo:Boolean;
{*Mira si la tarjeta est en modo stereo*}

BEGIN
	port[base_port+4]:=$0E;
	get_stereo:=(port[base_port+5] and 2)=2;
END;

{----------------------------------------------------------------------------}

Function get_mono:Boolean;
{*Mira si la tarjeta esta en mono*}

BEGIN
	port[base_port+4]:=$0E;
	get_mono:=(port[base_port+5] and 2)=0;
END;

{----------------------------------------------------------------------------}

END.