REM PROGRAMA DE DEMOSTRACION 2
REM DIBUJO DE UN CUBO EN TRES DIMENSIONES
REM CON LA BASE DE DATOS OPTIMIZADA.

REM CONTROLES:
REM Q: SUBIR EL CUBO
REM A: BAJAR EL CUBO
REM P: MOVER A LA DERECHA EL CUBO
REM O: MOVER A LA IZQUIERDA EL CUBO
REM E: ALEJAR EL CUBO
REM D: ACERCAR EL CUBO
REM S: TERMINAR

REM INDICA CUAL ES LA TARJETA GRAFICA QUE PREFIERES EN LA VARIABLE TARJETA:
REM 1=CGA 4 COLORES (320 x 200 puntos)
REM 2=CGA 2 COLORES (640 x 200 puntos)
REM 3=EGA 16 COLORES (640 x 350 puntos)
REM 4=MCGA 2 COLORES (640 x 480 puntos)
REM 5=MCGA 256 COLORES (320 x 200 puntos)
REM 6=VGA/SVGA 16 COLORES (640 x 480 puntos)
REM 7=AT&T 2 COLORES (640 x 400 puntos)
REM 8=HERCULES 2 COLORES (720 x 348 puntos)
REM Para usar la tarjeta HERCULES, ejecutar antes desde DOS
REM la controladora de dispositivos MSHERC.COM

TARJETA = 1
GOSUB PREPARAR

REM LA VARIABLE RELAS INDICA LA RELACION DE ASPECTO DEL DISPOSITIVO DE SALIDA

RELAS = 3 / 4
IF RELAS <= 1 THEN
     REX = 480 / RELAS
     REY = 480
ELSE
     REX = 480
     REY = 480 * RELAS
END IF

RELX = XMAX / REX
RELY = YMAX / REY

REM INCR ES EL FACTOR DE INCREMENTO POR CADA PULSACION DE TECLA
REM SI EL PROGRAMA VA MUY RAPIDO, DISMINUYE SU VALOR

INCR = 10

REM D ES LA DISTANCIA DESDE EL OBSERVADOR A LA PANTALLA EN PIXELS

D = 1000

REM INICIO

REM ESTOS SON LOS INCREMENTOS INICIALES PARA LAS COORDENADAS X,Y,Z

IX = 0
IY = 0
IZ = 0

REM INICIALIZAMOS LA TABLA DE DATOS

RESTORE DATOS

REM LEEMOS LOS VERTICES

READ TOTV
DIM V(TOTV - 1, 2)
FOR N = 0 TO TOTV - 1
     FOR F = 0 TO 2
          READ V(N, F)
     NEXT F
NEXT N

REM LEEMOS LOS SEGMENTOS

READ TOTL
DIM L(TOTL - 1, 3)
FOR N = 0 TO TOTL - 1
     FOR F = 0 TO 2
          READ L(N, F)
     NEXT F
NEXT N

REM AJUSTAMOS LOS COLORES SEGUN EL MODO EN EL QUE NOS ENCONTREMOS

FOR N = 0 TO TOTL - 1
     COLORES = L(N, 2)
     IF NUMCOLOR = 2 THEN COLORES = 1
     IF NUMCOLOR = 4 THEN COLORES = COLORES * 3 / 16 + 1
     L(N, 2) = COLORES
NEXT N

REM EN C ALMACENAREMOS LAS PROYECCIONES DE LOS SEGMENTOS
REM PARA CONSEGUIR MAYOR VELOCIDAD

DIM C(TOTV - 1, 1)

REM BUCLE PRINCIPAL

FOR N = 0 TO TOTV - 1
     C(N, 0) = (V(N, 0) * D) / (V(N, 2) + D) + REX / 2
     C(N, 1) = (V(N, 1) * D) / (V(N, 2) + D) + REY / 2
NEXT N

A$ = INKEY$
WHILE A$ <> "S" AND A$ <> "s"
     CLS
     PRINT "(C) 1994 RASTER SOFT."
     FOR N = 0 TO TOTL - 1
         
               REM PINTAMOS LOS SEGMENTOS A PARTIR DE LAS COORDENADAS
               REM QUE TENEMOS CALCULADAS DE ANTEMANO. EN LA PRIMERA
               REM PASADA LA VARIABLE C NO TIENE NADA. POR ESO USO LA
               REM VARIABLE VECES.
  
               REM EN L (N,0) ESTA EL NUMERO DE VERTICE INICIAL DE LA LINEA N,
               REM Y EN L (N,1) ESTA EL NUMERO DE VERTICE FINAL.
               REM POR ESO USO SU VALOR COMO INDICE PARA C.
 
               XI = C(L(N, 0), 0)
               YI = C(L(N, 0), 1)
               XF = C(L(N, 1), 0)
               YF = C(L(N, 1), 1)
               COLORES = L(N, 2)
               GOSUB PINTAR
          NEXT N
          
     A$ = INKEY$
     WHILE A$ = ""
         A$ = INKEY$
     WEND
     IF A$ = "A" OR A$ = "a" THEN IY = IY + INCR
     IF A$ = "Q" OR A$ = "q" THEN IY = IY - INCR
     IF A$ = "P" OR A$ = "p" THEN IX = IX + INCR
     IF A$ = "O" OR A$ = "o" THEN IX = IX - INCR
     IF A$ = "E" OR A$ = "e" THEN IZ = IZ + INCR
     IF A$ = "D" OR A$ = "d" THEN IZ = IZ - INCR
    
     FOR N = 0 TO TOTV - 1
          X = V(N, 0) + IX
          Y = V(N, 1) + IY
          Z = V(N, 2) + IZ
         
          REM AQUI CALCULAMOS LA PROYECCION DE LOS VERTICES DEL CUBO
         
          GOSUB ECUACION
         
          REM Y LAS ALMACENAMOS EN LA VARIABLE C
         
          C(N, 0) = X
          C(N, 1) = Y
     NEXT N
WEND
END

REM SUBRUTINA DE PROYECCION PARA PASAR DE 3D A 2D

ECUACION:
     X = (X * D) / (Z + D) + REX / 2
     Y = (Y * D) / (Z + D) + REY / 2
     RETURN

PINTAR:
  
     LINE (XI * RELX, YI * RELY)-(XF * RELX, YF * RELY), COLORES
     RETURN

PREPARAR:
  
     ON TARJETA GOSUB CGA1, CGA2, EGA, MCGA1, MCGA2, VGA, ATT, HERCULES
     CLS
     RETURN

CGA1:
     XMAX = 320
     YMAX = 200
     SCREEN 1
     NUMCOLOR = 4
     RETURN

CGA2:
     XMAX = 640
     YMAX = 200
     SCREEN 2
     NUMCOLOR = 2
     RETURN

EGA:
     XMAX = 640
     YMAX = 350
     SCREEN 9
     NUMCOLOR = 16
     RETURN

MCGA1:
     XMAX = 640
     YMAX = 480
     SCREEN 11
     NUMCOLOR = 2
     RETURN

MCGA2:
     XMAX = 320
     YMAX = 200
     SCREEN 13
     NUMCOLOR = 256
     RETURN

VGA:
     XMAX = 640
     YMAX = 480
     SCREEN 12
     NUMCOLOR = 16
     RETURN

ATT:
     XMAX = 640
     YMAX = 400
     SCREEN 4
     NUMCOLOR = 2
     RETURN

HERCULES:
     XMAX = 720
     YMAX = 348
     SCREEN 3
     NUMCOLOR = 2
     RETURN



DATOS:
     REM ESTA ES LA BASE DE DATOS OPTIMIZADA DEL CUBO.
     REM ESTA REFERIDA A UNA PANTALLA DE 640 x 480
     REM AQUI VIENE LA DEFINICION DE LOS VERTICES.
     REM EL PRIMER VALOR ES EL NUMERO DE VERTICES.
     REM CADA VERTICE VIENE DEFINIDO POR SUS TRES COORDENADAS.
    
     DATA 8
     DATA -100,-100,-100
     DATA 100,-100,-100
     DATA 100,100,-100
     DATA -100,100,-100
     DATA -100,-100,100
     DATA 100,-100,100
     DATA 100,100,100
     DATA -100,100,100

     REM AQUI VIENE LA DEFINICION DE LOS SEGMENTOS
     REM EL PRIMER NUMERO ES EL NUMERO DE LINEAS EN TOTAL
     REM DESPUES VIENE LA DEFINICION DE ESTAS:
     REM EL PRIMER NUMERO ES LA COORDENADA INICIAL
     REM (REFERIDA A LA BASE DE DATOS DE LOS VERTICES)
     REM EL SEGUNDO NUMERO ES LA COORDENADA FINAL
     REM EL TERCER NUMERO ES EL COLOR

     DATA 12
     DATA 0,1,1
     DATA 1,2,2
     DATA 2,3,3
     DATA 3,0,4
     DATA 4,5,5
     DATA 5,6,6
     DATA 6,7,8
     DATA 7,4,9
     DATA 0,4,11
     DATA 1,5,12
     DATA 2,6,14
     DATA 3,7,15



