DEFINT A-Z

'
' Disk Format for disk images V1.0 written by Peter Weighill April 1994.
'

DECLARE SUB SETUP ()
DECLARE SUB EDITDISKNAME ()
DECLARE SUB CENTER (row, text$)
DECLARE SUB SAVE (t, s)

OPTION BASE 0
DIM SHARED blockrange(1 TO 35), tsoffset(1 TO 35, 0 TO 20) AS LONG
DIM SHARED buffer AS STRING * 256
DIM SHARED diskname AS STRING * 16, diskid AS STRING * 5
DIM SHARED blockstring(16 TO 20) AS STRING * 4

CONST ver$ = "v0.5 beta"

SETUP

CLS
COLOR 14, 0: CENTER 1, "Disk Format for disk images " + ver$
CENTER 2, "by Peter Weighill"
COLOR 7: LOCATE 5, 10
INPUT "Disk image name "; filename$
IF UCASE$(RIGHT$(filename$, 4)) = ".D64" THEN filename$ = MID$(filename$, LEN(filename$) - 4)
IF filename$ = "" THEN PRINT , "No file requested.": SYSTEM

OPEN filename$ + ".d64" FOR BINARY AS 1

diskname = "-C64 DISK IMAGE-": diskid = "00 2A"

COLOR 7: LOCATE 7, 10: PRINT "Edit disk header:"

EDITDISKNAME

COLOR 7: LOCATE 7, 28: PRINT diskname; ""; diskid; " "

COLOR 15
LOCATE 10, 10: PRINT "Formatting - Track: .."

FOR t = 35 TO 1 STEP -1
  LOCATE 10, 30: PRINT USING "##"; t
  FOR s = 0 TO blockrange(t)
    SAVE t, s
  NEXT s
NEXT t

LOCATE 10, 10: PRINT "Formatting - Writing directory"

MID$(buffer, 1, 2) = CHR$(0) + CHR$(255)
SAVE 18, 1

MID$(buffer, 1, 4) = CHR$(18) + CHR$(1) + "A" + CHR$(0)
MID$(buffer, 145, 23) = diskname + "" + diskid
FOR t = 1 TO 35
  MID$(buffer, 5 + (t - 1) * 4, 4) = blockstring(blockrange(t))
NEXT t
MID$(buffer, 5 + (18 - 1) * 4, 4) = CHR$(17) + CHR$(252) + CHR$(255) + CHR$(7)
SAVE 18, 0

CLOSE 1

COLOR 7, 0: CLS : PRINT "Ready."

SYSTEM

SUB CENTER (row, text$)
 LOCATE row, INT(40 - (LEN(text$) / 2))
 PRINT text$;
END SUB

SUB EDITDISKNAME

result$ = diskname + "" + diskid

done = 0
length = 23
cpos = 1

DO WHILE NOT done

  result$ = LEFT$(result$, 23)
 
  LOCATE 7, 28
  COLOR 14, 6: PRINT LEFT$(result$, cpos - 1);
  COLOR 0, 3: PRINT MID$(result$, cpos, 1);
  IF cpos < length + 1 THEN COLOR 14, 6: PRINT MID$(result$, cpos + 1, length);
  COLOR 3, 0: IF cpos = length + 1 THEN PRINT "";  ELSE PRINT " ";

  kbd$ = INKEY$
  IF kbd$ = CHR$(1) THEN kbd$ = CHR$(160)
  SELECT CASE kbd$
      CASE " " TO CHR$(255)
          IF cpos < length + 1 THEN
            MID$(result$, cpos, 1) = kbd$
            cpos = cpos + 1: IF cpos = 17 THEN cpos = 19
          END IF
      CASE CHR$(13), CHR$(9)
          done = -1
      CASE CHR$(27)
          COLOR 7, 0
          CLS
          PRINT "Aborted."
          SYSTEM
      CASE CHR$(0) + "M"
          cpos = cpos + 1: IF cpos > length + 1 THEN cpos = length + 1
          IF cpos = 17 THEN cpos = 19
      CASE CHR$(0) + "K"
          cpos = cpos - 1: IF cpos < 1 THEN cpos = 1
          IF cpos = 18 THEN cpos = 16
      CASE CHR$(0) + "G", CHR$(0) + "?"
          cpos = 1
      CASE CHR$(0) + "O", CHR$(0) + "@"
          cpos = length + 1
      CASE CHR$(0) + "S"
          p1$ = LEFT$(result$, 16)
          p2$ = RIGHT$(result$, 5)
          SELECT CASE cpos
            CASE 1 TO 16
              p1$ = LEFT$(p1$, cpos - 1) + MID$(p1$, cpos + 1) + " "
            CASE 19 TO 23
              p2$ = LEFT$(p2$, cpos - 19) + MID$(p2$, cpos - 17) + " "
          END SELECT
          result$ = LEFT$(p1$, 16) + "" + LEFT$(p2$, 5)
      CASE CHR$(0) + "R"
          p1$ = LEFT$(result$, 16)
          p2$ = RIGHT$(result$, 5)
          SELECT CASE cpos
            CASE 1 TO 15
              p1$ = LEFT$(p1$, cpos - 1) + " " + MID$(p1$, cpos)
            CASE 19 TO 22
              p2$ = LEFT$(p2$, cpos - 19) + " " + MID$(p2$, cpos - 18)
          END SELECT
          result$ = LEFT$(p1$, 16) + "" + LEFT$(p2$, 5)
      CASE CHR$(8)
          p1$ = LEFT$(result$, 16)
          p2$ = RIGHT$(result$, 5)
          SELECT CASE cpos
            CASE 2 TO 16
              cpos = cpos - 1
              p1$ = LEFT$(p1$, cpos - 1) + MID$(p1$, cpos + 1) + " "
            CASE 20 TO 23
              cpos = cpos - 1
              p2$ = LEFT$(p2$, cpos - 19) + MID$(p2$, cpos - 17) + " "
          END SELECT
          result$ = LEFT$(p1$, 16) + "" + LEFT$(p2$, 5)
  END SELECT

LOOP

COLOR 7, 0

diskname = LEFT$(result$, 16)
diskid = RIGHT$(result$, 5)


END SUB

SUB SAVE (t, s)

' Save a sector.

SEEK 1, tsoffset(t, s)
PUT 1, , buffer

END SUB

SUB SETUP

' Setup initial constants.

FOR i = 1 TO 35
  blockrange(i) = 20 + (i > 17) * 2 + (i > 24) + (i > 30)
NEXT i

offset& = 1
FOR i = 1 TO 35
  FOR j = 0 TO 20
    IF j > blockrange(i) THEN EXIT FOR
    tsoffset(i, j) = offset&: offset& = offset& + 256
  NEXT j
NEXT i

buffer = STRING$(256, 0)

blockstring(16) = CHR$(17) + CHR$(255) + CHR$(255) + CHR$(1)
blockstring(17) = CHR$(18) + CHR$(255) + CHR$(255) + CHR$(3)
blockstring(18) = CHR$(19) + CHR$(255) + CHR$(255) + CHR$(7)
blockstring(20) = CHR$(21) + CHR$(255) + CHR$(255) + CHR$(31)

END SUB

