#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <process.h>
#include <mem.h>

int MousePresent = 0;
int msv_active = 0;

typedef unsigned int WORD;
typedef unsigned long DWORD;

extern "C" void __interrupt msv_handler (void);
extern "C" void msv_hide(void);
extern "C" void msv_show(void);
extern "C" void msv_init(void);
#define MC_SIZE 32
extern "C" char far ms_mask[MC_SIZE][MC_SIZE];
extern "C" unsigned short far msv_cur_x;
extern "C" unsigned short far msv_cur_y;

void msv_inithandler(void)
{
 if (!MousePresent)
  return;

 int c,d;
 struct SREGS sregs;
 union REGS inregs, outregs;
 int (far *function_ptr)();

 segread(&sregs);
 inregs.w.ax = 0xC;
 inregs.w.cx = 1; // on mouse movement only 0x7f; //0x0002 + 0x0008;
 function_ptr = (int (far *)(void))msv_handler; //(int (far *)(void)) rmclickhandler;
 inregs.x.edx = FP_OFF( function_ptr );
 sregs.es     = FP_SEG( function_ptr );
 int386x( 0x33, &inregs, &outregs, &sregs );
 msv_active = 1;
}

void msv_deinithandler( void )
{
 if (!MousePresent)
  return;

 union REGS inregs, outregs;

 inregs.w.ax = 0xC;
 inregs.w.cx = 0;
 int386( 0x33, &inregs, &outregs );
 msv_active = 0;
}

void msv_setcursor( char *mc )
{
 _fmemcpy(ms_mask,mc,MC_SIZE*MC_SIZE);
}

//-------------------------------normal mouse fn-s below:

int mouse_installed( void )
{
 REGS regs;

 regs.w.ax = 0;
 int386( 0x33, &regs, &regs );
 MousePresent = (regs.w.ax != 0);
 return MousePresent;
}

void enable_software_cursor( void )
{
 if (!MousePresent)
  return;

 REGS r;

 r.w.ax = 1;
 int386(0x33,&r,&r);
 r.w.ax = 10;
 r.w.bx = 0;
 r.w.cx = 0xFFFF;
 r.w.dx = 0x7700;
 int386(0x33,&r,&r);
}

void read_mouse_position( int* x,int* y )
{
 if (!MousePresent)
  { *x=0; *y=0; return;}

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 *x = r.w.cx;
 *y = r.w.dx;
}

int left_button_pressed( void )
{
 if (!MousePresent)
  return 0;

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 return( r.w.bx & 1 );
}

int right_button_pressed( void )
{
 if (!MousePresent)
  return 0;

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 return( r.w.bx & 2 );
}

void m_hide( void )
{
 if (msv_active)
  {
   msv_hide();
   return;
  }

 if (!MousePresent)
  return;
 REGS r;
 r.w.ax = 2;
 int386(0x33,&r,&r);
}

void m_show( void )
{
 if (msv_active)
  {
   msv_show();
   return;
  }

 if (!MousePresent)
  return;
 REGS r;
 r.w.ax = 1;
 int386(0x33,&r,&r);
}

void set_mouse_window( int x1, int y1, int x2, int y2)
{
 if (!MousePresent)
  return;

 REGS r;
 r.w.ax = 7;
 r.w.cx = x1;
 r.w.dx = x2;
 int386(0x33,&r,&r);

 r.w.ax = 8;
 r.w.cx = y1;
 r.w.dx = y2;
 int386(0x33,&r,&r);
}

void set_mouse_speed( int xs, int ys )
{
 if (!MousePresent)
  return;

 REGS r;
 r.w.ax = 0xf;
 r.w.cx = xs;
 r.w.dx = ys;
 int386(0x33,&r,&r);
}
