;**
;** bimo.asm:
;** Assembler code for real-mode and protected-mode
;** INT 0xC interrupt handlers to support the INT 0xC
;** interrupt in both modes
;**
.386
;**
;** The real-mode interrupt handler is in a 16-bit code
;** segment so that the assembler will generate the right
;** code.  We will copy this code down to a 16-bit segment
;** in low memory rather than executing it in place.
;**

_TEXT16 SEGMENT BYTE PUBLIC USE16 'CODE'
    ASSUME  cs:_TEXT16

    PUBLIC  rmclickhandler_
rmclickhandler_:
    int 3
    push ds
    push es
    pusha

    mov ax,0a000h
    mov es,ax
    mov di,dx
    mov byte ptr es:[di],12

    popa
    pop es
    pop ds
   ; iret
    retf
_TEXT16 ENDS
  END
