#include <dos.h>
#include "mouse.h"
#include "vesax.h"

int MousePresent = 0;
int mouse_x, mouse_y;

int mouse_installed( void )
{
 REGS regs;

 regs.w.ax = 0;
 int386( 0x33, &regs, &regs );
 MousePresent = (regs.w.ax != 0);
 return MousePresent;
}

void enable_software_cursor( void )
{
 if (!MousePresent)
  return;

 REGS r;

 r.w.ax = 1;
 int386(0x33,&r,&r);
 r.w.ax = 10;
 r.w.bx = 0;
 r.w.cx = 0xFFFF;
 r.w.dx = 0x7700;
 int386(0x33,&r,&r);
}

void read_mouse_position( int* x,int* y )
{
 if (!MousePresent)
  { *x=0; *y=0; return;}

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 *x = r.w.cx;
 *y = r.w.dx;
}

int left_button_pressed( void )
{
 if (!MousePresent)
  return 0;

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 return( r.w.bx & 1 );
}

int right_button_pressed( void )
{
 if (!MousePresent)
  return 0;

 REGS r;

 r.w.ax = 3;
 int386(0x33,&r,&r);
 return( r.w.bx & 2 );
}

void m_hide( void )
{
 if (!MousePresent)
  return;
 REGS r;
 r.w.ax = 2;
 int386(0x33,&r,&r);
}

void m_show( void )
{
 if (!MousePresent)
  return;
 REGS r;
 r.w.ax = 1;
 int386(0x33,&r,&r);
}

int lm_x,lm_y,cm_x,cm_y;

void far mouse_gupdate( void )
{
// read_mouse_position(&cm_x,&cm_y);
 cm_x=mouse_x;
 cm_y=mouse_y;

 if ((lm_x==cm_x) && (lm_y==cm_y))
  return;

 vbe_putpixel(cm_x,cm_y,14);
 vbe_putpixel(lm_x,lm_y,0);
 lm_x=cm_x;
 lm_y=cm_y;
}
