#include <stdio.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <alloc.h>

#define EGYOLDAL 5                // Az egy oldalon lv sorok szma

void hanysorszamol( void );
void chksumszamol( void );
void chksumbeir( void );
void offsetbeir( void );
char code( char c);

int hanysor;
int hanyoldal;
int chksum[4];
int fh1;
int fh2;
int offsets[500];
char elozo=0xAA;

void main( int argc,char *argv[] )
{
 if (argc==1)
  {
   printf("-=NOSASOFT=-   TXT->ZZG  compiler   v1.0\n\rSyntax: TXT2ZZG filename\n\r");
   exit;
  }
 char *file2;
 char *cc;
 int count=0;
 if ( (fh1=open(argv[1],O_BINARY | O_RDWR))==-1)
  {
   printf("-=NOSASOFT=-   TXT->ZZG  compiler   v1.0\n\rFile not found.\n\r");
   exit;
  }
 strcpy(file2,argv[1]);
 file2[strlen(file2)-1]='G';
 file2[strlen(file2)-2]='Z';
 file2[strlen(file2)-3]='Z';
 fh2=creatnew(file2,0);
 file2[strlen(file2)-4]=0x00;
 strcat(file2,":\x0a");
 char *str1;
 str1=(char *)malloc(500);
 sprintf(str1,"; -----------This is a ZZG file for NOSASOFT ZIGZAG...\n\n");
 write(fh2,str1,strlen(str1));
 write(fh2,file2,strlen(file2));

 hanysorszamol();
 chksumszamol();
 chksumbeir();
 offsetbeir();

 lseek(fh2,0,SEEK_END);
 sprintf(str1,";------------------The DATA\n");
 write(fh2,str1,strlen(str1));

 char cc2;
 lseek(fh1,0,SEEK_SET);
 while(!eof(fh1))
 {
  strcpy(str1,"\x09""DB\x09'\x0");
  cc[0]=0;
  while(cc[0]!='\x0A')
  {
   read(fh1,cc,1);
   cc2=cc[0];
   cc[0]=code(cc[0]);
   cc[1]=0;
   if (cc[0]==39)
     strcat(str1,"',39,'");
   else if (cc[0]==13)
     strcat(str1,"',0Dh,'");
   else if (cc[0]==10)
     strcat(str1,"',0Ah,'");
   else
     strcat(str1,cc);
   cc[0]=cc2;
  }
  strcat(str1,"'\x0a");

  write(fh2,str1,strlen(str1));
 }
 close(fh1);
 close(fh2);
 free(str1);
}

void hanysorszamol( void )
{
 char cc;
 hanysor=0;
 lseek(fh1,0,SEEK_SET);
 while(!eof(fh1))
 {
  read(fh1,&cc,1);
  if (cc==0x0a) hanysor++;
 }
 hanyoldal=hanysor/EGYOLDAL;
 if (hanysor*EGYOLDAL>hanyoldal) hanyoldal++;


 offsets[0]=offsets[2]=0;
 int count=0;
 offsets[1]=8+1+2*hanyoldal+1;
 int offsetcount=2;
 hanysor=0;
 lseek(fh1,0,SEEK_SET);
 while(!eof(fh1))
 {
  read(fh1,&cc,1);
  count++;
  if (cc==0x0a)
  {
   hanysor++;
   if (hanysor%EGYOLDAL==0)
   {
    offsets[offsetcount]=8+1+2*hanyoldal+1+count;
    offsets[++offsetcount]=0;
   }
  }
 }
}

void chksumszamol( void )
{
 int count;
 char cc;
 lseek(fh1,0,SEEK_SET);
 count=0;
 chksum[0]=chksum[1]=chksum[2]=chksum[3]=0;
 while(!eof(fh1))
 {
  read(fh1,&cc,1);
  chksum[0]+=cc;
  chksum[1]-=cc;
  chksum[2]+=cc*count;
  chksum[3]-=cc*count;
  count++;
 }
}

void chksumbeir( void )
{
 char *str1=(char *)malloc(80);
 char *str2=(char *)malloc(80);
 int c;
 lseek(fh1,0,SEEK_END);
 sprintf(str1,";--------------The CHECKSUMS\n");
 write(fh2,str1,strlen(str1));
 for(c=0; c<=3; c++)
 {
  strcpy(str1,"\tDW\t");
  sprintf(str2,"%X",chksum[c]);
  strcat(str1,str2);
  strcat(str1,"h\x0A");
  write(fh2,str1,strlen(str1));
 }
 free(str1);
 free(str2);
}

void offsetbeir( void )
{
 char *str1=(char *)malloc(80);
 char *str2=(char *)malloc(80);
 int c;
 lseek(fh1,0,SEEK_END);
 sprintf(str1,";--------------The OFFSETS\n");
 write(fh2,str1,strlen(str1));

 sprintf(str1,"\tDB\t00h\n");
 write(fh2,str1,strlen(str1));
 c=1;
 while(offsets[c]!=0)
 {
  strcpy(str1,"\tDW\t");
  sprintf(str2,"%X",offsets[c]);
  strcat(str1,str2);
  strcat(str1,"h\x0A");
  write(fh2,str1,strlen(str1));
  c++;
 }
 sprintf(str1,"\tDB\t00h\n");
 write(fh2,str1,strlen(str1));
 free(str1);
 free(str2);
}

char code( char c)
{
 char cc=c;
 c=c^0x4A;
; c=c^elozo;
 elozo=c;
 return (c);
}