#include <dos.h>
#include <mem.h>

struct xmems
 {
  char far *addr;
  long size;
  char stat; // 0-empty, level of allocation
 };

unsigned basep;
xmems far *xinfo;
int xlast;
long lastpos;
long totsiz;
int curlevel;
int szabcnt;

long longnorm( char far *buf)
{
 long tm;
 tm=(long)FP_SEG(buf)*16;
 tm+=FP_OFF(buf);
 return tm;
}

char far *cfar( long addr )
{
 char far *re;
 re = (char far *)MK_FP((unsigned)(addr>>4),(unsigned)(addr&0xF));
 return re;
}


long xinit( void )
{
 union REGS inregs, outregs;
 struct SREGS segregs;

 inregs.h.ah = 0x48;
 inregs.x.bx = 0xFFFF;
 int86x(0x21, &inregs, &outregs, &segregs);

 long ml=16L*outregs.x.bx-1024;
 totsiz=ml;

 inregs.h.ah = 0x48;
 inregs.x.bx = ml/16;
 int86x(0x21, &inregs, &outregs, &segregs);
 if (outregs.x.flags&1)
  {
   return -1; //Error allocing
  }

 basep=outregs.x.ax;
 xinfo=(xmems far *)MK_FP(basep,0);
 lastpos=sizeof(xmems)*200; // max 200 allocs
 xlast=0;
 szabcnt=0;
 curlevel=1;

 return totsiz;
}


void xterm( void )
{
 union REGS inregs, outregs;
 struct SREGS segregs;

 inregs.h.ah = 0x49;
 segregs.es=basep;
 int86x(0x21, &inregs, &outregs, &segregs);
 basep=0;
}

//------------------------------------------------------------------//

void far *xalloc( unsigned /*long*/ size )
{
 char far *m;
 long g;
 unsigned a,b;
 int c;

 if (szabcnt)
  {
   for (c=0; c<xlast; c++)
    if (xinfo[c].stat==0 && xinfo[c].size>=size) // free
     {
      if (xinfo[c].size!=size)
       {
        a=xinfo[c].size-size;
        xinfo[c].size=size;
        xinfo[c].stat=curlevel;

        xinfo[xlast].size=a;
        xinfo[xlast].stat=0; //free
        g=longnorm(xinfo[c].addr)+size;
        xinfo[xlast].addr=cfar(g);
        xlast++;
        return(xinfo[c].addr);
       }
      else
       {
        xinfo[c].stat=curlevel;
        szabcnt--;
        return(xinfo[c].addr);
       }
     }
  }

 if ((totsiz-lastpos)<size)
  return NULL;

 int e=xlast;
 long ma=(((long)basep<<4) + lastpos );
 unsigned seg=ma>>4,off=ma&0xF;
 m=(char far *)MK_FP(seg,off);
 xinfo[e].addr=m;
 xinfo[e].size=size;
 xinfo[e].stat=curlevel;
 lastpos+=size;
 xlast++;

 return m;
}

void xfree(void far *block)
{
 int c;
 long tm,tm2;
 for (c=0; c<xlast; c++)
  if (xinfo[c].addr==block)
   {
    xinfo[c].stat=0;
    tm=(long)basep<<4;
    tm+=lastpos-1;

    tm2=((long)FP_SEG(xinfo[c].addr))*16;
    tm2+=FP_OFF(xinfo[c].addr);
    tm2+=xinfo[c].size-1;
    if (tm2==tm)
     {
      lastpos-=xinfo[c].size;

      if (c!=xlast-1)
       {
        xinfo[c]=xinfo[xlast-1];
       }
      xlast--;
     }
    else
     szabcnt++;

    return;
   }

 return; // Corrupted / unavail pointer
}

long xmemleft( void )
{
 return totsiz-lastpos;
}

void xmemchk(void)
{
 return;

 char far *xm;
 xm=(char far *)xalloc(100);
 if (!xm)
  {
   xm=NULL;  //rem
  }
 if (xm)
  xfree(xm);
}

