
#include <graph.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
//#include <i86.h>

#include "zigzag.h"
#include "..\mouse\mouse_sv.h"
#include "..\vesa\vesax.h"
#include "..\error\error.h"
#include "..\unrar\unrar.h"
#include "..\mikmod\mikmod.hpp"
#include "..\unrar\urstdio.h"

void tickhandler(void)
{
 MP_HandleTick();    /* play 1 tick of the module */
 MD_SetBPM(mp_bpm);
}

RasterBlock *zloadcell( char *fname);

void main( void )
{
 int c,d;
 int x,y;
 unsigned long s;
 char *bb;
 char buf[20];

 unrar_init();
 UNRAR_MAGIC_NUMBA=0;

 mouse_installed();

 vbe_setup();

 _setvideomode(_VRES256COLOR);
 vbe_setmode(0x101);
 msv_inithandler();
 msv_setanimcursor(0,4);

        md_mixfreq      =44100;                     // standard mixing freq
        md_dmabufsize   =10000;                     // standard dma buf size
        md_mode         =DMODE_16BITS|DMODE_STEREO|DMODE_INTERP;
        md_device       =0;                         // standard device: autodetect

        ML_RegisterLoader(&load_xm);
        ML_RegisterLoader(&load_s3m);
        MD_RegisterDriver(&drv_nos);
        MD_RegisterDriver(&drv_sb);
        MD_RegisterDriver(&drv_gus);
        MD_RegisterPlayer(tickhandler);

        if(!MD_Init())
          errexit(MIKMOD_NODRV);

//        printf("Using %s for %d bit %s %s sound at %u Hz\n\n",
//                        md_driver->Name,
//                        (md_mode&DMODE_16BITS) ? 16:8,
//                        (md_mode&DMODE_INTERP) ? "interpolated":"normal",
//                        (md_mode&DMODE_STEREO) ? "stereo":"mono",
//                        md_mixfreq);

        UNIMOD *mf;

        mf=ML_LoadFN("bright_p.xm");

        if(mf==NULL)
          errexit(MIKMOD_NODRV);

        MP_Init(mf);

//        printf( "Songname: %s\n"
//                        "Modtype : %s\n"
//                        "Periods : %s,%s\n",
//                        mf->songname,
//                        mf->modtype,
//                        (mf->flags&UF_XMPERIODS) ? "XM type" : "mod type",
//                        (mf->flags&UF_LINEAR) ? "Linear" : "Log");

        md_numchn=mf->numchn;

        MD_PlayStart();
//        while (!kbhit())
//        {
//          MD_Update();
//          delay(10);
//        }


 RasterBlock *qq;
 qq=zloadcell("stw95wor.cel");
 vbe_putimage(300,100,qq);
 free(qq);

 char palx[768];
 RasterBlock *cur[10];

 cur[0]=zloadcell("cura4.cel");
 cur[10]=zloadcell("cura3.cel");
 cur[11]=zloadcell("cura2.cel");
 cur[12]=zloadcell("cura1.cel");

 cur[1]=zloadcell("cur2.cel");
 cur[2]=zloadcell("cur3.cel");
 cur[3]=zloadcell("curpr.cel");
 cur[4]=zloadcell("curnx.cel");

 char *buf2;
 unrar_unpack(ZZ_DATFILE,ZZ_DATOFFS,&buf2,"zztest.col");
// convpalette(palx);
 setpalette(buf2);
 free(buf2);

 int c1,c2,c3,c5,cprev,cnext,cp1,cn1;

 msv_setdefaultcursor(cur[0]->data);
 msv_definecursor(cur[10]->data);
 msv_definecursor(cur[11]->data);
 msv_definecursor(cur[12]->data);
 c1=msv_definecursor(cur[1]->data);
 c5=msv_definecursor(cur[2]->data);
 cp1=msv_definecursor(cur[3]->data);
 cn1=msv_definecursor(cur[4]->data);

 c2=setregioncur(100,100,200,200,c1);
 c3=setregioncur(540,380,640,480,c5);
 cnext=setregioncur(540,0,640,200,cn1);
 cprev=setregioncur(0,0,100,200,cp1);

 set_mouse_window(0,0,639,479);

 for (c=479;c>100;c--)
  vbe_putpixel(200,c,c%256);

 m_show();

 while (!kbhit())
  {
   if (left_button_pressed())
    {
//     printf("\r Curr: %d   ",curregion());
     if (curregion()==c3)
      break;
     if (curregion()==cprev)
      {
       MP_PrevPosition();
       MD_Update();
      }
     if (curregion()==cnext)
      {
       MP_NextPosition();
       MD_Update();
      }
     while (left_button_pressed())
      ;
    }
//    MD_Update();
  }
 if (kbhit())
  getch();

 m_hide(); // kell a vegen!
 msv_deinithandler();

 MD_PlayStop();          // stop playing
 ML_Free(mf);            // and free the module
 MD_Exit();


 _setvideomode( 3/*_DEFAULTMODE*/ );
 unrar_shutdown();

}

//--------------------------------------

#include "..\unrar\urstdio_.h"

RasterBlock *zloadcell(char *fname)
{
 char *p;
 int f;
 long fsize;
 unsigned short xs,ys;

 char *buf;
 FILE *g;
 g=fopen(fname,"rb");
 buf=(char *)malloc(g->size+1);
 fread(buf,1,g->size,g);
 fclose(g);

 memcpy(&xs,&buf[2],2);
 memcpy(&ys,&buf[4],2);
// xs--;
// ys--;

 p=(char *)malloc((xs)*(ys)+4);
 memcpy(&p[0],&xs,2);
 memcpy(&p[2],&ys,2);
 memcpy(&p[4],&buf[32+768],(xs)*(ys));
 free(buf);

 return ((RasterBlock *)p);
}

