#include <graph.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <io.h>

#include "..\vesa\vesax.h"

unsigned char *scraddr=(unsigned char *)0xA0000;
unsigned char *LFBaddr;
int linelen;
int lbank=-1;
int vesa_gran=65536; // bytes, nem biztos, hogy mindnel ez!

#define D32RealSeg(P)   ((((DWORD) (P)) >> 4) & 0xFFFF)
#define D32RealOff(P)   (((DWORD) (P)) & 0xF)
typedef unsigned int WORD;
typedef unsigned long DWORD;

void *D32DosMemAlloc (DWORD size)     // kell free is!!!!!!!!
{
    union REGS r;

    r.x.eax = 0x0100;           /* DPMI allocate DOS memory */
    r.x.ebx = (size + 15) >> 4; /* Number of paragraphs requested */
    int386 (0x31, &r, &r);

    if (r.x.cflag)  /* Failed */
            return ((DWORD) 0);
    return (void *) ((r.x.eax & 0xFFFF) << 4);
}

struct DPMIparm
 {
  unsigned edi,esi,ebp,res1,ebx,edx,ecx,eax;
  unsigned short flags,es,ds,fs,gs,ip,cs,sp,ss;
 };

void vbe_setup( void )
{
 char *vbeinfo;

 struct SREGS sregs;
 union REGS inregs, outregs;

 segread(&sregs);

 vbeinfo=(char *)D32DosMemAlloc(256);

 /*
 sregs.es = D32RealSeg(vbeinfo);
 inregs.w.di = D32RealOff(vbeinfo);
 inregs.w.ax=0x4f01; // mode info
 inregs.w.cx=0x108; // | (1<<14) ; // LFBuffer enabled mode
 int386x( 0x10, &inregs, &outregs, &sregs);
 */

 DPMIparm dp, far *dp2;
 memset(&dp,0,sizeof(dp));

 dp.eax=0x4f01; //01;
 dp.ecx=0x101; // | (1<<14);
 dp.edi=D32RealOff(vbeinfo);
 dp.es =D32RealSeg(vbeinfo);

 inregs.w.ax=0x300; // simulate int
 inregs.w.bx=0x10; // int 10
 inregs.w.cx=0;
 inregs.x.edi=FP_OFF(&dp);
 sregs.es=FP_SEG(&dp);
 int386x( 0x31, &inregs, &outregs, &sregs);
 dp2=(DPMIparm far *)MK_FP(sregs.es,outregs.x.edi);

 unsigned *foff=(unsigned*)&vbeinfo[40];
 LFBaddr=(unsigned char *)(*foff);
/*
 short int *a,*b;
 unsigned *foff;
 a=(short int*)&vbeinfo[18];
 b=(short int*)&vbeinfo[20];
 foff=(unsigned*)&vbeinfo[40]; // 39
*/
// printf("Size: x: %d y: %d off: %X\n",*a,*b,*foff);
}

int vbe_setmode( int mod )
{
 union REGS inregs, outregs;

 inregs.w.ax=0x4f02; // set mode
 inregs.w.bx=mod; //mod;
 int386( 0x10, &inregs, &outregs);

 linelen=640; // nem jo igy meg!!!
 lbank=-1;

 return 1;
}

int vbe_setlogiclen( int len )
{
 union REGS inregs, outregs;
 inregs.w.ax=0x4f06;
 inregs.h.bl=0x2;
 inregs.w.cx=len;
 int386( 0x10, &inregs, &outregs);
 linelen=len;

 return 1;
}

void vbe_bankchg( int bnk )
{
 union REGS inregs, outregs;
 /*
 struct SREGS sregs;
 segread(&sregs);

 DPMIparm dp, far *dp2;
 memset(&dp,0,sizeof(dp));

 dp.eax=0x4f05; //01;
 dp.ebx=0x0; // | (1<<14);
 dp.edx=bnk;

 inregs.w.ax=0x300; // simulate int
 inregs.w.bx=0x10; // int 10
 inregs.w.cx=0;
 inregs.x.edi=FP_OFF(&dp);
 sregs.es=FP_SEG(&dp);
 int386x( 0x31, &inregs, &outregs, &sregs);
 */

 inregs.w.ax=0x4f05;
 inregs.w.bx=0x0;
 inregs.w.dx=bnk;
 int386( 0x10, &inregs, &outregs);

 lbank=bnk;
}

int vbe_putpixel( int x, int y, int col )
{
 union REGS inregs, outregs;

 int bn;
 int physa=(y*linelen)+x;

 bn=physa/vesa_gran; // granularity nem biztos, hogy 64k!!!

 if (bn!=lbank)
  vbe_bankchg(bn);

 scraddr[physa%vesa_gran]=col;

 return 0;
}

int vbe_getpixel( int x, int y ) //lehet, hogy csak a WinB hasznalhato readre?
{
 union REGS inregs, outregs;

 int bn;
 int physa=(y*linelen)+x;

 bn=physa/vesa_gran; // granularity nem biztos, hogy 64k!!!

 if (bn!=lbank)
  vbe_bankchg(bn);

 return( scraddr[physa%vesa_gran] );
}

RasterBlock *loadcell(char *fname, char *pal)
{
 char *p;
 int f;
 long fsize;
 unsigned short xs,ys;

 if ((f=open(fname,O_BINARY|O_RDONLY))==-1)
  return NULL;
 //read(f,&fsize,4);
 lseek(f,2,SEEK_CUR);
 read(f,&xs,2);
 read(f,&ys,2);
/* if (dominus)
  {
   xs--;
   ys--;
  }
*/
 lseek(f,32,SEEK_SET);
 if (pal)
  read(f,pal,768);
 else
  lseek(f,768,SEEK_CUR);

 p=(char *)malloc((xs+1)*(ys+1)+4);
 memcpy(&p[0],&xs,2);
 memcpy(&p[2],&ys,2);
 unsigned xx;
 read(f,&p[4],(xs+1)*(ys+1));

 close(f);
 return((RasterBlock *)p);
}


void convpalette( PaletteData *pal )
{
 int c;
 for (c=0;c<256;c++)
  pal[c]/=4;
}

void setpalette( PaletteData *pal )
{
 char *pal2;

 struct SREGS sregs;
 union REGS inregs, outregs;

 segread(&sregs);

 pal2=(char *)D32DosMemAlloc(768);
 memcpy(pal2,pal,768);

 DPMIparm dp, far *dp2;
 memset(&dp,0,sizeof(dp));

 dp.eax=0x1012;
 dp.ebx=0;
 dp.ecx=0xff;
 dp.edx=D32RealOff(pal2);
 dp.es =D32RealSeg(pal2);

 inregs.w.ax=0x300; // simulate int
 inregs.w.bx=0x10; // int 10
 inregs.w.cx=0;
 inregs.x.edi=FP_OFF(&dp);
 sregs.es=FP_SEG(&dp);
 int386x( 0x31, &inregs, &outregs, &sregs);
 dp2=(DPMIparm far *)MK_FP(sregs.es,outregs.x.edi);
}

void vbe_putimage( int x, int y, RasterBlock *kep )
{
 int bn,c,d,tor;
 int physa=(y*linelen)+x;
 int phy2;
 char *p=kep->data;

 bn=physa/vesa_gran; // granularity nem biztos, hogy 64k!!!
 if (bn!=lbank)
  vbe_bankchg(bn);

 phy2=physa & 0xffff;

 for (c=0; c<kep->height ; c++)
  {
   if ((phy2+kep->width) > 0xffff)
    {
     tor=0xffff-phy2;
     memcpy(&scraddr[phy2],p,tor);
     vbe_bankchg(bn+1);
     memcpy(&scraddr[0],&p[tor],kep->width-tor);
    }
   else
    memcpy(&scraddr[phy2],p,kep->width+1);

   phy2+=linelen;
   p+=kep->width;
   if (phy2>0xffff)
    vbe_bankchg(++bn);
   phy2&=0xffff;
  }
}

//----------------------------------------get/putimage

void putimage( int x1, int y1, RasterBlock *i )
{
 char *p=i->data;
 char *s=scraddr;
 register int

 int bn;
 int physa=(y*linelen)+x;

 bn=physa/vesa_gran; // granularity nem biztos, hogy 64k!!!

 if (bn!=lbank)
  vbe_bankchg(bn);

 scraddr[physa%vesa_gran]=col;

 
}

void putimageo( int x1, int y1, RasterBlock *i ) // color 255=transparent
{
}

int imagesize( int x1, int y1, int x2, int y2 );
{
}

RasterBlock *imagealloc( int x1, int y1, int x2, int y2 );
{
}

