/******    *****   ******
 **   **  **   **  **   **      unRAR utility version 1.01
 ******   *******  ******       ~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **   **  **   **  **   **         FREE portable version
 **   **  **   **  **   **         ~~~~~~~~~~~~~~~~~~~~~

         Main code

   YOU CAN CHANGE FOLLOWING CODE IN ORDER TO ACHIEVE
   COMPATIBILITY WITH YOUR OPERATING MEDIA.

   PLEASE SEND ALL NOTES, PATCHES TO andrey@vybor.chel.su
   OR TO Andrey Spasibozhko, 2:5010/23@fidonet.
   VOICE PHONE: +7-3512-130-231
*/

#include "unrar.inc"          /* definitions */
#include "unpack.c"         /* unpacking procedures */
//We use our own errexit function
#include "..\error\error.h"   //errexit() instesd of ErrExit()

char UNRAR_MAGIC_NUMBA = 0;

int    CmpName();           /* checks name for mask */
char*  PointToName();       /* returns pathname */
void   SplitName();         /* splits pathname */
int    ExtrFile();          /* extracts single file */
void   ShutDown();          /* stops working */
int    tread();             /* reads with checking */
void   tclose();            /* closes with checking */
void   UnstoreFile();       /* unpacks non-compressed file */
int    IsArchive();         /* checks for RAR archive signature */
void   CheckArc();          /* similar but with exit */
int    strnicomp();         /* compares strings */
char*  strtolwr();          /* convert string to lowercase
int    ReadBlock();         /* reads archive block */
int    IsProcessFile();     /* should file be processed */
int    UnpRead();           /* reading while unpacking */
int    UnpWrite();          /* writing while unpacking */
void   InitCRC();           /* initializes CRC table */
UDWORD CRC();               /* calculates CRC */

void   fxseek();            // seeks using archive file offset
long   fxtell();            //returns patched dile ptr
size_t fxread();            //reads and decodes
                            //xor



void unrar_init();
void unrar_shutdown();
UDWORD unrar_unpack();

struct MarkHeader MarkHead;
struct ArchiveHeader Mhd;
struct FileHeader Lhd;

UDWORD CRC32_Table[256],UnpFileCRC;
HPBYTE TmpMemory;

int ArgCount=0;
char ArgNames[16][80],MainCommand;
char CurExtrFile[80]={0},ArcName[80],ArcFileName[80],ExtrPath[80];
//New variables
UDWORD ArcPos;
char **membufptr;
char *actmembuf;
UDWORD membufsize;
//
int SolidType,UnpVolume,TestMode,ExitCode=0;
FILE *ArcFPtr=NULL,*FileFPtr=NULL,*RdUnpFPtr,*WrUnpFPtr;
long NextBlockPos,UnpPackedSize;
int InitDone=0;
int atexit_hooked=0;

//Added by InfraRED/VSC
void unrar_init()
{
  if ((TmpMemory=(HPBYTE)MEMALLOC(UNP_MEMORY))==NULL)
    errexit(UNRAR_NOMEM);
  MakeTbl();
  InitDone=1;
  if (!atexit_hooked)
  {
    atexit(ShutDown);
    atexit_hooked=1;
  }
}

void unrar_shutdown()
{
  ShutDown();
  InitDone=0;
}

void fxseek(fptr,offset,where)
FILE *fptr;
long int offset;
int where;
{
  if (where==SEEK_SET)
    if (fseek(fptr,ArcPos+offset,SEEK_SET))
      errexit(UNRAR_EXTR_CANTSEEK);
  else
    if (fseek(fptr,offset,where))
      errexit(UNRAR_EXTR_CANTSEEK);
}

long fxtell(fptr)
FILE *fptr;
{
  return (ftell(fptr)-ArcPos);
}

size_t fxread(buf,elsize,nelem,fp)   //This procedure reads as fread, but
void *buf;                           //decodes buf  (xor 0xcf)
size_t elsize;
size_t nelem;
FILE *fp;
{
  int c;
  int ret=fread(buf,elsize,nelem,fp);
  for (c=0; c<ret*elsize; c++)
    ((char*)buf)[c]^=UNRAR_MAGIC_NUMBA;
  return ret;
}




UDWORD unrar_unpack(rarf_name,rarf_ptr,mem_buffer,compf_name)
char *rarf_name;
long rarf_ptr;
char **mem_buffer;
char *compf_name;
{
  if (!InitDone)
    unrar_init();
  strcpy(ArcName,rarf_name);
  ArcPos=rarf_ptr;
  membufptr=mem_buffer;
  ArgCount=1;
  strcpy(ArgNames[0],compf_name);
  ExtrFile();



  return(membufsize);
}





//End of newly added functions
int CmpName(Mask,Name)
char *Mask;
char *Name;
{
  while (1)
  {
    if (*Mask=='*')
    {
      while (*Mask!='.' && *Mask!=0)
        Mask++;
      while (*Name!='.' && *Name!=0)
        Name++;
    }
    if (*Mask==0)
      return(*Name==0);
    if (*Name==0 && *Mask=='.')
    {
      Mask++;
      continue;
    }
    if (toupper(*Mask)==toupper(*Name) || *Mask=='?' && *Name!=0)
    {
      Mask++;
      Name++;
    }
    else
      return(0);
  }
}

void UnstoreFile()
{
  int Code;
  while ( 1 )
  {
    if ((Code=UnpRead((UBYTE *)TmpMemory,0x7f00))==-1)
      errexit(UNRAR_EXTR_CANTREAD);
    //if (Code==0)
    //  break;
    //if (UnpWrite((UBYTE *)TmpMemory,(UWORD)Code)==-1)
    //  ErrExit(EWRITE,WRITE_ERROR);
    memcpy(*membufptr, TmpMemory, Code);
  }
}


int IsArchive()
{
  UBYTE Mark[7],Header[13];
  SolidType=0;
  if (tread(ArcFPtr,Mark,7)!=7)
    return(0);
  if (Mark[0]!=0x52 || Mark[1]!=0x61 || Mark[2]!=0x72 || Mark[3]!=0x21 ||
      Mark[4]!=0x1a || Mark[5]!=0x07 || Mark[6]!=0x00)
    return(0);
  if (tread(ArcFPtr,Header,13) != 13)
    return(0);
  Mhd.HeadCRC  = Header[0]+(UWORD)Header[1]*0x100;
  Mhd.HeadType = Header[2];
  Mhd.Flags    = Header[3]+(UWORD)Header[4]*0x100;
  Mhd.HeadSize = Header[5]+(UWORD)Header[6]*0x100;
  if (!(Mhd.HeadCRC==(UWORD)~CRC(0xFFFFFFFFL,&Header[2],11)))
    printf("\n Archive header broken");
  SolidType=(Mhd.Flags & MHD_SOLID);
  fseek(ArcFPtr,Mhd.HeadSize-13,SEEK_CUR);
  return(1);
}


void CheckArc()
{
  if (!IsArchive())
  {
    //printf("\nBad archive %s",ArcName);
    errexit(UNRAR_EXTR_NOTARCH);
  }
}


int tread(FPtr,buf,len)
FILE *FPtr;
void *buf;
unsigned len;
{
  int Code;
//Code=fread(buf,1,len,FPtr);
  Code=fxread(buf,1,len,FPtr);
  if (Code==-1)
    errexit(UNRAR_EXTR_NOTARCH);
  return(Code);
}


void tclose(FPtr)
FILE *FPtr;
{
  if (fclose(FPtr)==EOF)
    errexit(UNRAR_EXTR_CANTCLOSE);
}


char* PointToName(Path)
char *Path;
{
  char *ChPtr;
  if ((ChPtr=strrchr(Path,PATHDIV))!=NULL)
    return(ChPtr+1);
  else
    if ((ChPtr=strrchr(Path,':'))!=NULL)
      return(ChPtr+1);
    else
      return(Path);
}


int strnicomp(Str1,Str2,MaxLen)
char *Str1;
char *Str2;
int MaxLen;
{
  if (MaxLen==0)
    return(0);
  while (MaxLen-- > 0)
  {
    if (toupper(*Str1)!=toupper(*Str2))
      return(1);
    if (*Str1==0)
      return(0);
    Str1++;
    Str2++;
  }
  return(0);
}


char* strtolwr(Str)
char *Str;
{
  char *ChPtr;
  for (ChPtr=Str;*ChPtr!=0;ChPtr++)
    *ChPtr=tolower(*ChPtr);
  return(Str);
}


void SplitName(Path,Dir,Name)
char *Path;
char *Dir;
char *Name;
{
  char *ChPtr,*ChPtr1;
  if ((ChPtr=strrchr(Path,':'))!=NULL)
    ChPtr++;
  else
    ChPtr=Path;
  if ((ChPtr1=strrchr(ChPtr,PATHDIV))!=NULL)
  {
    *ChPtr1=0;
    strcpy(Dir,ChPtr);
    *ChPtr1=PATHDIV;
    ChPtr=ChPtr1+1;
  }
  else
    *Dir=0;
  strcpy(Name,ChPtr);
}

void ShutDown()   //No file writes, so no need for file shutdown
{
//  if (TmpMemory!=NULL)  //I think, there's no need for checking, 'cause
                          //free does nothing if ptr==NULL
  MEMFREE(TmpMemory);
}

int ExtrFile()
{
  char DestFileName[80];
  long FileCount=0,TotalFileCount=0,DirCount=0,ErrCount=0;
  int ExtrFile=0,Size,SkipSolid=0,UnpSolid;

  if ((ArcFPtr=fopen(ArcName,FOPENREADMODE))==NULL)
    errexit(UNRAR_EXTR_CANTOPEN);
  else
    if (fseek(ArcFPtr,ArcPos,SEEK_SET)!=0)
      errexit(UNRAR_EXTR_CANTSEEK);
  CheckArc();
  CreateEncTbl(TmpMemory);
  UnpSolid=0;

  while (1)
  {
    Size=ReadBlock(FILE_HEAD);

    if (Size<=0)
      break;
  //  if (UnpVolume && Size==0)
  //    MergeArc(0);
    UnpVolume=(Lhd.Flags & LHD_SPLIT_AFTER);
    fxseek(ArcFPtr,NextBlockPos-Lhd.PackSize,SEEK_SET);

    TestMode=0;
    ExtrFile=0;
    SkipSolid=0;

    //if (IsProcessFile(COMPARE_PATH) && (Lhd.Flags & LHD_SPLIT_BEFORE)==0
    //    || (SkipSolid=SolidType)!=0)
    if (IsProcessFile(NOT_COMPARE_PATH))
    {
      FileCount++;
      //strcpy(DestFileName,ExtrPath);
      //strcat(DestFileName,(MainCommand!='E') ? ArcFileName : PointToName(ArcFileName));
      //ExtrFile=!SkipSolid;

      if (Lhd.UnpVer<15 || Lhd.UnpVer>UNP_VER)
      {
        errexit(UNRAR_EXTR_CANTUNP);
      //  printf("\n %s: unknown method",ArcFileName);
      //  ExtrFile=0;
      //  ErrCount++;
      //  ExitCode=WARNING;
      }

      if (Lhd.Flags & LHD_PASSWORD)
      {
        errexit(UNRAR_EXTR_CANTUNP);
        //printf("\n %s: cannot process encrypted file",ArcFileName);
        //if (SolidType)
        //  ErrExit(EEMPTY,FATAL_ERROR);
        //ExtrFile=0;
        //ErrCount++;
        //ExitCode=WARNING;
      }

      //if (Lhd.HostOS==MS_DOS && (Lhd.FileAttr & DOSFA_DIREC))
      //{
      //  if (MainCommand=='E')
      //    continue;
      //  if (SkipSolid)
      //  {
      //    printf("\n Skipping    %-55s Ok",ArcFileName);
      //    continue;
      //  }
      //  if (MainCommand=='T')
      //  {
      //    printf("\n Testing     %-55s Ok",ArcFileName);
      //    continue;
      //  }
      //  CreatePath(DestFileName);
      //  if (MAKEDIR(DestFileName)==0)
      //    printf("\n Creating    %-55s",ArcFileName);
      //  continue;
      //}
      //else
      //{
      //  if (MainCommand=='T' && ExtrFile)
      //    TestMode=1;
      //  if ((MainCommand=='E' || MainCommand=='X') && ExtrFile)
      //  {
      //    CreatePath(DestFileName);
      //    if ((FileFPtr=fopen(DestFileName,FOPENWRITEMODE))==NULL)
      //    {
      //      printf("\n Cannot create %s",DestFileName);
      //      ExitCode=WARNING;
      //      ExtrFile=0;
      //    }
      //  }
      //}

//    if (!ExtrFile && SolidType)
//      SkipSolid=TestMode=ExtrFile=1;
//    if (ExtrFile)
//    {
//      TotalFileCount++;
//      if (SkipSolid)
//        printf("\n Skipping    %-55s",ArcFileName);
//      else
//      {
//        FileCount++;
//        switch(MainCommand)
//        {
//          case 'T':
//            printf("\n Testing     %-55s",ArcFileName);
//            break;
//          case 'X':
//          case 'E':
//            printf("\n Extracting  %-55s",DestFileName);
//            break;
//        }
//      }
//        strcpy(CurExtrFile,DestFileName);
        UnpFileCRC=0xFFFFFFFFL;
        UnpPackedSize=Lhd.PackSize;
        DestUnpSize=Lhd.UnpSize;
// New code added by InfraRED/VSC
        *membufptr=(char*)malloc(DestUnpSize);
        actmembuf=*membufptr;
        membufsize=DestUnpSize;
//End new code
        RdUnpFPtr=ArcFPtr;
        //WrUnpFPtr=FileFPtr;
        if (Lhd.Method==0x30)
          UnstoreFile();
        else
          if (unpack(TmpMemory,UnpRead,UnpWrite,UnpSolid)==-1)
            errexit(UNRAR_EXTR_CANTUNP);
        if (TotalFileCount>0 && SolidType)
          UnpSolid=1;
//      if (UnpFileCRC==~Lhd.FileCRC)
        if (UnpFileCRC!=~Lhd.FileCRC)
//      {
//        if (MainCommand!='P')
//          printf(" Ok");
//      }
//      else
//      {
//        fseek(ArcFPtr,NextBlockPos,SEEK_SET);
//        printf("\n %-15s : CRC failed",ArcFileName);
          errexit(UNRAR_EXTR_CRCERR);
//        ErrCount++;
//      }
//      if (!TestMode)
//      {
//        SETFILETIME(FileFPtr,(void *)&Lhd.FileTime);
//        tclose(FileFPtr);
//      }
        TestMode=0;
        *CurExtrFile=0;
//      }
    }
//  if (!ExtrFile && !SolidType)
    if (!(ExtrFile))
     {
      fxseek(ArcFPtr,NextBlockPos,SEEK_SET);
     }
//    fseek(ArcFPtr,NextBlockPos,SEEK_SET);
  }
  tclose(ArcFPtr);
  if ((FileCount)==0)
    errexit(UNRAR_EXTR_NODATA);

//{
//  printf("\n No files");
//  ExitCode=WARNING;
//}
//else
//  if (ErrCount==0)
//    printf("\n  All OK");
//  else
//    printf("\n  Total errors: %ld",ErrCount);
  return(0);
}

int IsProcessFile(ComparePath)
int ComparePath;
{
  int NumName,WildCards;
  char ArgName[80],dir1[80],name1[15],dir2[80],name2[15];
  for (NumName=0;NumName<ArgCount;NumName++)
  {
    memcpy((void *)ArgName,(void *)ArgNames[NumName],sizeof(ArgName));
    WildCards=(strchr(ArgName,'?')!=NULL || strchr(ArgName,'*')!=NULL);
    SplitName(ArgName,dir1,name1);
    SplitName(ArcFileName,dir2,name2);
    if (CmpName(name1,name2) && ((ComparePath==NOT_COMPARE_PATH && *dir1==0) ||
          WildCards && strnicomp(dir1,dir2,strlen(dir1))==0 ||
          strnicomp(dir1,dir2,1000)==0))
      return(1);
  }
  return(0);
}

int ReadBlock(BlockType)
int BlockType;
{
  UDWORD HeadCRC;
  UBYTE Header[32];
  int Size,I;
  memset(&Lhd,0,sizeof(Lhd));
  memset(Header,0,sizeof(Header));
  while (1)
  {
    Size=tread(ArcFPtr,Header,32);
    Lhd.HeadCRC  = Header[0] +(UWORD)Header[1]*0x100;
    Lhd.HeadType = Header[2];
    Lhd.Flags    = Header[3] +(UWORD)Header[4]*0x100;
    Lhd.HeadSize = Header[5] +(UWORD)Header[6]*0x100;;
    Lhd.PackSize = Header[7] +(UWORD)Header[8]*0x100+(UDWORD)Header[9]*0x10000L+(UDWORD)Header[10]*0x1000000L;
    Lhd.UnpSize  = Header[11]+(UWORD)Header[12]*0x100+(UDWORD)Header[13]*0x10000L+(UDWORD)Header[14]*0x1000000L;
    Lhd.HostOS   = Header[15];
    Lhd.FileCRC  = Header[16]+(UWORD)Header[17]*0x100+(UDWORD)Header[18]*0x10000L+(UDWORD)Header[19]*0x1000000L;
    Lhd.FileTime = Header[20]+(UWORD)Header[21]*0x100+(UDWORD)Header[22]*0x10000L+(UDWORD)Header[23]*0x1000000L;
    Lhd.UnpVer   = Header[24];
    Lhd.Method   = Header[25];
    Lhd.NameSize = Header[26]+(UWORD)Header[27]*0x100;
    Lhd.FileAttr = Header[28]+(UWORD)Header[29]*0x100+(UDWORD)Header[30]*0x10000L+(UDWORD)Header[31]*0x1000000L;
    if (Size != 0 && (Size<7 || Lhd.HeadSize<7))
      errexit(UNRAR_EXTR_NOTARCH);
    NextBlockPos=fxtell(ArcFPtr)-Size+Lhd.HeadSize;
    if (Lhd.Flags & LONG_BLOCK)
//      NextBlockPos+=Lhd.PackSize;
      NextBlockPos+=Lhd.PackSize+ArcPos;
    if (Size==0 || BlockType==ALL_HEAD || Lhd.HeadType==BlockType)
      break;
    fxseek(ArcFPtr,NextBlockPos,SEEK_SET);
  }
  if (Size>0 && BlockType==FILE_HEAD)
  {
    tread(ArcFPtr,ArcFileName,Lhd.NameSize);
    ArcFileName[Lhd.NameSize]=0;
    Size+=Lhd.NameSize;
    HeadCRC=CRC(0xFFFFFFFFL,&Header[2],30);
    if (!(Lhd.HeadCRC==(UWORD)~CRC(HeadCRC,&ArcFileName[0],Lhd.NameSize)))
      //printf("\n %s: file header broken\n",ArcFileName);
      errexit(UNRAR_EXTR_NOTARCH);
  //  for (I=0;ArcFileName[I];I++)
  //    if (ArcFileName[I]=='\\' || ArcFileName[I]=='/')
  //      ArcFileName[I]=PATHDIV;
  //  if (Lhd.HostOS==MS_DOS)
  //    strtolwr(ArcFileName);
  }
  return(Size);
}


int UnpRead(Addr,Count)
UBYTE *Addr;
UWORD Count;
{
  int RetCode;
  unsigned int ReadSize,TotalRead=0;
  UBYTE *ReadAddr;
  ReadAddr=Addr;
  while (Count > 0)
  {
    ReadSize=(unsigned int)((Count>UnpPackedSize) ? UnpPackedSize : Count);
    if ((RetCode=fxread(ReadAddr,1,ReadSize,RdUnpFPtr))!=ReadSize)
    {
      break;
    }
    TotalRead+=RetCode;
    ReadAddr+=RetCode;
    Count-=RetCode;
    UnpPackedSize-=RetCode;
//  if (UnpPackedSize == 0 && UnpVolume)
//    MergeArc(1);
//  else
      break;
  }
  if (RetCode!=-1)
    RetCode=(int)TotalRead;
  return(RetCode);
}


int UnpWrite(Addr,Count)
UBYTE *Addr;
UWORD Count;
{
  int RetCode;
//if (TestMode)
//  RetCode=(int)Count;
//else
   // if ((RetCode=fwrite(Addr,1,Count,WrUnpFPtr))!=Count)
   //   RetCode = -1;
    memcpy(actmembuf,Addr,Count);
    actmembuf+=Count;
  UnpFileCRC=CRC(UnpFileCRC,Addr,Count);
  return(Count);
}


UDWORD CRC(StartCRC,Addr,Size)
UDWORD StartCRC;
UBYTE *Addr;
UWORD Size;
{
  UWORD I;
  if (!CRC32_Table[1])
    InitCRC();
  for (I=0;I<Size;I++)
    StartCRC = CRC32_Table[(UBYTE)StartCRC ^ Addr[I]] ^ (StartCRC >> 8);
  return(StartCRC);
}

void InitCRC()
{
  int I, J;
  UDWORD C;
  for (I=0;I<256;I++)
  {
    for (C=I,J=0;J<8;J++)
      C=(C & 1) ? (C>>1)^0xEDB88320L : (C>>1);
    CRC32_Table[I]=C;
  }
}
