/****************************************************************/
/*                                                              */
/*           Digitized Voice Programmer's Toolkit               */
/*           ------------------------------------               */
/*                                                              */
/*        Example of a program which plays voice data           */
/*             from a file of unlimited length                  */
/*                                                              */
/*          Copyright (c) 1989, Farpoint Software               */
/*                                                              */
/*                                                              */
/*  This program simply plays a voice message while displaying  */
/*  a message repeatedly indicating the count of bytes played.  */
/*  The digitized voice data is read from a disk file piece by  */
/*  piece while the playback is in progress. The memory buffer  */
/*  used is much smaller than the potential file size. Data is  */
/*  read from the buffer with the pointer wrapping back to the  */
/*  beginning of the buffer upon reaching the end. The routine  */
/*  PVOICE_CATCHUP (source in VPMOD.ASM) transfers data from    */
/*  the file to the buffer in the same way.                     */
/*                                                              */
/****************************************************************/

#include "vpmod.h"

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <io.h>
#include <types.h>
#include <stat.h>
#include <bios.h>
#include <string.h>

#include <conio.h>

#define buf_size  32000L


char filename[128];
char huge *buffer;
int handle;

main(argc,argv)
int argc;
char **argv;

{
 short retval;
 long count,index;

 /* check for one argument on command line */

 strcpy(filename,"LONGTEST.VOI");

 /* open the file */

 handle = open(filename,O_BINARY|O_RDONLY);
 if (handle == -1)
	{
	printf("Error opening file.\n");
	exit(1);
	}

 /* allocate memory for the buffer */

 buffer = (char huge *)halloc(buf_size,1);
 if (buffer == NULL)
	{
	close(handle);
	printf("Unable to allocate buffer memory.\n");
	exit(1);
	}

 /* get ready */

 PVOICE_INIT();

 /* start the playback */

 retval = PVOICE_START(buffer,(long)buf_size,1,handle,filelength(handle),0L);

 /* test return code for success or failure */

 switch (retval)
	{
	case 0:
		printf("Voice playback has begun.\n");
		break;
	case 1:
	case 2:
		printf("Buffer sizing error.\n");
		break;
	case 3:
		printf("File read error.\n");
	}

 if (!retval)
	{

	/* loop while waiting for the process to complete */

	while (PVOICE_STATUS(&count,&index))
		{

		/* If PVOICE_CATCHUP returns non-zero then file read error. */
		/* PVOICE_CATCHUP has to be called frequently during playback */
		/*  in order to keep reading the file and keep the data in    */
		/*  the buffer current.                                       */

		if (PVOICE_CATCHUP())
			{
			printf("File read error.\n");
			break;
			}
		else

			/* just something to do in the foreground */

			printf("Number of bytes played = %ld\n",count);

		/* check the keystroke buffer */

		if ( kbhit != 0 )
			{

			/* keystroke found, test for <Esc> key */

			if ( getch == 27 )
				{
				PVOICE_STOP();
				printf("Voice playback stopped with <Esc>\n");
				break;
				}
			}
		}
	}

 /* do this before exiting or suffer the consequences */

 printf("Calling CLEANUP ...");
 PVOICE_CLEANUP();
 printf("...returned,closing file...");

 /* close the file and free the allocated memory */

 close(handle);
 printf("... closed,freeing memory...");
 free(buffer);
 printf("Exiting");
 return(0);
}
