#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

/* function prototypes */
int huge detectVGA256(void);
void checkerrors(void);

#define bnrbsid 0.8660254
void NOSABanner( int px , int py , int xk , int  yk  );

int main(void)
{
   int gdriver, gmode;

   /* install a user written device driver */
   gdriver = installuserdriver("VGA256", detectVGA256);

   /* must force use of detection routine */
   gdriver = DETECT;

   /* check for any installation errors */
   checkerrors();

   /* initialize graphics and local variables */
   initgraph(&gdriver, &gmode, "");

   /* check for any initialization errors */
   checkerrors();

   struct palettetype pal;
   int c,d;

   /* grab a copy of the palette */
   // getpalette(&pal);

   /* create gray scale */
   /****
    for (i=0; i<=256; i++)
      setrgbpalette(i, i, i, i);
   ****/

   /**
   putpixel( 256+1,1,63 );

   for ( d=1 ; d<=4 ; d++ )
    for (c=0 ; c<=63 ; c++ )
     {
      if (d != 4)
       setrgbpalette((d-1)*64 + c, (d==1)?c:0 ,(d==2)?c:0 , (d==3)?c:0 );
      else
       setrgbpalette((d-1)*64 + c, c , c , c );
      putpixel( (d-1)*64 + c+1,1,63 );
     }
   **/

   NOSABanner( 160,100 , 36,29 );

   getch();
   closegraph();
   return 0;
}

/* detects VGA cards */
int huge detectVGA256(void)
{
   int driver, mode, sugmode = 0;

   detectgraph(&driver, &mode);
   if (driver == VGA)
      /* return suggested video mode number */
      return sugmode;
   else
      /* return an error code */
      return grError;
}

/* check for and report any graphics errors */
void checkerrors(void)
{
   int errorcode;

   /* read result of last graphics operation */
   errorcode = graphresult();
   if (errorcode != grOk)
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to halt:");
      getch();
      exit(1);
   }
}


void NOSABanner( int px , int py , int xk , int  yk  )
{
 struct pointtype banr[18];
 int c;

 banr[1].x=0;
 banr[1].y=yk * (-2*bnrbsid);

 banr[2].x=xk * (-1.5);
 banr[2].y=yk * (-bnrbsid);

 banr[3].x=xk * (-0.5);
 banr[3].y=yk * (-bnrbsid);

 banr[4].x=xk * (0.5);
 banr[4].y=yk * (-bnrbsid);

 banr[5].x=xk * (1.5);
 banr[5].y=yk * (-bnrbsid);

 banr[6].x=xk * (-1);
 banr[6].y=0;

 banr[7].x=0;
 banr[7].y=0;

 banr[8].x=xk * (1);
 banr[8].y=0;

 banr[9].x=xk * (-1.5);
 banr[9].y=yk * bnrbsid;

 banr[10].x=xk * (-0.5);
 banr[10].y=yk * bnrbsid;

 banr[11].x=xk * (0.5);
 banr[11].y=yk * bnrbsid;

 banr[12].x=xk * (1.5);
 banr[12].y=yk * bnrbsid;

 banr[13].x=0;
 banr[13].y=yk * (2*bnrbsid);

 banr[14].x=0;
 banr[14].y=yk * (-2*bnrbsid-1);

 banr[15].x=xk * (-2.5);
 banr[15].y=0;

 banr[16].x=xk * (2.5);
 banr[16].y=0;

 banr[17].x=0;
 banr[17].y=yk * (2*bnrbsid+1);

 for ( c=1 ; c<=17 ; c++ )
  {
   banr[c].x += px;
   banr[c].y += py;
  }

 /* * */

 struct pointtype pts[6];

 setfillstyle( 1 , BLUE );

 pts[0]=banr[14];    // border square
 pts[1]=banr[15];
 pts[2]=banr[17];
 pts[3]=banr[16];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );


 /*     /\
   ____/1 \____
   \ 6 \  /2  /
    \___\/___/
    /5  /\ 3 \
   /___/4 \___\
       \  /
	\/


 */

 setfillstyle( 1 , RED );

 pts[0]=banr[1];   // 1.
 pts[1]=banr[4];
 pts[2]=banr[7];
 pts[3]=banr[3];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );

 pts[0]=banr[7];   // 3.
 pts[1]=banr[8];
 pts[2]=banr[12];
 pts[3]=banr[11];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );

 pts[0]=banr[7];   // 5.
 pts[1]=banr[10];
 pts[2]=banr[9];
 pts[3]=banr[6];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );

 setfillstyle( 1 , GREEN );

 pts[0]=banr[7];   // 2.
 pts[1]=banr[4];
 pts[2]=banr[5];
 pts[3]=banr[8];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );

 pts[0]=banr[7];   // 4.
 pts[1]=banr[11];
 pts[2]=banr[13];
 pts[3]=banr[10];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );

 pts[0]=banr[7];   // 6.
 pts[1]=banr[6];
 pts[2]=banr[2];
 pts[3]=banr[3];
 pts[4]=pts[0];
 fillpoly(5 , (int*)pts );
}

