#include <io.h>
#include <stdio.h>
#include <conio.h>
#include <fcntl.h>
#include <process.h>
#include <sys/stat.h>
#include <string.h>
#include <alloc.h>

void hiba(char *st);
void readdata( void );

struct {
	 unsigned int OFFSET;
	 unsigned int SEGMENT;
       }relocitem,jmpitem;

class Cheader {
 public:
  struct {
    char signature[2];		// +00h
    unsigned int PartPag;	// +02h
    unsigned int PageCnt;       // +04h
    unsigned int ReloCnt;       // +06h
    unsigned int HdrSize;       // +08h
    unsigned int MinMem;        // +0Ah
    unsigned int MaxMem;        // +0Ch
    unsigned int ReloSS;        // +0Eh
    unsigned int ExeSP;         // +10h
    unsigned int ChkSum;        // +12h
    unsigned int ExeIP;         // +14h
    unsigned int ReloCS;        // +16h
    unsigned int TablOff;       // +18h
    unsigned int Overlay;       // +1Ah
  }data;

  void read( int handle );
  void write( int handle );

 };

Cheader header;

int fh,fh2;
char kar;
unsigned int oldstartsegment;
unsigned int oldstartoffset;
unsigned int relocnt;		// NUMBER OF RELOCATION ITEMS
unsigned int hdrsize;		// SIZE OF HEADER (in 16 bytes)
unsigned int firstitem;		// FILE OFFSET OF 1ST RELOC. ITEM

void main( int argc, char *argv[])
{
 char *wstr;
 char *bakfile;
 unsigned int mysegment;
 unsigned int count;
 if (argc<1) hiba("Not enough parameters!\r\n");
 if ( (fh=open(argv[1],O_BINARY | O_RDWR))==-1) hiba("File not found!\r\n");
 header.read(fh);


//-------------------------------------------------
//                     BACKUP
//-------------------------------------------------

 char *data;
/*
 printf("Creating backup file...               ");
 bakfile=argv[1];
 bakfile[strlen(bakfile)-1]='~';
 fh2=open(bakfile,O_BINARY | O_RDWR | O_CREAT | S_IREAD | S_IWRITE);
 lseek(fh,0,SEEK_SET);
 if ( (data=(char *)malloc(filelength(fh)+2))==NULL)
  {
   data=(char *)malloc(16);
   while(!eof(fh))
    {
     read(fh,&kar,16);
     write(fh2,&kar,16);
    }
  }
 else
  {
   read(fh,data,filelength(fh));
   write(fh2,data,filelength(fh));
  }
 free(data);
 close(fh2);
*/
//-------------------------------------------------
//                RESERVING PLACE
//------------------------------------------------------

 printf("Reserving place for new relocations...");
 header.data.PartPag=0;

 lseek(fh,filelength(fh),SEEK_SET);	// FILL WITH 0 to NEW SEGMENT
 wstr=0x00;
 while((filelength(fh)%16)!=0)
 {
  write(fh,wstr,1);
 }
 long c;
 data=(char *)malloc(17);
 for(c=filelength(fh)-16; c>=header.data.HdrSize*16; c-=16)
  {
   lseek(fh,c,SEEK_SET);
   read(fh,data,16);
   write(fh,data,16);
  }
 free(data);
 lseek(fh,header.data.HdrSize*16,SEEK_SET);
 for(c=1; c<=16; c++)
  write(fh,wstr,1);
 header.data.HdrSize++;
 header.write(fh);
//-------------------------------------------------
//            FAR CALL FOR INTRO
//-------------------------------------------------
 printf("Done.\n\rInserting CALL for intro...           ");
 oldstartsegment=header.data.ReloCS;
 oldstartoffset=header.data.ExeIP;
 mysegment=filelength(fh)/16-header.data.HdrSize;
 header.data.ReloCS=mysegment;
 header.data.ExeIP=0;
 header.write(fh);

 //printf("%d",mysegment);
 lseek(fh,filelength(fh),SEEK_SET);		// WRITE NOP-s
 //wstr="";
 wstr=(char *)malloc(50);
 wstr="";

 wstr[ 3]=0x50;		// PUSH AX
 wstr[ 4]=0x1E;		// PUSH DS
 wstr[ 5]=0xB8;		// MOV AX,
 wstr[ 6]=(mysegment+3) % 256;
 wstr[ 7]=( (mysegment+3)-((mysegment+3) % 256) ) >> 8;
 wstr[ 8]=0x8E;		// MOV DS,AX
 wstr[ 9]=0xD8;
 wstr[10]=0x90;		// NOP

 wstr[11]=0xE8;		// JMP NEAR
 wstr[12]=0x22;         // TO INTRO
 wstr[13]=0x00;
 wstr[14]=0x1F;		// POP DS
 wstr[15]=0x58;		// POP AX
 wstr[16]=0xB9;		// MOV CX,
 wstr[17]=oldstartsegment % 256;
 wstr[18]=(oldstartsegment-(oldstartsegment % 256)) >> 8;
 wstr[19]=0xBA;		// MOV DX,
 wstr[20]=oldstartoffset % 256;
 wstr[21]=(oldstartoffset-(oldstartoffset % 256)) >> 8;

 wstr[22]=0x90;

 wstr[23]=0xBB;		// MOV BX,
 wstr[24]=header.data.ReloSS % 256;
 wstr[25]=(header.data.ReloSS-(header.data.ReloSS % 256)) >> 8;
 wstr[26]=0x8E;		// MOV SS,BX
 wstr[27]=0xD3;
 wstr[28]=0xBB;	       	// MOV BX,
 wstr[29]=0x00;
 wstr[30]=0x00;


 wstr[31]=0x51;		// PUSH CX
 wstr[32]=0x52;		// PUSH DX
 wstr[33]=0xB9;		// MOV CX,
 wstr[34]=0x00;
 wstr[35]=0x00;
 wstr[36]=0xBA;		// MOV DX,
 wstr[37]=0x00;
 wstr[38]=0x00;
 wstr[39]=0xCB;		// RETF
 write(fh,wstr,48);

 free(wstr);


/****************************************
 count=0;
 while(count<relocnt)
 {
  lseek(fh,firstitem+count*4,SEEK_SET);
  read(fh,&relocitem,4);
  relocitem.SEGMENT++;
  lseek(fh,firstitem+count*4,SEEK_SET);
  write(fh,&relocitem,4);

  lseek(fh,hdrsize*16+relocitem.SEGMENT*16+relocitem.OFFSET-2,SEEK_SET);
  read(fh,&jmpitem,4);
  jmpitem.SEGMENT++;
  lseek(fh,hdrsize*16+relocitem.SEGMENT*16+relocitem.OFFSET-2,SEEK_SET);
  write(fh,&jmpitem,4);

  count++;
 }
****************************************/
//-------------------------------------------------
//              RELOCATION TABLE
//-------------------------------------------------
 printf("Done.\n\r( Intro segment is:%6d)\n\rModifying relocation table...         ",mysegment);
 lseek(fh,header.data.TablOff+(4*header.data.ReloCnt),SEEK_SET);
 wstr[0]=0x11;
 wstr[1]=0x00;
 wstr[2]=mysegment % 256;
 wstr[3]=(mysegment-(mysegment % 256)) >> 8;
 write(fh,wstr,4);

 wstr[0]=0x06;
 wstr[1]=0x00;
 wstr[2]=mysegment % 256;
 wstr[3]=(mysegment-(mysegment % 256)) >> 8;
 write(fh,wstr,4);

 wstr[0]=0x18;
 wstr[1]=0x00;
 wstr[2]=mysegment % 256;
 wstr[3]=(mysegment-(mysegment % 256)) >> 8;
 write(fh,wstr,4);

 header.data.ReloCnt+=3;

//-------------------------------------------------
//            APPENDING INTRO CODE
//-------------------------------------------------
 lseek(fh,filelength(fh),SEEK_SET);
 printf("Done.\n\rAppending intro code...               ");
 if ( (fh2=open("INTRO.DAT",O_BINARY | O_RDWR))==-1)
  {
   printf("\n\r  INTRO.DAT not found, appending RET\n\r");
   kar=0xC3;
   write(fh,&kar,1);
  }
 else
  {
   while(!eof(fh2))
    {
     read(fh2,&kar,1);
     write(fh,&kar,1);
    }
   header.data.ReloSS+=(filelength(fh2)+3)/16+16;
   printf("Done.\n\r");
   close(fh2);
  }
 header.data.PageCnt=(filelength(fh) / 512) +1;
 header.write(fh);
 printf("INTRO building was successful. (I hope...)\n\r\n\r");
 close(fh);
}

void hiba(char *st)
{
 cprintf(st);
 exit(-1);
}

void readdata( void )
{
 int stacks,codes;
 lseek(fh,0x06,SEEK_SET);
 read(fh,&relocnt,2);
 read(fh,&hdrsize,2);
 lseek(fh,0x18,SEEK_SET);
 read(fh,&firstitem,2);




 lseek(fh,0x0E,SEEK_SET);
 read(fh,&stacks,2);
 stacks++;
 lseek(fh,0x0E,SEEK_SET);
 write(fh,&stacks,2);

 lseek(fh,0x16,SEEK_SET);
 read(fh,&codes,2);
 codes++;
 lseek(fh,0x16,SEEK_SET);
 write(fh,&codes,2);
}

void Cheader::read( int handle )
{
 lseek(handle,00,SEEK_SET);
 ::read(handle,&header.data,0x1C);
}

void Cheader::write( int handle )
{
 lseek(handle,00,SEEK_SET);
 ::write(handle,&header.data,0x1C);
}