#include <conio.h>
#include <dos.h>

#define TRUE  1
#define FALSE 0

#ifdef __cplusplus
   #define __CPPARGS ...
#else
   #define __CPPARGS
#endif

/*
   ANY = 00;
   ESC      = 01; ONE      = 02; TWO      = 03; THREE   = 04; FOUR     = 05;
   FIVE     = 06; SIX      = 07; SEVEN    = 08; EIGHT   = 09; NINE     = 10;
   ZERO     = 11; MINUS    = 12; EQUAL    = 13; BCKSPC  = 14; TAB      = 15;
   Q        = 16; W        = 17; E        = 18; R       = 19; T        = 20;
   Y        = 21; U        = 22; I        = 23; O       = 24; P        = 25;
   BRA_OPEN = 26; BRA_CLOS = 27; ENTER    = 28; CTRL    = 29; A        = 30;
   S        = 31; D        = 32; F        = 33; G       = 34; H        = 35;
   J        = 36; K        = 37; L        = 38; SEMICOL = 39; APOSTROF = 40;
   QUOTMARK = 41; SHLEFT   = 42; BCKSLASH = 43; Z       = 44; X        = 45;
   C        = 46; V        = 47; B        = 48; N       = 49; M        = 50;
   COMMA    = 51; POINT    = 52; SLASH    = 53; SHRIGHT = 54; STAR     = 55;
   ALT      = 56; SPACE    = 57; CAPS     = 58; F1      = 59; F2       = 60;
   F3       = 61; F4       = 62; F5       = 63; F6      = 64; F7       = 65;
   F8       = 66; F9       = 67; F10      = 68; NUMLOCK = 69; SCROLL   = 70;
   HOME     = 71; UP       = 72; PGUP     = 73; GMINUS  = 74; LEFT     = 75;
   NUM5     = 76; RIGHT    = 77; GPLUS    = 78; ENDE    = 79; DOWN     = 80;
   PGDN     = 81; INS      = 82; DEL      = 83; SYS     = 84;


   CKey           : array [0..84] of char = ('?',
   '?', '1', '2', '3', '4', '5', '6', '7',
   '8', '9', '0', '-', '=', '?', '?', 'Q',
   'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O',
   'P', '[', ']', '?', '?', 'A', 'S', 'D',
   'F', 'G', 'H', 'J', 'K', 'L', ';', '?',
   '?', '?', '\', 'Z', 'X', 'C', 'V', 'B',
   'N', 'M', ',', '.', '/', '?', '*', '?',
   ' ', '?', '?', '?', '?', '?', '?', '?',
   '?', '?', '?', '?', '?', '?', '?', '?',
   '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?' );
*/


char key[85];
void interrupt (*keyboardvector)(__CPPARGS);
unsigned char lastkey;
char keyintstat;

void  initkey( void );
void  endkey( void );
char  pressedkey( void );
void  resetkey( void );
void  thestart( void );

#pragma startup thestart


void interrupt mainkeyproc(__CPPARGS )
{
unsigned char pkey,
	      in61,
	      in61store;

   pkey=inportb(0x60);
   in61=inportb(0x61);
   in61store= in61;
   in61=(in61 | 0x80);

   outportb(0x61,in61);
   outportb(0x61,in61store);
   outportb(0x20,0x20);

   if (pkey < 85)
      {
	 key[0]=TRUE;


	 key[pkey]= TRUE;

	 lastkey= pkey;
      }
   else
      {
	pkey=(pkey & 127);

	key[pkey]=FALSE;
      }
}

void initkey( void )
{
 int ii;
 void interrupt (*pp)(__CPPARGS);
 pp=getvect(0x09);
 if (pp != &mainkeyproc)
   keyboardvector=getvect(0x09);


 for(ii=0 ; ii<=84 ; ii++) key[ii]= FALSE;
 lastkey=0;
 setvect(0x09,mainkeyproc);
 keyintstat=TRUE;
}

void endkey( void )
{
 setvect(0x09,keyboardvector);
 keyintstat=FALSE;
}


char pressedkey( void )
{
  char akey;
  akey=key[0];
  key[0]=FALSE;
  return(akey);
}

void resetkey( void )
{
 key[0]=FALSE;
}

void thestart( void )
{
 keyboardvector=getvect(0x09);
 keyintstat=FALSE;
}

/*
void main( void )
{
 thestart();
 initkey();
 while(!key[01]);
 endkey();
}
*/

char megnyom( char mit )
{
 if (key[mit])
  {
   key[mit]=0;
   return(1);
  }
 return(0);
}
