/****************************************************************************/
/*	NAME:  ultramid.h                                                   */
/* 	COPYRIGHT:                                                          */
/* 	"Copyright (c) 1991,1992,1993 by Forte Technologies                 */
/*                                                                          */
/*        "This software is furnished under a license and may be used,      */
/*        copied, or disclosed only in accordance with the terms of such    */
/*        license and with the inclusion of the above copyright notice.     */
/*        This software or any other copies thereof may not be provided or  */
/*        otherwise made available to any other person. No title to and     */
/*        ownership of the software is hereby transfered."                  */
/****************************************************************************/
/*  CREATION DATE: 04/01/93                                                 */
/*--------------------------------------------------------------------------*/
/*     VERSION	DATE	   NAME		DESCRIPTION                         */
/*>	1.0	04/01/93   ultramid.h   main interface to UltraMID          */
/****************************************************************************/
/* calling parameters to ULTRAMID TSR */
/* AX should have a function request */
/* digital functions */

#define TSR_START_DIGITAL	    0
#define TSR_PLAY_NEXT_BUFFER	    1
#define TSR_SET_PAN	    	    2
#define TSR_SET_VOLUME	    	    3
#define TSR_SET_RATE	    	    4
#define TSR_PAUSE_DIGITAL	    5
#define TSR_RESTART_DIGITAL	    6
#define TSR_STOP_DIGITAL	    7
#define TSR_GET_DIGITAL_POSITION    8
#define TSR_VOICE_STATUS	    9
/* MIDI functions */
#define TSR_LOAD_MIDI_PATCHES	    10
#define TSR_LOAD_XMIDI_PATCHES	    11
#define TSR_LOAD_PATCH	    	    12
#define TSR_UNLOAD_PATCH	    13
#define TSR_START_SEQUENCE	    14
#define TSR_UNLOAD_ALL_PATCHES	    15
#define TSR_MIDI_OUT	    	    16
#define TSR_MIDI_OUT_STR	    17
#define TSR_ALL_NOTES_OFF	    18
/* resource functions */
#define TSR_ALLOCATE_MEMORY	    19
#define TSR_FREE_MEMORY		    20
#define TSR_FREE_TSR		    21
#define TSR_SEM_ENTER		    22
#define TSR_SEM_LEAVE		    23
#define TSR_ADD_EXTERNAL_SEMAPHORE  24
#define TSR_CLEAR_EXTERNAL_SEMAPHORE 25
#define TSR_APP_START		    26
#define TSR_APP_END		    27
#define TSR_SET_MIDI_CALLBACK	    28
#define TSR_CLEAR_MIDI_CALLBACK	    29

/* data type */
#define UM_8BIT		1	/* 1 use 8 bit data */
				/* 0 use 16 bit data */
#define UM_PRELOAD	2	/* preload data */
#define UM_INVERT_MSB	4	/* invert most significant bit during dma */
#define UM_STEREO	8	/* 1 for stereo data */

#define UM_STOP_SOUND	0
#define UM_MORE_DATA	1
#define UM_BUFFER_DONE	2
#define UM_PAUSE	3

#define UM_ERR_FRAMING  16
#define UM_ERR_OVERRUN  32

struct um_sound_struct {
	char far *sound_data;
	char far *stereo_mem;
	unsigned long sound_len;
	unsigned long gf1mem;
	unsigned char pan;
	unsigned short volume;
	unsigned short sample_rate;
	unsigned short priority;
	unsigned char data_type;
	int (far *callback)();
};
