{  TPMOUSE.PAS

   Noll Jnos
    1990 / 91
}
Unit tpmouse;

Interface
Type
 mcursor=array[1..2,1..16]of word;
Const
 MNoCursor=0;
 MHCursor =1;
 MSCursor =2;
Var
 MousePresent:boolean;
 MCursorState: byte;
Function Mouse_installed:boolean;
Procedure Define_Graphic_Cursor(crs:mcursor;hotx,hoty:byte);

procedure Enable_Software_Cursor;
procedure Enable_Hardware_Cursor(start,stop:integer);
procedure Disable_Cursor;

procedure Read_Mouse_Position(var x,y : integer);
function mouse_x_position : integer;
function mouse_y_position : integer;
function left_button_pressed : boolean;
function right_button_pressed : boolean;
function middle_button_pressed : boolean;
procedure set_mouse_position(x,y:integer);
procedure button_state(var b,x,y:integer);
procedure button_release_state(var b,x,y:integer);
procedure mouse_window(x1,y1,x2,y2:integer);
procedure mouse_move(var x,y:integer);
procedure enable_light_pen_emulation;
procedure disable_light_pen_emulation;
procedure mouse_sensivity(x,y:integer);
procedure double_speed_mode(v:integer);
procedure disable_double_speed_mode;

implementation

uses crt,dos;

Function Mouse_installed:boolean;
var
 register : Registers;
begin
 with register do
  begin
   ax:=0;
   intr(51,register);
   Mouse_installed:=(ax<>0)
  end
end;

Procedure Define_Graphic_Cursor;
Var
 r:registers;
Begin
 r.ax:=9;
 r.es:=seg(crs);
 r.DX:=ofs(crs);
 r.BX:=hotx;
 r.CX:=hoty;
 intr(51,r);
End;

Procedure Enable_software_cursor;
var
 register : Registers;
begin
 with register do
  begin
    ax:=1;
    intr(51,register);
    ax:=10;
    bx:=0;
    cx:=$FFFF;
    dx:=$7700;
    intr(51,register)
  end;
 MCursorState:=MSCursor;
end;

Procedure Enable_hardware_cursor;
var
 register:Registers;
begin
 with register do
  begin
    ax:=10;
    bx:=1;
    cx:=start;
    dx:=stop;
    intr(51,register);
    ax:=1;
    intr(51,register)
  end;
 MCursorState:=MHCursor;
end;

Procedure Disable_cursor;
var
  register:Registers;
begin
 register.ax:=2;
 intr(51,register);
 MCursorState:=MNoCursor;
end;
Procedure Read_mouse_position;
 var
   register:Registers;
 begin
   with register do
     begin
      register.ax:=3;
      intr(51,register);
      x:=cx;
      y:=dx;
     end
 end;
Function Mouse_x_position;
 var
   register:Registers;
 begin
   register.ax:=3;
   intr(51,register);
   Mouse_x_position:=register.cx;
 end;
Function Mouse_y_position;
 var
   register:Registers;
 begin
   register.ax:=3;
   intr(51,register);
   Mouse_y_position:=register.dx;
 end;
Function Left_button_pressed;
 var
   register:Registers;
 begin
   with register do
     begin
       ax:=3;
       intr(51,register);
       Left_button_pressed:=(bx MOD 2=1)
     end
 end;
Function Right_button_pressed;
 var
   register:Registers;
 begin
   with register do
     begin
       ax:=3;
       intr(51,register);
       Right_button_pressed:=((bx DIV 2)MOD 2=1)
     end
 end;
Function Middle_button_pressed;
 var
   register:Registers;
 begin
   with register do
     begin
       ax:=3;
       intr(51,register);
       Middle_button_pressed:=((bx DIV 4)MOD 2=1)
     end
 end;
Procedure Set_mouse_position;
 var
   register:Registers;
 begin
   with register do
     begin
       ax:=4;
       cx:=x;
       dx:=y;
       intr(51,register)
     end
 end;
Procedure Button_state;
 var
   register:Registers;
 begin
   with register do
     begin
       if (b>0) and (b<4) then
         begin
          ax:=5;
          bx:=b;
          intr(51,register);
          b:=bx;
          x:=cx;
          y:=dx;
         end
       else
         begin
          b:=0;
          x:=0;
          y:=0;
         end
     end
 end;
Procedure Button_release_state;
 var
   register:Registers;
 begin
   if (b>=0) and (b<4) then
     begin
       with register do
         begin
           ax:=6;
           bx:=b;
           intr(51,register);
           b:=bx;
           x:=cx;
           y:=dx;
         end
     end
   else
     begin
       b:=0;
       x:=0;
       y:=0;
     end
 end;
Procedure Mouse_window;
 var
  register:Registers;
  z       :integer;
 begin
   with register do
     begin
       if x2<x1 then
         begin
           z:=x1;
           x1:=x2;
           x2:=z;
         end;
       if y2<y1 then
         begin
           z:=y1;
           y1:=y2;
           y2:=z;
         end;
       ax:=7;
       cx:=x1;
       dx:=x2;
       intr(51,register);
       ax:=8;
       cx:=y1;
       dx:=y2;
       intr(51,register);
     end
 end;
Procedure Mouse_move;
 var
   register:Registers;
 begin
   with register do
     begin
       ax:=11;
       intr(51,register);
       x:=cx;
       y:=dx;
     end;
 end;
Procedure Enable_light_pen_emulation;
 var
   register:Registers;
 begin
   register.ax:=13;
   intr(51,register);
 end;
Procedure Disable_light_pen_emulation;
 var
   register:Registers;
 begin
   register.ax:=14;
   intr(51,register);
 end;
Procedure Mouse_sensivity;
 var
   register:Registers;
 begin
   with register do
     begin
       ax:=15;
       cx:=x;
       dx:=y;
       intr(51,register);
     end
 end;
Procedure Double_speed_mode;
 var
   register:Registers;
 begin
   register.ax:=19;
   register.dx:=v;
   intr(51,register)
 end;
Procedure Disable_double_speed_mode;
 var
   register:Registers;
 begin
   register.ax:=19;
   register.dx:=32767;
   intr(51,register)
 end;
{=====================================}
begin
 MCursorState:=MNoCursor;
 if not mouse_installed then
  MousePresent:=True
 else
  MousePresent:=False;
end.