#include <io.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include "szallev.h"

/*
struct Tszallev
       {
        unsigned char arukod;
        unsigned char kber;
        unsigned char kcel;
        unsigned int  atvar,
                      leszar,
                      zalert,
                      visszavalt,
                      biztositas,
                      suly;
        unsigned char lesz;
        unsigned char number;
       }
         szallev;
*/

struct  Tszallev szallev;

char buf[80];
int  printer;
int  szallfile;
int  bsel,csel,asel;
int  fp;

/*******
#define KNUM 6-1
char *kvar[KNUM+1] = {
                   "London",
                   "Bombay",
                   "Hongkong",
                   "Elefntcsontpart",
                   "Boston",
                   "Belem"
                   };

#define ANUM 17
char *arunev[ANUM+1] = {
                     "Gyapot",
                     "Nyersbr",
                     "Selyemruk",
                     "Vasruk",
                     "Tea",
                     "tolaj",
                     "Fegyverek",
                     "Kv",
                     "Textlik",
                     "Faruk",
                     "Selyem",
                     "Nyersgumi",
                     "S",
                     "Vasrudak",
                     "Textilruk",
                     "Elefntcsont",
                     "Brruk",
                     "Cukor"
                     };
*******/

void szalsave(  int num, Tszallev *szal_be );
void szalload(  int num, Tszallev *szal );

void szallprint( Tszallev szal_be);

void szalpos( int no );

void nyomtat( void );
void szallkiir( void );
void adatbeker(void);
void statisztika( void );

void elnyelo(void);

void println(char *be );

void main(void)
{
 int c;


 printer = 4;
// REKSIZE = sizeof(Tszallev);

 if ( (szallfile = open("szallev.dat",O_RDWR | O_BINARY) )==-1 )
  {
   if ( (szallfile = open("szallev.dat",O_RDWR | O_CREAT | O_BINARY))==-1 )
    {
     exit(1);
    }
   szallev.arukod = 0;
   szallev.kber = 0;
   szallev.kcel = 0;
   szallev.atvar = 0;
   szallev.leszar = 0;
   szallev.suly   = 0;
   szallev.zalert = 0;
   szallev.visszavalt = 0;
   szallev.biztositas = 0;
   szallev.lesz = 255;

   for (c=0 ; c<=90 ; c++)
    {
     szalsave(c,&szallev);
    }
  }

 int ch;
 do
  {
  printf("\n\n\r-= Menu =-\n\r");
  printf("1 - Adatbevitel\n\r");
  printf("2 - Adatok megnzse\n\r");
  printf("3 - Nyomtats\n\r");
  printf("4 - Statisztika\n\r");
  printf("X - Kilps\n\r");
  printf(" =>");
  do
   {
    ch=toupper(getch());
   }
  while (!( (ch>='0' && ch<='4') || (ch=='X') ));
  printf("%c\n\r",ch);
  switch (ch)
   {
    case '1':adatbeker();
             break;
    case '2':szallkiir();
             break;
    case '3':nyomtat();
             break;
    case '4':statisztika();
             break;
   }
  }
 while (!(ch=='X'));

 close(szallfile);
}

void szallprint( int szam,Tszallev szal_be )
{
 sprintf(buf,"Ŀ\r\n" );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"Ŀ\r\n" );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"        Szlltlevl       #%-3d \r\n",szam);
 write(printer,buf,strlen(buf) );

 sprintf(buf,"Ĵ\r\n" );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"   %16s              \r\n",arunev[szal_be.arukod] );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"Ĵ\r\n" );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Berakods:   %16s  \r\n",kvar[szal_be.kber] );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Clkikt:   %16s  \r\n",kvar[szal_be.kcel] );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  tvteli r:           %4d   \r\n",szal_be.atvar );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Leszlltsi r:       %4d   \r\n",szal_be.leszar );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Zlogrtk:            %4d   \r\n",szal_be.zalert   );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Visszavlts:          %4d   \r\n",szal_be.visszavalt );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Biztosts:            %4d   \r\n",szal_be.biztositas );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"  Rakodsi sly:         %4d t  \r\n",szal_be.suly );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"ٳ\r\n" );
 write(printer,buf,strlen(buf) );

 sprintf(buf,"\r\n" );
 write(printer,buf,strlen(buf) );

}

void println( char *be)
{
 write(printer,be,strlen(be) );
}

void elnyelo(void)
{
 while (kbhit)
  getch();
}

void kvalaszt( int *sel )
{
 int sx,sy;
 int ch,ch2;

 sx=wherex();
 sy=wherey();
 printf("%s",kvar[*sel]); clreol(); gotoxy(sx,sy);
 do
  {
   switch (ch=toupper(getch()))
    {
     case '\x0':switch ( ch2=getch() )
                 {
                  case 72:
                  case 75:*sel=*sel>0 ? *sel-1 : KNUM;
                          break;
                  case 80:
                  case 77:*sel=*sel<KNUM ? *sel+1 : 0;
                          break;
                 }
                gotoxy(sx,sy);
                printf("%s",kvar[*sel]); clreol(); gotoxy(sx+*sel,sy);
                break;
     case 'L':
     case 'B':
     case 'H':
     case 'E':*sel=*sel<KNUM ? *sel+1 : 0;
              while (!(kvar[*sel][0]==ch ))
               *sel=*sel<KNUM ? *sel+1 : 0;
              gotoxy(sx,sy);
              printf("%s",kvar[*sel]); clreol(); gotoxy(sx+*sel,sy);
              break;
    }
  }
 while (!( ch==13 ));
}

void avalaszt( int *sel )
{
 int sx,sy;
 int ch,ch2;

 sx=wherex();
 sy=wherey();
 printf("%s",arunev[*sel]); clreol(); gotoxy(sx,sy);
 do
  {
   switch (ch=toupper(getch()))
    {
     case '\x0':switch ( ch2=getch() )
                 {
                  case 72:
                  case 75:*sel=*sel>0 ? *sel-1 : ANUM;
                          break;
                  case 80:
                  case 77:*sel=*sel<ANUM ? *sel+1 : 0;
                          break;
                 }
                gotoxy(sx,sy);
                printf("%s",arunev[*sel]); clreol(); gotoxy(sx+*sel,sy);
                break;
     case 'E':ch = '';
     case '':
     case 'G':
     case 'N':
     case 'S':
     case 'T':
     case 'F':
     case 'V':
     case 'C':
     case 'B':
     case 'K':*sel=*sel<ANUM ? *sel+1 : 0;
              while (!(arunev[*sel][0]==ch ))
               *sel=*sel<ANUM ? *sel+1 : 0;
              gotoxy(sx,sy);
              printf("%s",arunev[*sel]); clreol(); gotoxy(sx+*sel,sy);
              break;
    }
  }
 while (!( ch==13 ));
}

/****************************************************************/
/***  adatbeker - bekri az adatokat                          ***/
/***                                                          ***/
/****************************************************************/
void adatbeker(void)
{
 int szam;
 int ch3;
 Tszallev szlv;

 for (;;)
  {
   printf("\n\rSzlltlevl szma [1..90] (0-kilp): ");
   scanf("%2d",&szam); fflush(stdin);

   if (szam==0)
    break;
   if (szam>=1 || szam<=90)
    {
     szalload(szam,&szlv);
     if (szlv.suly != 0)
      {
       printf("Ez mr ltezik ! :\n\r");
       printf("Ŀ\r\n" );
       printf("        Szlltlevl    #%-3d    \r\n",szam);
       printf("Ĵ\r\n" );
       printf("       %16s          \r\n",arunev[szlv.arukod] );
       printf("Ĵ\r\n" );
       printf("  Berakods:   %16s  \r\n",kvar[szlv.kber] );
       printf("  Clkikt:   %16s  \r\n",kvar[szlv.kcel] );
       printf("  tvteli r:           %4d   \r\n",szlv.atvar );
       printf("  Leszlltsi r:       %4d   \r\n",szlv.leszar );
       printf("  Zlogrtk:            %4d   \r\n",szlv.zalert   );
       printf("  Visszavlts:          %4d   \r\n",szlv.visszavalt );
       printf("  Biztosts:            %4d   \r\n",szlv.biztositas );
       printf("  Rakodsi sly:         %4d t  \r\n",szlv.suly );
       printf("\r\n" );
       printf("Fellrjam [I/N] : ");
       ch3=toupper(getch());
       printf("%c\n\r",ch3);
       if (ch3 != 'I')
        break;
      }

     printf("\n\rru         : ");
     avalaszt( &asel );
     szallev.arukod = asel;

     printf("\n\rBerakods   : ");
     kvalaszt( &bsel );
     szallev.kber = bsel;

     printf("\n\rClkikt   : ");
     kvalaszt( &csel );
     szallev.kcel = csel;

     printf("\n\rtvteli r     : "); scanf("%4d",&szallev.atvar ); fflush(stdin);
     printf("Leszlltsi r : "); scanf("%4d",&szallev.leszar ); fflush(stdin);
     printf("Zlogrtk      : "); scanf("%4d",&szallev.zalert   ); fflush(stdin);
     printf("Visszavlts    : "); scanf("%4d",&szallev.visszavalt ); fflush(stdin);
     printf("Biztosts      : "); scanf("%4d",&szallev.biztositas ); fflush(stdin);
     printf("Rakodsi sly   : "); scanf("%4d",&szallev.suly ); fflush(stdin);
     szallev.lesz=0;

     if (!((szallev.atvar < szallev.leszar) && (szallev.atvar > szallev.zalert )
        && (szallev.zalert < szallev.visszavalt ) && (szallev.kber != szallev.kcel) ) )
       printf("Hiba !\x7\r\n");
     szalsave(szam,&szallev);
    }
  }
}

void szallkiir( void )
{
 Tszallev szl;
 int szam;

 printf("\n\rSzlltlevl szma [1..90] : ");
 scanf("%2d",&szam); fflush(stdin);

 szalload(szam, &szl );

 printf("Ŀ\r\n" );
 printf("        Szlltlevl    #%-3d    \r\n",szam);
 printf("Ĵ\r\n" );
 printf("       %16s          \r\n",arunev[szl.arukod] );
 printf("Ĵ\r\n" );
 printf("  Berakods:   %16s  \r\n",kvar[szl.kber] );
 printf("  Clkikt:   %16s  \r\n",kvar[szl.kcel] );
 printf("  tvteli r:           %4d   \r\n",szl.atvar );
 printf("  Leszlltsi r:       %4d   \r\n",szl.leszar );
 printf("  Zlogrtk:            %4d   \r\n",szl.zalert   );
 printf("  Visszavlts:          %4d   \r\n",szl.visszavalt );
 printf("  Biztosts:            %4d   \r\n",szl.biztositas );
 printf("  Rakodsi sly:         %4d t  \r\n",szl.suly );
 printf("\r\n" );
}

/*****************************************\
*                                         *
* Load - Save                             *
*                                         *
\*****************************************/
void szalload( int num, Tszallev *szal )
{
 szalpos( num );
                 // lseek(szallfile,(REKSIZE * num)-2,SEEK_SET);
 read(szallfile, szal ,REKSIZE );
}

void szalsave( int num, Tszallev *szal_be )
{
 szalpos( num );
 write(szallfile, szal_be ,REKSIZE );
}


void szalpos( int no )
{
 lseek(szallfile,REKSIZE * no,SEEK_SET);
}

/*****************************************\
*                                         *
*                                         *
*                                         *
\*****************************************/
void nyomtat( void )
{
 Tszallev szl;
 int szam;


 printf("\n\rSzlltlevl szma [1..90] : ");
 scanf("%2d",&szam); fflush(stdin);

   // szalpos( szam );
 szalload(szam, &szl );

 szallprint( szam,szl );
}

void statisztika( void )
{
 int c;
 int szam;
 Tszallev szl;
 Tszallev szlv;

 printf("\n\rBevitt lapok (*) : \n\r");
 for (c=1 ; c<=90 ; c++ )
  {
   szalload(c, &szlv );
   if (szlv.suly == 0)
    printf("-");
   else
    printf("*");
  }
 printf("\n\r");

 for (c=1 ; c<=90 ; c++ )
  {
   szam=c;
   szalload(szam, &szl );

   printf("Ŀ\r\n" );
   printf("        Szlltlevl    #%-3d    \r\n",szam);
   printf("Ĵ\r\n" );
   printf("       %16s          \r\n",arunev[szl.arukod] );
   printf("Ĵ\r\n" );
   printf("  Berakods:   %16s  \r\n",kvar[szl.kber] );
   printf("  Clkikt:   %16s  \r\n",kvar[szl.kcel] );
   printf("  tvteli r:           %4d   \r\n",szl.atvar );
   printf("  Leszlltsi r:       %4d   \r\n",szl.leszar );
   printf("  Zlogrtk:            %4d   \r\n",szl.zalert   );
   printf("  Visszavlts:          %4d   \r\n",szl.visszavalt );
   printf("  Biztosts:            %4d   \r\n",szl.biztositas );
   printf("  Rakodsi sly:         %4d t  \r\n",szl.suly );
   printf("\r\n" );
   getch();
  }
}