; Function:     Display a character in native EGA and VGA graphics modes
;
; Caller:       Microsoft C:
;
;                       void DisplayChar10(c,x,y,fgd,bkgd);
;
;                       int c;                  /* character code */
;
;                       int x,y;                /* upper left pixel */
;
;                       int fgd,bkgd;           /* foreground and background
;                                                   pixel values */
;

;ARGc            EQU     word ptr [bp+4] ; stack frame addressing
;ARGx            EQU     word ptr [bp+6]
;ARGy            EQU     word ptr [bp+8]
;ARGfgd          EQU     byte ptr [bp+10]
;ARGbkgd         EQU     byte ptr [bp+12]

ARGx            EQU     word ptr [bp+4] ; stack frame addressing
ARGy            EQU     word ptr [bp+6]
ARGblockoff     EQU     word ptr [bp+8]
ARGblockseg     EQU     word ptr [bp+10]

VARxs           EQU              [bp-2]
VARys           EQU              [bp-4]
VARy            EQU              [bp-6]

;BytesPerLine    =       80              ; (must 40 in 320x200 16-color mode)
;RMWbits         =       18h             ; Read-Modify-Write bits

_TEXT           SEGMENT byte public 'CODE'
                ASSUME  cs:_TEXT

                ;EXTRN   PixelAddr10:near

                EXTRN   _backseg:word

                PUBLIC  _OutBlock,_scrtoback,_OutBlockBack,_swapscreens
                PUBLIC  _OutBlockW,_OutBack

_OutBlock       PROC    near

                push    bp              ; preserve caller registers
                mov     bp,sp
                sub     sp,6            ; stack space for local variable
.386
                PUSHA

                ;LEA     DI,[EBP+EBP*4]
                MOV     AX,ARGy
                MOV     VARy,AX
                MOV     AX,ARGblockseg
                MOV     FS,AX
                MOV     AX,0A000h
                MOV     ES,AX
                MOV     BX,ARGblockoff
                MOV     AX,FS:[BX]
                MOV     VARxs,AX
                MOV     AX,FS:[BX+2]
                MOV     VARys,AX
                ADD     BX,4
                MOV     SI,BX
                CLD
                ; FS:SI -> ES:... majd
ujsor:
                MOV     AX,VARy
                MOV     BX,320
                MUL     BX
                ADD     AX,ARGx
                INC     word ptr VARy
                MOV     DI,AX

                MOV     cx,VARxs
sorpix:         MOV     AL,FS:SI
                CMP     AL,255
                JZ      kihagy
                MOV     ES:DI,AL
kihagy:
                INC     SI
                INC     DI
                LOOP    sorpix

                DEC     word ptr VARys
                MOV     AX,VARys
                CMP     AX,0
                JA      ujsor

                POPA
                mov     sp,bp
                pop     bp
                ret

_OutBlock       ENDP

_scrtoback      PROC
                PUSH    SI DI

                XOR     SI,SI
                XOR     DI,DI
                MOV     AX,_backseg
                MOV     ES,AX
                MOV     CX,64000/4
                CLD
                MOV     AX,0A000h
                PUSH    DS
                MOV     DS,AX
                REP     MOVSD
                POP     DS

                POP     DI SI
                ret
_scrtoback      ENDP

_OutBlockBack   PROC    near

                push    bp              ; preserve caller registers
                mov     bp,sp
                sub     sp,6            ; stack space for local variable
.386
                PUSHA

                ;LEA     DI,[EBP+EBP*4]
                MOV     AX,_backseg
                MOV     GS,AX
                MOV     AX,ARGy
                MOV     VARy,AX
                MOV     AX,ARGblockseg
                MOV     FS,AX
                MOV     AX,0A000h
                MOV     ES,AX
                MOV     BX,ARGblockoff
                MOV     AX,FS:[BX]
                MOV     VARxs,AX
                MOV     AX,FS:[BX+2]
                MOV     VARys,AX
                ADD     BX,4
                MOV     SI,BX
                CLD
                ; FS:SI -> ES:... majd
xujsor:
                MOV     AX,VARy
                MOV     BX,320
                MUL     BX
                ADD     AX,ARGx
                INC     word ptr VARy
                MOV     DI,AX

                MOV     cx,VARxs
xsorpix:
                MOV     AL,FS:SI
                ;CMP     AL,255
                ;JZ      xkihagy
                MOV     AL,GS:DI
                MOV     ES:DI,AL
xkihagy:
                INC     SI
                INC     DI
                LOOP    xsorpix

                DEC     word ptr VARys
                MOV     AX,VARys
                CMP     AX,0
                JA      xujsor

                POPA
                mov     sp,bp
                pop     bp
                ret

_OutBlockBack   ENDP


_swapscreens    PROC
                PUSH    SI DI

                XOR     SI,SI
                XOR     DI,DI
                MOV     AX,_backseg
                MOV     ES,AX
                MOV     CX,64000/4
                CLD
                MOV     AX,0A000h
                PUSH    DS
                MOV     DS,AX
                ;REP     MOVSD
atrak:
                MOV     EAX,DS:SI
                MOV     EBX,ES:DI
                MOV     DS:SI,EBX
                MOV     ES:DI,EAX

                ADD     SI,4
                ADD     DI,4
                LOOP    atrak
                POP     DS

                POP     DI SI
                ret
_swapscreens    ENDP


_OutBlockW      PROC    near

                push    bp              ; preserve caller registers
                mov     bp,sp
                sub     sp,6            ; stack space for local variable
                PUSHA

                ;LEA     DI,[EBP+EBP*4]
                MOV     AX,_backseg
                MOV     GS,AX
                MOV     AX,ARGy
                MOV     VARy,AX
                MOV     AX,ARGblockseg
                MOV     FS,AX
                MOV     AX,0A000h
                MOV     ES,AX
                MOV     BX,ARGblockoff
                MOV     AX,FS:[BX]
                MOV     VARxs,AX
                MOV     AX,FS:[BX+2]
                MOV     VARys,AX
                ADD     BX,4
                MOV     SI,BX
                CLD
                ; FS:SI -> ES:... majd
yujsor:
                MOV     AX,VARy
                MOV     BX,320
                MUL     BX
                ADD     AX,ARGx
                INC     word ptr VARy
                MOV     DI,AX

                MOV     cx,VARxs
ysorpix:
                MOV     AL,FS:SI
                CMP     AL,255
                JNE     ykihagy
                MOV     AL,GS:DI
ykihagy:                
                MOV     ES:DI,AL

                INC     SI
                INC     DI
                LOOP    ysorpix

                DEC     word ptr VARys
                MOV     AX,VARys
                CMP     AX,0
                JA      yujsor

                POPA
                mov     sp,bp
                pop     bp
                ret

_OutBlockW      ENDP


_OutBack        PROC    near

                push    bp              ; preserve caller registers
                mov     bp,sp
                sub     sp,6            ; stack space for local variable
                PUSHA

                ;LEA     DI,[EBP+EBP*4]
                MOV     AX,ARGy
                MOV     VARy,AX
                MOV     AX,ARGblockseg
                MOV     FS,AX
                MOV     AX,_backseg  ;0A000h
                MOV     ES,AX
                MOV     BX,ARGblockoff
                MOV     AX,FS:[BX]
                MOV     VARxs,AX
                MOV     AX,FS:[BX+2]
                MOV     VARys,AX
                ADD     BX,4
                MOV     SI,BX
                CLD
                ; FS:SI -> ES:... majd
tujsor:
                MOV     AX,VARy
                MOV     BX,320
                MUL     BX
                ADD     AX,ARGx
                INC     word ptr VARy
                MOV     DI,AX

                MOV     cx,VARxs
tsorpix:         MOV     AL,FS:SI
                CMP     AL,255
                JZ      tkihagy
                MOV     ES:DI,AL
tkihagy:
                INC     SI
                INC     DI
                LOOP    tsorpix

                DEC     word ptr VARys
                MOV     AX,VARys
                CMP     AX,0
                JA      tujsor

                POPA
                mov     sp,bp
                pop     bp
                ret

_OutBack        ENDP



_TEXT           ENDS

                END
