#include <string.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>

#include "..\SPR\spr320.h"
#include "..\GIF\gifload.h"

char far *VGAaddr = (char far *)MK_FP(0xA000,0);

void vsprite::setname( char *fnev )
{
 strcpy(filename,fnev);
}

void vsprite::load(char *pal)
{
 kep=(char far*)farmalloc(64000);
 kep2=(char far*)farmalloc(64000);

 loadGIF320(filename,pal,kep);
}

void vsprite::setelem(int num, int x, int y, int xs, int ys)
{
 vselem v;

 v.x=x;
 v.y=y;
 v.xs=xs;
 v.ys=ys;
 v.sxo=0;
 v.syo=0;
 v.oldx=321;
 v.oldy=201;
 v.used1=0;

 el[num]=v;
}

void vsprite::put(int elem, int x, int y)
{
 int c,d;

 vselem v=el[elem];

 for (c=0; c<v.xs; c++)
  for (d=0; d<v.ys; d++)
   VGAaddr[(x+c)+(y+d)*320]=kep[(v.x+c)+(v.y+d)*320];
}

void vsprite::sput(int elem, int x, int y)
{
 int c,d;
 register xx;

 vselem v=el[elem];

 for (c=0; c<v.xs; c++)
  for (d=0; d<v.ys; d++)
   {
    xx=kep[(v.x+c)+(v.y+d)*320];
    if (xx!=0)
     VGAaddr[(x+c)+(y+d)*320]=xx;
   }
}

#define ISINTERVAL(x1,ii,x2)   ((x1)<=(ii) && (ii)<=(x2))
#define XYADDR(xx,yy)          (xx+(yy)*320)

void vsprite::tput(int elem, int x, int y)
{
 int c,d;
 register xx;
 int xdiff,ydiff;

 vselem v=el[elem];

 if (v.used1)
  {
   for (c=0; c<v.xs; c++)
    for (d=0; d<v.ys; d++)
     if (!(ISINTERVAL(x,v.oldx+c,x+v.xs-1) && ISINTERVAL(y,v.oldy+d,y+v.ys-1)))
      VGAaddr[XYADDR(v.oldx+c,v.oldy+d)]=kep2[XYADDR(v.oldx+c,v.oldy+d)];
  }


 xdiff=x-v.oldx;
 ydiff=y-v.oldy;

 for (c=0; c<v.xs; c++)
  for (d=0; d<v.ys; d++)
   if (! (ISINTERVAL(v.oldx, x+c, v.oldx+v.xs-1) &&
	  ISINTERVAL(v.oldy, y+d, v.oldy+v.ys-1) ))
	   kep2[XYADDR(x+c,y+d)]=VGAaddr[XYADDR(x+c,y+d)];

 for (c=0; c<v.xs; c++)
  for (d=0; d<v.ys; d++)
   {
    xx=kep[XYADDR(v.x+c,v.y+d)];
    //if (xx!=0)
    VGAaddr[XYADDR(x+c,y+d)]=xx;
   }

 v.sxo+=((v.sxo+xdiff)%(v.xs+1));
 v.syo+=((v.syo+ydiff)%(v.ys+1));
 v.oldx=x;
 v.oldy=y;

 v.used1=1;

 el[elem]=v;
}

int vsprite::animate( sanim *sa )
{
 // sa[0]: .elem-ben a maxframe (sa[0] nlkl)
 //        .x-ben az ahol tartunk (sa[0]=0., kezdetben 1)

 int pos=sa[0].x;
 if (pos==0) pos=1;

 sanim* s;

 while (pos<sa[0].elem)
  {
   s=&sa[pos];
   pos++;
   if (s->elem==-1) // if end of this frame
    break;

   tput(s->elem,s->x,s->y);
  }
 sa[0].x=pos;
 return(pos);
}

void vsprite::loaddat( char *fnev )
{
 int f;
 f=open(fnev,O_RDONLY|O_BINARY);
 if (f==-1)
  return;

 int darab,c;
 f_elem fe;

 read(f,&darab,2);
 for (c=1;c<=darab;c++)
  {
   read(f,&fe,sizeof(fe));
   setelem(c,fe.x,fe.y,fe.xs,fe.ys);
  }
}

vsprite::vsprite( void )
{
 vankep=0;
 maxelem=0;
}

vsprite::~vsprite( void )
{
 if (kep) farfree(kep);
 if (kep2) farfree(kep2);
}



