/***********************************************\
*                                               *
*            NOWPWM interface                   *
*                                               *
\***********************************************/

#include <dos.h>
#include <string.h>

#define BYTE unsigned char

typedef struct {
  int  Sign;		/* FirstByte sign */
  BYTE minor, major;	/* ? Version number ? */
  int (far *Entry)(void);
} SpeakInit;

#define BUFFLEN 254

typedef struct {
  BYTE length;
  BYTE buff[BUFFLEN];
} SpeakBuff;

typedef struct {
  int female;
  int treble;
  int volume;
  int pitch;
  int speed;
  int unknow[2];
} SpeakParam;

SpeakInit  far *Si;
SpeakBuff  far *Sb;
SpeakParam far *Sp;

struct REGPACK rp;
/*
Ŀ
                                                
 int CheckSpeak ( void )                        
                                      
 A NOWPWM program jelenltt (a memriban)     
 ellenrzi.                                     
 Visszatrsi rtk : 0 - Nincs jelen           
                      1 - Jelen van             
*/
int CheckSpeak(void)
{
  rp.r_ax = 0xfbfb;	/* FirstByte signon */
  intr(0x2f, &rp);
  if (rp.r_ax)
    return 0;
  Si = MK_FP(rp.r_es, rp.r_bx);
  Sb = MK_FP(rp.r_es, rp.r_bx+0x0020);
  Sp = MK_FP(rp.r_es, rp.r_bx+0x0220);
  return 1;
}
/*
Ŀ
                                                
 int SetSpeakParam ( int v , int p , int s )    
                                   
 A beszd paramtereit lltja be               
 v - volume ( hanger )                         
 p - pitch                                      
 s - speed  ( sebessg )                        
 Visszatrsi rtk :    ???                    
                                                
*/
int SetSpeakParam(int v, int p, int s)
{
  Sp->volume = v;
  Sp->pitch  = p;
  Sp->speed  = s;
  asm mov al, 2;
  return Si->Entry();
}
/*
Ŀ
                                                
 int Speak ( char *str )                        
                                           
 A beszl fggvny                             
 ( elmondja a  str-t )                          
 Visszatrsi rtk :    ???                    
                                                

*/
int Speak(char *str)
{
  Sb->length  = strlen(str)+1;
  *(Sb->buff) = 0;
  strcpy((char *)(Sb->buff+1), str);
  asm mov al,7
  return Si->Entry();
}

