#include <stdio.h>
#include <alloc.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include "..\SND\sndsys.h"

char far *ssdriver_mem = NULL;
char far *drv_alap = NULL;
void far (*ssdriver)(void) = NULL;
void far (*SSdrv[20])(void);

int SS_loaded=0;
int SS_inited=0;

enum SS_drivt dr;

void SSSelectSB( void ) { dr=SS_SB; }
void SSSelectGUS( void ) { dr=SS_GUS; }
void SSSelectNONE( void ) { dr=SS_NONE; }
int SSGetSelected( void ) { return dr; }


char *SSGetDriverName( int drv )
{
 static char dd[14];

 strcpy(dd,"");
 if (drv==SS_GUS)
  strcpy(dd,"USMOD.COM");

 if (drv==SS_SB)
  strcpy(dd,"SBMOD.COM");

 return dd;
}


void SSLoadDriver( char far *drv, int dlen )
{
 if (dr==SS_NONE)
  return;

    FILE *f;
    long length;
    char *sp;
    char sn[129];
    unsigned nxx;
    char far *ide;

    strcpy(sn,SSGetDriverName(dr));

    //if (dr==SS_GUS)
    // strcat(sn,"USMOD.COM");
    //else
    // strcat(sn,"SBMOD.COM");

    if (!drv)
     {
      f = fopen(sn,"rb");

      if(!f)
       {
        printf("\r\n\nError: Cannot find ... in Dir !\r\n");
        exit(2);
       }

      length = filelength(fileno(f));
     }
    else
     {
      length=dlen;
     }

    ssdriver_mem = (char far *)farmalloc((int)length + 32+ 0x100);
    if(FP_OFF(ssdriver_mem) != 0)
     {
        drv_alap = (char far *)MK_FP(FP_SEG(ssdriver_mem)+1,0);
	ssdriver = (void (far*)())MK_FP(FP_SEG(ssdriver_mem)+1,0);
	ide = (char far *)MK_FP(FP_SEG(ssdriver_mem)+1,0x100);
        if (drv)
         _fmemcpy(ide,drv,length);
        else
         _dos_read( fileno(f) , ide ,(int)length , &nxx);
     }
    else
     {
      drv_alap = ssdriver_mem;
      ssdriver = (void (far*)())ssdriver_mem;
      ide = ssdriver_mem+0x100;
      if (drv)
       _fmemcpy(ide,drv,length);
      else
       _dos_read( fileno(f) , ide ,(int)length , &nxx);
     }

    int c;
    for (c=0x104;c<=0x148+12;c+=4)
     SSdrv[(c-0x104)/4]=(void (far*)())( MK_FP(FP_SEG(drv_alap),c) );
     //SSdrv[(c-0x104)/4] = (void (far*)())(*((long*)(&drv_alap[c])));

    if (!drv)
     fclose(f);
    SS_loaded=1;
}


void SS_configinit(void)
{
 if (!SS_loaded)
  return;

 asm pusha
 asm push ds
 (*SSdrv[0])();
 asm pop ds
 asm popa
}

int SS_loadmod( char *nev )
{
 if (!SS_loaded)
  return -2;

 _DX=FP_OFF(nev);
 asm pusha
 asm push ds
 (*SSdrv[1])();
 asm pop ds
 asm popa
 asm jnc okvolt
 return -1;
okvolt:
 return 0;
}

void SS_playmusic(void)
{
 if (!SS_loaded)
  return;

 asm pusha
 asm push ds
 (*SSdrv[2])();
 asm pop ds
 asm popa
}


void SS_stopmusic(void)
{
 if (!SS_loaded)
  return;

 asm pusha
 asm push ds
 (*SSdrv[3])();
 asm pop ds
 asm popa
}

void SS_endmusic(void)
{
 if (!SS_loaded)
  return;
 asm pusha
 asm push ds
 (*SSdrv[4])();
 asm pop ds
 asm popa
}

void SS_setvolume( int vol ) // 0-255
{
 if (!SS_loaded)
  return;

 unsigned char volx=vol;

 asm mov BX,0xFFFF // music & fx vol
 asm mov AL,volx;   // master vol
 asm pusha
 asm push ds
 (*SSdrv[10])();
 asm pop ds
 asm popa
}

int SS_getvolume( void ) // 0-255
{
 if (!SS_loaded)
  return 0;

 unsigned char volx;

 asm pusha
 asm push ds
 (*SSdrv[9])();
 asm pop ds
 asm mov volx,al
 asm popa
 return (int(volx));
}


char far *trackbuf, far *patternbuf, far *morebuf;

void SS_makebuf( void )
{
 if (!SS_loaded)
  return;

 trackbuf=(char far *)farmalloc(65536L+16);
 patternbuf=(char far *)farmalloc(2048+16);
 morebuf=(char huge *)farmalloc(131072L+16);

 unsigned int tb=FP_SEG(trackbuf)+1,pb=FP_SEG(patternbuf)+1;
 unsigned int mb=FP_SEG(morebuf)+1;

 asm mov CX,mb
 asm mov BX,pb
 asm mov AX,tb
 asm pusha
 asm push ds
 (*SSdrv[18])();
 asm pop ds
 asm popa
}

void SS_unmakebuf( void )
{
 if (morebuf)
  farfree(morebuf);
}
