#include <fcntl.h>
#include <io.h>
#include <conio.h>
#include <mem.h>
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <stdarg.h>

#include "..\mouse.h"

unsigned int scrseg;
char far *scraddr;
unsigned int mode;
int sorok;
int ksor;

void kepvesz( char *buf );
int  kepbeolvas(char fnev[], char *hova );
void kepkiir( int mod ,char *bf );
void kepopt( int sr=25, int ks=1 );
void box(int x1,int x2,int y1,int y2,char kr[]);
void shadow(int x1,int x2,int y1,int y2);
void kep_startup_init( void );

void ColWrite( char col,char *sztring,...  );
void cursoron( void );
void cursoroff( void );


#pragma startup  kep_startup_init  70

void kepinit( int sr=25, int ks=1 );

/***********************************/

void cursoroff( void )
{ _setcursortype(_NOCURSOR); }

void cursoron( void )
{ _setcursortype(_NORMALCURSOR); }


char *kepalloc(void)
{
 return (char *)malloc(4000);
}

int kepbeolvas(char fnev[], char *hova )
{
 int hf;
 int cc;

 if ( (hf = open (fnev,O_RDONLY | O_BINARY))==-1)
  return(-1);

 read(hf, hova , 80*25*2);
 if (mode==MONO)
  for (cc=1 ; cc<=4000 ; cc+=2 ) hova[cc]=2;

 close(hf);
 return( 0 );
}

/*****************************************************\
* kepkiir( int mod , char *bf )                    *
*                  ^          ^-{ buffer              *
*                  \- megjelenites modja 1-3          *
\*****************************************************/
void kepkiir( int mod ,char *bf )
{
 int c;

 text_info ti;
 gettextinfo(&ti);

 gotoxy(1,1);
 m_shide();
 switch (mod)
  {
   case 0: // Sima
	  movedata( _DS, (unsigned)bf+((ksor-1)*80*2) ,
		     scrseg, ((ksor-1)*80*2), (sorok) * 80 * 2);
	 break;
   case 1: // Alulrl felfel grg
	  textattr(BLACK);
	  for ( c=0 ; c<=sorok-1 ; c++ )
	   {
	    delline();
	    movedata( _DS, (unsigned)bf+(c*80*2) ,
		     scrseg, ((sorok-1-1)*80*2), 80 * 2);
	    m_sshow();
	    delay(20);
	    m_shide();
	   }
	  textattr(ti.attribute);
	 break;

   case 2: // Fellrl lefel grg
	  for ( c=sorok-1 ; c>=0 ; c-- )
	   {
	    insline();
	    movedata( _DS, (unsigned)bf+(c*80*2) , scrseg, (ksor*80*2) , 80 * 2);
            m_sshow();
	    delay(20);
            m_shide();
	   }
	  break;

   case 3: // Specilis: 11-enknt
	  int d;
	  for ( c=0 ; c<11 ; c++ )
	   {
	    for ( d=c; d<=(sorok /*-1*/ )*80 ; d+=11 )
	     {
	      pokeb(scrseg,160*(ksor-1)+d*2+1,bf[d*2+1]);
	      pokeb(scrseg,160*(ksor-1)+d*2,bf[d*2]);
	     }
            m_sshow();
	    delay(65);
            m_shide();
	   }
	  break;

   case 4: // Csepegs
          int csk[80];
	  for ( c=0 ; c<=79 ; c++ ) csk[c]=-random(6)-1;

          for ( d=0 ; d<=25+5 ; d++ )
           {
            for ( c=0 ; c<=79 ; c++ )
             {
              csk[c]++;
              if ( (csk[c]>=(ksor-1)) && (csk[c]<=(sorok-ksor+1)) )
	       movedata( _DS, (unsigned)bf+((csk[c]*80+c)*2) , scrseg, (((ksor+csk[c]-1)*80+c)*2) , 2 );
             }
            m_sshow();
            delay( 90 );
            m_shide();
           }
         break;
  }
 m_sshow();
}

/******************/

void kepinit( int sr, int ks )
{
 struct text_info ti;

 gettextinfo(&ti);
 if (ti.currmode==MONO)
  scrseg=0xB000;
 else
  scrseg=0xB800;
 mode=ti.currmode;
 scraddr=(char far *)MK_FP(scrseg,0);

 sorok=sr;
 ksor=ks;
}

void kepopt( int sr, int ks )
{
 sorok=sr;
 ksor=ks;
}

void kepvesz( char *kb )
{
 m_shide();
 movedata( scrseg, 0 , _DS , (unsigned)kb ,80*(sorok-ksor+1)*2 );
 m_sshow();
}

void box(int x1,int y1,int x2,int y2,char kr[])
{
 int dd;

 m_shide();
 _wscroll=0;
 gotoxy(x1,y1);
 putch(kr[0]);
 for (dd=x1+1 ; dd<=x2-1 ; dd++ ) putch(kr[1]);
 putch(kr[2]);

 for (dd=y1+1 ; dd<=y2-1 ; dd++ )
  {
   gotoxy(x1,dd); putch(kr[3]);
   gotoxy(x2,dd); putch(kr[4]);
  }

 gotoxy(x1,y2);
 putch(kr[5]);
 for (dd=x1+1 ; dd<=x2-1 ; dd++ ) putch(kr[6]);
 putch(kr[7]);

 _wscroll=1;
 m_sshow();
}

void shadow(int x1,int y1,int x2,int y2)
{
 char *buf,*buf2;
 int xc;

 buf=(char *)malloc( (x2-x1+2)*2 );
 buf2=(char *)malloc( (y2-y1+2)*2 );
 m_shide();
 gettext(x1+1,y2,x2,y2,buf);
 //gettext(x2,y1+1,x2,y2,buf2);
 gettext(x2,y1,x2,y2,buf2);
 m_sshow();
 for ( xc=1 ; xc/2<=x2-x1+1 ; xc+=2 )
  {
   buf[xc]=(buf[xc] / 16)*16;
   buf[xc-1]='';
  }

 for ( xc=3 ; xc/2<=y2-y1+1 ; xc+=2 )
  {
   buf2[xc]=0; //buf2[xc] % 16;
  }
 buf2[1]=(buf2[1] / 16)*16;
 buf2[0]='';

 m_shide();
 puttext(x2,y1,x2,y2,buf2);
 puttext(x1+1,y2,x2,y2,buf);
 m_sshow();

 free(buf);
 free(buf2);
}

void kep_startup_init( void )
{
 kepinit();
}


void aprintf( int nattr, int attr2 , char *mit, ... )
{
 //char krt[500]; // jobb lenne feldinamikusan...!!!
 char *krt;
 va_list ap;

 if (!mit) return;

 krt=(char *)malloc(3000); // ennyi remelem eleg...

 va_start( ap,mit );
 vsprintf( krt, mit , ap );
 va_end( ap );

 char *p;
 int cl=0;

 if (nattr==-1)
  {
   struct text_info ti;
   gettextinfo(&ti);
   nattr = ti.attribute;
  }

 m_shide();
 textattr( nattr );
 for ( p=krt ; *p ; p++ )
  {
   if ( *p == '~' )
    {
     if (*(p+1) == '~' )
      {
       putch(*p);
       p++;
      }
     else
      {
       cl=(cl==0) ? 1:0;
       textattr( (cl==0)? nattr : attr2 );
      }
    }
   else
    putch(*p);
  }
 m_sshow();
 textattr(nattr);
 free(krt);
}

void ColWrite( char col,char *sztring,...  )
{
 char cols[2];
 int i;
 char *t;
 char cco=0;
 va_list argptr;
 char bufi[1000];

 va_start(argptr, sztring);
 vsprintf(&bufi[0], sztring, argptr);
 va_end(argptr);

 struct text_info ti;
 gettextinfo(&ti);
 cols[0] = ti.attribute;
 cols[1] = col;

 for (i=0, t=&bufi[0]; i < 1000 && *t; i++, t++)
  if ((*t)!=29) putch(*t);
   else
    { cco=!cco;   textattr(cols[cco]);   }

 textattr(cols[0]);
}

void _16BackColors( int on )
{
 union REGS regs;

 regs.h.ah = 0x10;
 regs.h.al = 3;
 regs.h.bl = (on==1) ? 0 : 1;
 int86(0x10, &regs, &regs);
}

void clearrect( int x1, int y1, int x2, int y2, int attr )
{
 struct text_info ti;
 gettextinfo(&ti);
 window(x1,y1,x2,y2);
 if (attr<16)
  attr*=16;

 textattr(attr);
 clrscr();

 textattr(ti.normattr);
 window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
}
