;
; Reset routine for Soundblaster
; Coded for the SBF by millerje
;

DSP_RESET	equ	6
DSP_DATA_AVAIL	equ	0Eh
DSP_READ_DATA	equ	0Ah

		.MODEL	SMALL         ;;large

		.DATA
		EXTRN	_IOaddr:WORD

		.CODE
		PUBLIC	_InitSB
_InitSB		PROC

; Reset the DSP by sending 1, (delay), then 0
		mov	al,1
		mov	dx,[_IOaddr]
		add	dx,DSP_RESET
		out	dx,al

; Do a wait for I/O
		in	al,dx
		in	al,dx
		in	al,dx
		in	al,dx

		mov	al,0
		mov	dx,[_IOaddr]
		add	dx,DSP_RESET
		out	dx,al

		mov	cx,64h
DataWait:
		mov	dx,[_IOaddr]
		add	dx,DSP_DATA_AVAIL
		in	al,dx
		test	al,80h
		jnz	YesData			;a byte is waiting...
		loop	DataWait

; Timed out- there's no data there
		jmp	short exit

; Data is waiting, if = 0AAh, there's a SB here!
YesData:
		mov	dx,[_IOaddr]
		add	dx,DSP_READ_DATA
		in	al,dx
		cmp	al,0AAh
		je	YepSB			;Found the ID byte
		loop	DataWait		;No, wait for next byte

; timed out- can't find signature
		jmp	short exit

YepSB:
		mov	ax,0
		ret

exit:
		mov	ax,1
		ret

_InitSB		ENDP

		END


