/*
    Example code that uses CT-VOICE.DRV to access the Soundblaster
    DAC channel.
*/

#include <stdio.h>
#include <alloc.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

char far *driver_mem = NULL;
void far (*driver)(void) = NULL;

int SB_installed = 0;
int Loaded = 0;

void LoadDriver( int useenv )
{
    FILE *f;
    long length;
    char *sp;
    char sn[129];
    char sn2[60];
    unsigned nxx;
    char far *ide;

    strcpy(sn,"");

    if (useenv)
     {
      sp = getenv("SOUND");
      if(sp)
      {
	  strcpy(sn,sp);
	  if(sn[strlen(sn)-1] != '\\')
	      strcat(sn,"\\");
          strcat(sn,"DRV\\");
      }
     }

    strcat(sn,"CT-VOICE.DRV");

    f = fopen(sn,"rb");

    if(!f)
     {
      strcpy(sn2,"CT-VOICE.DRV");
      f = fopen(sn2,"rb");

      if (!f)
       {
        printf("\r\n\nError: Cannot find %s !\r\n",sn);
        exit(2);
       }
      //return;
     }

    length = filelength(fileno(f));

    driver_mem = (char far *)farmalloc((int)length + 32);
    if(FP_OFF(driver_mem) != 0)
     {
	driver = (void (far*)())MK_FP(FP_SEG(driver_mem)+1,0);
	ide = (char far *)MK_FP(FP_SEG(driver_mem)+1,0);
        _dos_read( fileno(f) , ide ,(int)length , &nxx);
        //driver=ide;
     }
    else
     {
      driver = (void (far*)())driver_mem;
      ide = driver_mem;
      _dos_read( fileno(f) , ide ,(int)length , &nxx);
     }

    fclose(f);
}

int GetVersion(void)
{
    _BX = 0;
    (*driver)();
    return _AX;
}

void SetIOAddr(int base)
{
    _BX = 1;
    _AX = base;
    (*driver)();
}

void SetIRQ(int irq)
{
    _BX = 2;
    _AX = irq;
    (*driver)();
}

int InitialiseDriver(void)
{
    int sAX;

    _BX = 3;
    (*driver)();

    sAX=_AX;
    SB_installed = (sAX==0);

    return sAX;
}

void UninstallDriver(void)
{
 if (!SB_installed) return;

    _BX = 9;
    (*driver)();

    SB_installed = 0;

    farfree(driver_mem);
}

void SpeakerOnOff(int onoff)
{
 if (!SB_installed) return;

    _BX = 4;
    _AX = onoff & 0x0001;
    (*driver)();
}

void SetStatusWord(unsigned int *addr)
{
 if (!SB_installed) return;

    _BX = 5;
    _ES = FP_SEG(addr);
    _DI = FP_OFF(addr);
    (*driver)();
}

void OutputVoice(char *buffer)
{
 if (!SB_installed) return;
 if (!buffer) return;

 int bs,bo;

    bs = FP_SEG(buffer);
    bo = FP_OFF(buffer);

    _BX = 6;
    _ES = bs;
    _DI = bo;
    (*driver)();
}

void InputVoice(int sample_rate, char *buffer, long length)
{
 if (!SB_installed) return;

    _BX = 7;
    _AX = sample_rate;
    _ES = FP_SEG(buffer);
    _DI = FP_OFF(buffer);
    _DX = (unsigned)(length >> 16);
    _CX = (unsigned)(length & 0x0000ffff);
    (*driver)();
}

void StopVoiceProcess(void)
{
 if (!SB_installed) return;

    _BX = 8;
    (*driver)();
}

int PauseOutputVoice(void)
{
 if (!SB_installed) return(0);

    _BX = 10;
    (*driver)();
    return _AX;
}

int ContinueOutputVoice(void)
{
 if (!SB_installed) return(0);

    _BX = 11;
    (*driver)();
    return _AX;
}

char *LoadVOC(char *name)  // after play, user MUST free buf
{
    FILE *f;
    char *buf;
    long length;

    f = fopen(name,"rb");
    if(!f)
        return NULL;

    length = filelength(fileno(f)) - 0x1a;

    buf = (char *)malloc(/*(int)*/length);
    fseek(f,0x1a,SEEK_SET);
    fread(buf,1,length,f);

    fclose(f);
    return buf;
}

char far * farLoadVOC(char *name)  // after play, user MUST FARfree buf
{
    FILE *f;
    char far *buf;
    long length;
    unsigned xx;
    unsigned long len;

    f = fopen(name,"rb");
    if(!f)
	return NULL;

    length = filelength(fileno(f)) - 0x1a;

    len = length;
    buf = (char far *)farmalloc(/*(int)*/len);
    fseek(f,0x1a,SEEK_SET);
    _dos_read(fileno(f),buf,length,&xx);

    fclose(f);
    return buf;
}

void farOutputVoice(char far *buffer)
{
 if (!SB_installed) return;
 if (!buffer) return;

 int bs,bo;

    bs = FP_SEG(buffer);
    bo = FP_OFF(buffer);

 asm PUSHF
 asm PUSH DI
 asm PUSH ES
 asm PUSH BX

    _BX = 6;
    _ES = bs;
    _DI = bo;
    (*driver)();

 asm POP BX
 asm POP ES
 asm POP DI
 asm POPF
}
