#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <process.h>
#include <alloc.h>
#include <fcntl.h>

#include "sb.h"

/* Card parameters */
unsigned SbIOaddr;
unsigned SbIRQ;
unsigned SbDMAchan;
int	SbType;

extern void WriteFM(int chip, int addr, unsigned char data);

#define __CPPARGS ...

volatile int T_lej = 0;
void interrupt handler(__CPPARGS);
void interrupt ( *oldhandler)(__CPPARGS);

static FM_Instrument instrument = {
    0x11, 0x01, 0x8a, 0x40,
    0xf1, 0xf1, 0x11, 0xb3,
    0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00
};

//                 C#    D     D#     E    F     F#
int notes[12] = {0x16B,0x181,0x198,0x1B0,0x1CA,0x1E5,
		 0x202,0x220,0x241,0x263,0x287,0x2AE};
//                 G     G#    A     A#     B    C

// hangok : 0   1   2    3   4   5    6   7    8   9   A   B
//          C#  D   D#   E   F   F#   G   G#   A   A#  B   C


struct FiledNote
 {
  char octave,ns;
  unsigned dur;
 } far *fn;

float factor[11] = { 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0 };

void main ( int argc, char *argv[] )
{
 SbIOaddr = 0x220;

 long far *tim,t1,t2;
 tim = (long far *)MK_FP(0,0x046C);

 /*
 oldhandler = getvect(0x8);
 setvect(0x8,handler);

 getch();

 T_lej=0;
 printf("\r\n%li\r\n",(t1=*tim));
 WriteFM(0, 4,1<<7);
 WriteFM(0, 4,0 );
// WriteFM(0, 4,0); Reset flags for timers
 WriteFM(0, 3,0); //Timer 2 data

 WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

 do
  {
   printf("%d|",T_lej);
  }
 while ( T_lej<100 );
 setvect(0x08,oldhandler);
 printf("\r\n\nOK!");
 printf("\r\n%li",(t2=*tim));
 printf("  %li",t2-t1);
 getch();
 */


 // if(GetSBParams(&SbIOaddr,&SbIRQ,&SbDMAchan))
 //{
 //    puts("BLASTER environment variable not set.");
 //    exit(1);
 //}
 char far *zene;
 long fhossz;
 int f;
 unsigned int xx;

 f = open(argv[1],O_RDONLY|O_BINARY);
 if (f==-1) exit(1);

 fhossz = filelength(f);
 zene = (char far *)farmalloc(fhossz+1);
 _dos_read(f,zene,fhossz,&xx);
 close(f);

 fn = (FiledNote far *)(FiledNote far *)(&zene[0]);

 Sb_FM_Reset();

 for (xx=0 ; xx<=11 ; xx++)
  Sb_FM_Set_Voice(xx,&instrument);

// Sb_FM_Set_Voice(1,&instrument);
// Sb_FM_Set_Voice(11,&instrument);


// Sb_FM_Key_On(0,notes[11],2);
// Sb_FM_Key_On(1,notes[3],3);
// Sb_FM_Key_On(11,notes[6],3);

// getch();

 int cc;
 int num;

 fn+=5;
 num = (*(long far *)(&fn[0].octave)) & 0xFFFF;
 fn+=4;

 char note,staccato;

 for ( cc=1; cc<=num ; cc++ )
  {
    note = fn->ns >> 4;
    staccato = fn->ns & 0x0F;
    if (staccato>10) staccato=10;
    if (fn->octave>8) fn->octave=8;
    if (fn->octave<1) fn->octave=1;

    if (note==13)
     {
      //Sb_FM_Key_Off(0);
      delay(fn->dur);
     }
    else
     if (1<=note && note<=12)
      {
       Sb_FM_Key_Off(0);
       Sb_FM_Key_On(0,notes[note-1],fn->octave);
       delay(fn->dur * factor[10-staccato]);
       //if (fn->dur > 0)
       // Sb_FM_Key_Off(0);
       delay(fn->dur * factor[staccato]);
      };

   if (kbhit())
    break;
   fn++;
  }

 Sb_FM_Key_Off(0);
 Sb_FM_Key_Off(1);
 Sb_FM_Key_Off(11);

 Sb_FM_Reset();

 if (zene) farfree(zene);
}

void interrupt handler(__CPPARGS)
{
 int val;

 val=inp(SbIOaddr);
 if ( val & (1<<7) )
  {
   T_lej++;
   WriteFM(0, 4,1<<7);
   WriteFM(0, 3,0);
   WriteFM(0, 4,0);
   WriteFM(0, 4,0|2 ); //Reset flags for timers & start T2

   asm MOV AL,0x20
   asm OUT 0x20,AL // send end-of-int
  }
 else
  oldhandler();
}