//
//
// Instrument editor for SB -- by John Zer
//
//
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include <process.h>
#include <ctype.h>
#include "sb.h"

int Sb_Get_Params(void);

FM_Instrument instrument = {
    0x11, 0x01, 0x8a, 0x40,
    0xf1, 0xf1, 0x11, 0xb3,
    0x00, 0x00, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00
};

/* Chromatic scale starting from C# */
int notes[12] = {0x16B,0x181,0x198,0x1B0,0x1CA,0x1E5,
                 0x202,0x220,0x241,0x263,0x287,0x2AE};

#define TRUE  1
#define FALSE 0

#define lobyte(X)   (((unsigned char *)&X)[0])
#define hibyte(X)   (((unsigned char *)&X)[1])

/* Globals */
int num_instruments;
int note_on[22];
char **instrument_table;

/*
typedef struct {
    unsigned char SoundCharacteristic[2];
    unsigned char Level[2];
    unsigned char AttackDecay[2];
    unsigned char SustainRelease[2];
    unsigned char WaveSelect[2];
    unsigned char Feedback;
    unsigned char filler[6];
} FM_Instrument;
*/

void main()
{

    if(Sb_Get_Params())
    {
        puts("BLASTER environment variable not set.");
        exit(1);
    }

    Sb_FM_Reset();

    Sb_FM_Set_Voice(0,&instrument);
    Sb_FM_Set_Voice(1,&instrument);
    Sb_FM_Set_Voice(2,&instrument);
    Sb_FM_Set_Voice(3,&instrument);
    Sb_FM_Set_Voice(4,&instrument);
    Sb_FM_Set_Voice(5,&instrument);
    Sb_FM_Set_Voice(6,&instrument);
    Sb_FM_Set_Voice(7,&instrument);
    Sb_FM_Set_Voice(8,&instrument);


    printf("There are %d instruments in file\n",num_instruments);

    int kilep=0,kar,kar2,stt=0;

    clrscr();
    do
     {
      kar=toupper(getch());
      if (kar==0) kar2=getch();
      switch (kar)
       {
        case ' ':if (stt==0)
                  Sb_FM_Key_On(0,notes[11],2);
                 else
                  Sb_FM_Key_Off(0);
                 stt = (stt==0) ? 1 : 0;
                 printf("\rSound is %s    \r",(stt==1)?"on":"off");
                break;
        case 'Q':// set attack --
                 instrument.AttackDecay[0]--; gotoxy(20,4);
                 printf("\rAttack: %d    \r",instrument.AttackDecay[0]);
                break;
        case 'W':// set attack ++
                 instrument.AttackDecay[0]++; gotoxy(20,4);
                 printf("\rAttack: %d    \r",instrument.AttackDecay[0]);
                break;

        case 'E':// set attack --
                 instrument.AttackDecay[1]--; gotoxy(20,5);
                 printf("\rDecay: %d    \r",instrument.AttackDecay[1]);
                break;
        case 'R':// set attack ++
                 instrument.AttackDecay[1]++; gotoxy(20,5);
                 printf("\rDecay: %d    \r",instrument.AttackDecay[1]);
                break;

        //case  13:// Enter
        //         Sb_FM_Set_Voice(0,&instrument);
        //        break;
        case  27:kilep=1;
                break;
       }
      Sb_FM_Set_Voice(0,&instrument);
      gotoxy(1,1);
     }
    while (!kilep);

    Sb_FM_Key_Off(0);
    Sb_FM_Key_Off(1);
    Sb_FM_Key_Off(2);
    Sb_FM_Key_Off(3);
    Sb_FM_Key_Off(4);
    Sb_FM_Key_Off(5);
    Sb_FM_Key_Off(6);
    Sb_FM_Key_Off(7);
    Sb_FM_Key_Off(8);

    Sb_FM_Reset();
}

